package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * 该功能模型用于记录，基于列表模板的批量业务数据导入详细错误信息
 *
 * @author Keller
 * @create 2020/8/23
 */
@Entity
@Table(name = "engine_form_details_import_box_details")
@ApiModel(value = "FormDetailsImportBoxDetailsEntity", description = "该功能模型用于记录，基于列表模板的批量业务数据导入详细错误信息")
@org.hibernate.annotations.Table(appliesTo = "engine_form_details_import_box_details", comment = "该功能模型用于记录，基于列表模板的批量业务数据导入详细错误信息")
public class FormDetailsImportBoxDetailsEntity extends UuidEntity {
  private static final long serialVersionUID = 8213636805778161890L;

  /**
   * 错误数据行数
   */
  @Column(name = "row_num", nullable = false, columnDefinition = "int(11) COMMENT '错误数据行数'")
  @SaturnColumn(description = "错误数据行数")
  private int rowNum;

  /**
   * 错误信息
   */
  @Column(name = "error_msg", columnDefinition = "varchar(2000) COMMENT '错误信息'")
  @SaturnColumn(description = "错误信息")
  private String errorMsg;

  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "form_details_import_box_id", nullable = false)
  @SaturnColumn(description = "关联导入信息")
  private FormDetailsImportBoxEntity formDetailsImportBoxEntity;

  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("当前项目名工程名")
  @Column(name="project_name", nullable = false, columnDefinition = "varchar(255) default '' comment '工程名'")
  @SaturnColumn(description = "工程名")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public int getRowNum() {
    return rowNum;
  }

  public void setRowNum(int rowNum) {
    this.rowNum = rowNum;
  }

  public String getErrorMsg() {
    return errorMsg;
  }

  public void setErrorMsg(String errorMsg) {
    this.errorMsg = errorMsg;
  }

  public FormDetailsImportBoxEntity getFormDetailsImportBoxEntity() {
    return formDetailsImportBoxEntity;
  }

  public void setFormDetailsImportBoxEntity(FormDetailsImportBoxEntity formDetailsImportBoxEntity) {
    this.formDetailsImportBoxEntity = formDetailsImportBoxEntity;
  }
}
