package com.bizunited.platform.kuiper.starter.repository;

import com.bizunited.platform.kuiper.entity.FormDetailsImportBoxDetailsEntity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * @author Keller
 * @create 2020/8/23
 */
@Repository("FormDetailsImportBoxDetailsRepository")
public interface FormDetailsImportBoxDetailsRepository extends
        JpaRepository<FormDetailsImportBoxDetailsEntity, String>,
        JpaSpecificationExecutor<FormDetailsImportBoxDetailsEntity> {

  @Query("from FormDetailsImportBoxDetailsEntity t where t.formDetailsImportBoxEntity.id=:id and t.formDetailsImportBoxEntity.projectName=:projectName")
  Page<FormDetailsImportBoxDetailsEntity> findByFormDetailsImportBoxId(@Param("id") String id, @Param("projectName") String projectName, Pageable pageable);
}
