package com.bizunited.platform.kuiper.starter.service;

import com.bizunited.platform.kuiper.entity.FormDetailsImportBoxEntity;
import com.bizunited.platform.kuiper.starter.service.instances.imports.FormDetailsImportBoxProcess;

import java.util.Map;

/**
 * 数据导入异步任务
 *
 * @author Keller
 * @create 2020/8/25
 */
public interface FormDetailsImportBoxTaskService {
  /**
   * 异步执行导入进程
   *
   * @param entity  导入记录信息
   * @param process 客户自定义实现业务导出数据处理类
   * @param account 操作账号
   * @param params  扩展参数
   */
  void importProcess(FormDetailsImportBoxEntity entity, FormDetailsImportBoxProcess<Object , Object> process, String account, Map<String, Object> params);

  /**
   * 异步执行excel数据验证
   *
   * @param entity
   * @param process
   * @param account
   * @param params
   */
  void checkProcess(FormDetailsImportBoxEntity entity, FormDetailsImportBoxProcess<Object , Object> process, String account, Map<String, Object> params);

  /**
   * 异步导入自定义扩展数据
   */
  void asyncImport(FormDetailsImportBoxEntity entity, FormDetailsImportBoxProcess<Object , Object> process, String account, Map<String, Object> params);
}
