package com.bizunited.platform.kuiper.starter.service.instances.imports;


import com.alibaba.fastjson.JSONArray;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.Map;
import java.util.Optional;

/**
 * 用于帮助业务开发人员完成基于一个Entity模型的数据批量导出工作(分页)
 *
 * @author Keller
 * @create 2020/8/25
 */
public interface  FormDetailsExportBoxProcess<T> {

  /**
   * 导出数据处理方法
   * <pre>
   *      1、为了避免OOM，通过Pageable进行分页获取数据返回
   *      2、返回对象需要添加@ExcelExport注解并填写相关参数
   *      3、导出字段使用@ExcelColumn注解配置title默认为导出列表标头信息 order为导出数据顺序
   * </pre>
   *
   * @param pageable     分页信息
   * @param exportFiled  导出数据字段参数 例如：["id","name","age"]
   * @param exportParam  导出数据查询参数 例如：[{"label":"名称","code":"name","value":"名称"}]（可为空）
   * @param params       导出扩展参数
   * @param dataViewCode 数据视图编码
   * @return
   */
  Page<T> exportProcess(Pageable pageable, Optional<String> dataViewCode, JSONArray exportFiled, Optional<JSONArray> exportParam, Map<String, Object> params);

  /**
   * 实现业务导出处理类的名称
   *
   * @return
   */
  default String exportProcessName() {
    return "";
  }
}
