package com.bizunited.platform.kuiper.starter.service.instances.imports;

import java.util.Map;

/**
 * 用于帮助业务开发人员完成基于一个Entity模型的数据批量导入工作
 * <pre>
 *  这个导入考虑大文件性能与安全问题过程将对xls/xlsx文件进逐行处理的方式进行,提供process和execute方法
 *
 *  注意这个接口所对应的业务数据:</br>
 *  1、xls/xlsx分析后的Excelbean，不用进行excel的解析工作</br>
 *  2、该业务数据导入功能涉及到的业务，必须是nebula业务构建平台中已经存在表单模板的业务
 * </pre>
 *
 * @author Keller
 * @create 2020/8/23
 */
public interface FormDetailsImportBoxProcess<T, E> {

  /**
   * 业务执行方法，传入每行Excel数据Bean，返回封装数据Bean
   * 如果检查过程中出现问题，可以使用ExcelMigrateException抛出异常，该记录会记录如错误信息表
   *
   * @param excelBean       excel对应的配置bean property
   * @param templateCode    导入业务数据后，将为业务数据创建表单实例，该templateCode指向将要创建表单实例时所参照的模板
   * @param templateVersion 导入业务数据后，将为业务数据创建表单实例，该templateVersion指向将要创建表单实例时所参照的模板版本
   * @return
   */
  T process(E excelBean, Map<String, Object> params, String templateCode, String templateVersion);

  /**
   * 该步骤是正式的业务数据入库处理过程，在该步骤，业务开发人员可专注与业务数据的处理</br>
   * 因为在该方法正式开始前，该业务数据所需要的表单实例信息已经绑定到相关业务对象中。
   *
   * @param t
   */
  void execute(T t, Map<String, Object> params);

  /**
   * 批量导入数据通过提供的导入id值
   *
   * @param params          传入参数 例如: id:导入记录id，dataCodes:需要导入数据编号
   * @param templateCode    列表编码 可为空
   * @param templateVersion 列表版本号 可为空
   */
  default void importExt(Map<String, Object> params,String templateCode, String templateVersion) {}

  /**
   * 实现业务导入处理类的名称
   *
   * @return
   */
  default String importProcessName() {
    return "";
  }

}
