package com.bizunited.platform.kuiper.starter.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;

/**
 * 数据导入参数Vo
 *
 * @author Keller
 * @create 2020/9/3
 */
@ApiModel("数据导入参数")
public class FormDetailsExportBoxVo {
  @ApiParam(required = true, name = "exportField", value = "导出数据字段信息")
  private String exportField;

  @ApiParam(required = false, name = "exportParam", value = "导出数据参数信息")
  private String exportParam;

  @ApiParam(required = true, name = "processClassName", value = "用于处理本次xls/xlsx业务数据导入所使用的完成导入处理类")
  private String processClassName;

  @ApiParam(required = false, name = "templateName", value = "导入业务数据后，业务模板名称")
  private String templateName;

  @ApiParam(required = false, name = "templateCode", value = "导入业务数据后，将为业务数据创建表单实例，该templateCode指向将要创建表单实例时所参照的模板")
  private String templateCode;

  @ApiParam(required = false, name = "templateVersion", value = "导入业务数据后，将为业务数据创建表单实例，该templateVersion指向将要创建表单实例时所参照的模板版本（该参数可以不传入，如果不传入，则会使用指定模板的默认版本，如果没有设置默认版本，则会抛出异常）")
  private String templateVersion;

  @ApiParam(required = false, name = "listTemplateName", value = "列表模板名称")
  private String listTemplateName;

  @ApiParam(required = false, name = "listTemplateVersion", value = "列表表单版本")
  private String listTemplateVersion;

  @ApiParam(required = false, name = "listTemplateCode", value = "列表表单编码")
  private String listTemplateCode;

  @ApiParam(required = false, name = "dataViewCode", value = "数据视图编码")
  private String dataViewCode;

  public String getDataViewCode() {
    return dataViewCode;
  }

  public void setDataViewCode(String dataViewCode) {
    this.dataViewCode = dataViewCode;
  }

  public String getExportField() {
    return exportField;
  }

  public void setExportField(String exportField) {
    this.exportField = exportField;
  }

  public String getExportParam() {
    return exportParam;
  }

  public void setExportParam(String exportParam) {
    this.exportParam = exportParam;
  }

  public String getProcessClassName() {
    return processClassName;
  }

  public void setProcessClassName(String processClassName) {
    this.processClassName = processClassName;
  }

  public String getTemplateName() {
    return templateName;
  }

  public void setTemplateName(String templateName) {
    this.templateName = templateName;
  }

  public String getTemplateCode() {
    return templateCode;
  }

  public void setTemplateCode(String templateCode) {
    this.templateCode = templateCode;
  }

  public String getTemplateVersion() {
    return templateVersion;
  }

  public void setTemplateVersion(String templateVersion) {
    this.templateVersion = templateVersion;
  }

  public String getListTemplateName() {
    return listTemplateName;
  }

  public void setListTemplateName(String listTemplateName) {
    this.listTemplateName = listTemplateName;
  }

  public String getListTemplateVersion() {
    return listTemplateVersion;
  }

  public void setListTemplateVersion(String listTemplateVersion) {
    this.listTemplateVersion = listTemplateVersion;
  }

  public String getListTemplateCode() {
    return listTemplateCode;
  }

  public void setListTemplateCode(String listTemplateCode) {
    this.listTemplateCode = listTemplateCode;
  }
}
