package com.bizunited.platform.kuiper.starter.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;

/**
 * 数据导入参数 Vo
 *
 * @author Keller
 * @create 2020/9/3
 */
@ApiModel("数据导入参数")
public class FormDetailsImportBoxVo {

  @ApiParam(value = "导入文件原文件名", required = true)
  private String originalFileName;

  @ApiParam(value = "导入文件名称", required = true)
  private String fileName;

  @ApiParam(value = "导入文件服务器相对地址", required = true)
  private String relativePath;

  @ApiParam(value = "导入文件大小", required = true)
  private Long fileSize;

  @ApiParam(value = "导入模板文件名称", required = true)
  private String templateFileName;

  @ApiParam(value = "导入模板文件服务器相对地址", required = true)
  private String templateFileRelativePath;

  @ApiParam(required = false, name = "templateName", value = "导入业务数据后，业务模板名称")
  private String templateName;

  @ApiParam(required = false, name = "templateCode", value = "导入业务数据后，将为业务数据创建表单实例，该templateCode指向将要创建表单实例时所参照的模板")
  private String templateCode;

  @ApiParam(required = false, name = "templateVersion", value = "导入业务数据后，将为业务数据创建表单实例，该templateVersion指向将要创建表单实例时所参照的模板版本（该参数可以不传入，如果不传入，则会使用指定模板的默认版本，如果没有设置默认版本，则会抛出异常）")
  private String templateVersion;

  @ApiParam(required = true, name = "processClassName", value = "用于处理本次xls/xlsx业务数据导入所使用的完成导入处理类")
  private String processClassName;

  @ApiParam(value = "按钮编号")
  private String btnCode;

  @ApiParam(required = false, name = "listTemplateName", value = "列表模板名称")
  private String listTemplateName;

  @ApiParam(name = "listTemplateVersion", value = "列表表单版本")
  private String listTemplateVersion;

  @ApiParam(name = "listTemplateCode", value = "列表表单编码")
  private String listTemplateCode;

  public String getOriginalFileName() {
    return originalFileName;
  }

  public void setOriginalFileName(String originalFileName) {
    this.originalFileName = originalFileName;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getRelativePath() {
    return relativePath;
  }

  public void setRelativePath(String relativePath) {
    this.relativePath = relativePath;
  }

  public Long getFileSize() {
    return fileSize;
  }

  public void setFileSize(Long fileSize) {
    this.fileSize = fileSize;
  }

  public String getTemplateName() {
    return templateName;
  }

  public void setTemplateName(String templateName) {
    this.templateName = templateName;
  }

  public String getTemplateCode() {
    return templateCode;
  }

  public void setTemplateCode(String templateCode) {
    this.templateCode = templateCode;
  }

  public String getTemplateVersion() {
    return templateVersion;
  }

  public void setTemplateVersion(String templateVersion) {
    this.templateVersion = templateVersion;
  }

  public String getProcessClassName() {
    return processClassName;
  }

  public void setProcessClassName(String processClassName) {
    this.processClassName = processClassName;
  }

  public String getBtnCode() {
    return btnCode;
  }

  public void setBtnCode(String btnCode) {
    this.btnCode = btnCode;
  }

  public String getListTemplateName() {
    return listTemplateName;
  }

  public void setListTemplateName(String listTemplateName) {
    this.listTemplateName = listTemplateName;
  }

  public String getListTemplateVersion() {
    return listTemplateVersion;
  }

  public void setListTemplateVersion(String listTemplateVersion) {
    this.listTemplateVersion = listTemplateVersion;
  }

  public String getListTemplateCode() {
    return listTemplateCode;
  }

  public void setListTemplateCode(String listTemplateCode) {
    this.listTemplateCode = listTemplateCode;
  }

  public String getTemplateFileName() {
    return templateFileName;
  }

  public void setTemplateFileName(String templateFileName) {
    this.templateFileName = templateFileName;
  }

  public String getTemplateFileRelativePath() {
    return templateFileRelativePath;
  }

  public void setTemplateFileRelativePath(String templateFileRelativePath) {
    this.templateFileRelativePath = templateFileRelativePath;
  }
}
