/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.common.excel;

import com.bizunited.platform.kuiper.starter.common.excel.CellRegion;
import com.bizunited.platform.kuiper.starter.common.excel.ExcelFormula;
import com.bizunited.platform.kuiper.starter.common.excel.exception.ExcelMigrateException;
import com.bizunited.platform.kuiper.starter.common.excel.exception.ExcelWraperException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelExportWrapper {
    public static final Logger LOGGER = LoggerFactory.getLogger(ExcelExportWrapper.class);
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final Integer ROW_KEEP_INMEMORY = 100;
    private static final Integer DEFAULT_COLUMN_WIDTH = 20;
    private static final String DEFAULT_CHARACTER = "utf-8";
    private Workbook wb;
    private CellStyle defaultCellStyle = null;
    private Map<String, CellStyle> cellStyleCache = new HashMap<String, CellStyle>();
    private Map<String, Short> formatCache = new HashMap<String, Short>();
    private Map<Sheet, Map<Integer, Integer>> columnWidth = new HashMap<Sheet, Map<Integer, Integer>>();
    private DataFormat dataFormat;
    private boolean autoColumnWidth = true;
    private Map<String, String> dataFormatCache = new HashMap<String, String>();

    /*
     * Unable to fully structure code
     */
    public ExcelExportWrapper(InputStream inp) {
        super();
        try {
            is = FileMagic.prepareToCheckMagic((InputStream)inp);
            var3_4 = null;
            try {
                fm = FileMagic.valueOf((InputStream)is);
                switch (1.$SwitchMap$org$apache$poi$poifs$filesystem$FileMagic[fm.ordinal()]) {
                    case 1: {
                        this.wb = new HSSFWorkbook(is);
                        ** break;
lbl17:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        xssfWorkbook = new XSSFWorkbook(is);
                        this.wb = new SXSSFWorkbook(xssfWorkbook, ExcelExportWrapper.ROW_KEEP_INMEMORY.intValue());
                        ((SXSSFWorkbook)this.wb).setCompressTempFiles(true);
                        ** break;
lbl23:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new ExcelWraperException("Excel\u6587\u4ef6\u683c\u5f0f\u9519\u8bef");
                    }
                }
            }
            catch (Throwable var4_7) {
                var3_4 = var4_7;
                throw var4_7;
            }
            finally {
                if (is != null) {
                    if (var3_4 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable var4_6) {
                            var3_4.addSuppressed(var4_6);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ExcelWraperException("Excel\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef");
        }
        this.init(this.wb);
    }

    public ExcelExportWrapper(Workbook wb) {
        this.init(wb);
    }

    private void init(Workbook wb) {
        try {
            if (wb != null) {
                this.wb = wb;
                this.dataFormat = wb.createDataFormat();
                this.formatCache.put(DATE_TIME_FORMAT, this.dataFormat.getFormat(DATE_TIME_FORMAT));
                this.formatCache.put(DATE_FORMAT, this.dataFormat.getFormat(DATE_FORMAT));
                this.formatCache.put("@", this.dataFormat.getFormat("@"));
                CellStyle defauleS = wb.createCellStyle();
                defauleS.setVerticalAlignment(VerticalAlignment.CENTER);
                defauleS.setWrapText(true);
                this.setDefaultCellStyle(defauleS);
                this.setDataFormat("java.util.Date", DATE_TIME_FORMAT);
                this.setDataFormat("java.lang.CharSequence", "@");
            }
        }
        catch (Exception e) {
            throw new ExcelWraperException("\u521b\u5efaexcel\u5931\u8d25,\u8bf7\u68c0\u67e5\u6587\u4ef6\u683c\u5f0f\u548c\u5185\u5bb9\u3002");
        }
    }

    public Workbook getWorkbook() {
        return this.wb;
    }

    public Sheet buildSheet(String sheetName) {
        return this.buildSheet(sheetName, DEFAULT_COLUMN_WIDTH);
    }

    public Sheet buildSheet(String sheetName, int defaultColumnWidth) {
        if (StringUtils.isBlank((CharSequence)sheetName)) {
            sheetName = UUID.randomUUID().toString();
        }
        sheetName = (sheetName = sheetName.replaceAll("[\u0000\u0003:\\\\*\\?/\\[\\]<>\"\\|]", "")).length() > 31 ? sheetName.substring(0, 28) + "..." : sheetName;
        Sheet sheet = this.getWorkbook().createSheet(sheetName);
        sheet.setDefaultColumnWidth(defaultColumnWidth);
        return sheet;
    }

    public Sheet getSheet(String name) {
        Validate.notBlank((CharSequence)name, (String)"sheet\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.getWorkbook().getSheet(name);
    }

    public Sheet getSheet(int sheetIndex) {
        Validate.isTrue((sheetIndex > -1 ? 1 : 0) != 0, (String)"sheet\u7d22\u5f15\u5c0f\u4e8e0", (Object[])new Object[0]);
        Sheet sheet = this.getWorkbook().getSheetAt(sheetIndex);
        return sheet;
    }

    public void paint(Sheet sheet, Object[] list) {
        this.paint(sheet, 0, 0, list, null, null);
    }

    public void paint(Sheet sheet, Object[] list, CellStyle cellstyle) {
        this.paint(sheet, 0, 0, list, cellstyle, null);
    }

    public void paint(Sheet sheet, int rowIndex, int columnIndex, Object[] list) {
        this.paint(sheet, rowIndex, columnIndex, list, null, null);
    }

    public void paint(int sheetIndex, int rowIndex, int columnIndex, Object[] list) {
        this.paint(this.getSheet(sheetIndex), rowIndex, columnIndex, list, null, null);
    }

    public void paint(Sheet sheet, int rowIndex, int columnIndex, Object[] list, CellStyle cellstyle) {
        this.paint(sheet, rowIndex, columnIndex, list, cellstyle, null);
    }

    public void paint(Sheet sheet, int rowIndex, int columnIndex, Object[] list, CellStyle cellstyle, String[] formats) {
        Row row = sheet.getRow(rowIndex);
        if (row == null) {
            row = sheet.createRow(rowIndex);
        }
        if (list != null && list.length != 0) {
            for (int i = 0; i < list.length; ++i) {
                Object v = list[i];
                Cell cell = row.getCell(i + columnIndex);
                if (cell == null) {
                    cell = row.createCell(i + columnIndex);
                }
                this.paintCell(cell, v, cellstyle, formats != null && formats.length > i && StringUtils.isNotBlank((CharSequence)formats[i]) ? formats[i] : "");
            }
        }
    }

    public void paintCell(Cell cell, Object val, CellStyle cellstyle, String format) {
        CellStyle deCellStyle = cellstyle;
        if (deCellStyle == null) {
            deCellStyle = this.defaultCellStyle;
        }
        if (val != null) {
            if (StringUtils.isNotBlank((CharSequence)format)) {
                deCellStyle = this.getFormatCellStyle(deCellStyle, format);
            } else if (Date.class.isAssignableFrom(val.getClass())) {
                deCellStyle = this.getFormatCellStyle(deCellStyle, this.dataFormatCache.get("java.lang.Date"));
            } else if (CharSequence.class.isAssignableFrom(val.getClass())) {
                deCellStyle = this.getFormatCellStyle(deCellStyle, this.dataFormatCache.get("java.lang.CharSequence"));
            }
        }
        cell.setCellStyle(deCellStyle);
        this.fillCellValue(cell, val);
    }

    private CellStyle getFormatCellStyle(CellStyle cellstyle, String format) {
        CellStyle deCellStyle = cellstyle;
        if (StringUtils.isNotBlank((CharSequence)format)) {
            String key = StringUtils.join((Object[])new String[]{deCellStyle.toString(), "_", format});
            if (this.cellStyleCache.containsKey(key)) {
                deCellStyle = this.cellStyleCache.get(key);
            } else {
                deCellStyle = this.buildFormtCellStyle(deCellStyle, format);
                this.cellStyleCache.put(key, deCellStyle);
            }
        }
        return deCellStyle;
    }

    private CellStyle buildFormtCellStyle(CellStyle copy, String format) {
        CellStyle style = copy;
        short desf = 0;
        if (this.formatCache.containsKey(format)) {
            desf = this.formatCache.get(format);
        } else {
            desf = this.dataFormat.getFormat(format);
            this.formatCache.put(format, desf);
        }
        if (desf != 0) {
            style = this.wb.createCellStyle();
            style.cloneStyleFrom(copy);
            style.setDataFormat(desf);
        }
        return style;
    }

    public void paintStyle(Sheet sheet, CellRegion region, CellStyle cellstyle) {
        if (region != null && sheet != null && cellstyle != null) {
            for (int i = region.getFirstRow().intValue(); i <= region.getFootRow(); ++i) {
                Row row = sheet.getRow(i);
                Validate.notNull((Object)row, (String)String.format("\u884c%d\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u7ed8\u5236\u6837\u5f0f\u3002", i), (Object[])new Object[0]);
                for (int j = region.getFirstCol().intValue(); j <= region.getFootCol(); ++j) {
                    Cell cell = row.getCell(j);
                    Validate.notNull((Object)cell, (String)String.format("\u5355\u5143\u683c(%d,%d)\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u7ed8\u5236\u6837\u5f0f\u3002", i, j), (Object[])new Object[0]);
                    cell.setCellStyle(cellstyle);
                }
            }
        }
    }

    public void mergeRegion(List<CellRegion> list, Sheet sheet) {
        if (!list.isEmpty()) {
            for (CellRegion cellRegion : list) {
                sheet.addMergedRegion(new CellRangeAddress(cellRegion.getFirstRow().intValue(), cellRegion.getFootRow().intValue(), cellRegion.getFirstCol().intValue(), cellRegion.getFootCol().intValue()));
            }
        }
    }

    public void mergeRegion(CellRegion cellRegion, Sheet sheet) {
        sheet.addMergedRegion(new CellRangeAddress(cellRegion.getFirstRow().intValue(), cellRegion.getFootRow().intValue(), cellRegion.getFirstCol().intValue(), cellRegion.getFootCol().intValue()));
    }

    public void export(OutputStream os) {
        try {
            this.exportBeforeHandle();
            this.wb = this.getWorkbook();
            this.wb.write(os);
            if (this.wb instanceof SXSSFWorkbook) {
                ((SXSSFWorkbook)this.wb).dispose();
            }
        }
        catch (IOException e) {
            throw new ExcelMigrateException("excel\u5199\u5165\u51fa\u9519");
        }
    }

    private void fillCellValue(Cell cell, Object o) {
        int length = DEFAULT_COLUMN_WIDTH;
        try {
            if (o != null) {
                if (o instanceof Integer) {
                    cell.setCellValue((double)Integer.parseInt(String.valueOf(o)));
                    length = o.toString().getBytes(DEFAULT_CHARACTER).length;
                } else if (o instanceof Float) {
                    cell.setCellValue((double)Float.parseFloat(String.valueOf(o)));
                    length = o.toString().getBytes(DEFAULT_CHARACTER).length;
                } else if (o instanceof Double) {
                    cell.setCellValue(Double.parseDouble(String.valueOf(o)));
                    length = o.toString().getBytes(DEFAULT_CHARACTER).length;
                } else if (o instanceof Long) {
                    cell.setCellValue((double)Long.parseLong(String.valueOf(o)));
                    length = o.toString().getBytes(DEFAULT_CHARACTER).length;
                } else if (o instanceof Short) {
                    cell.setCellValue((double)Short.parseShort(String.valueOf(o)));
                    length = o.toString().getBytes(DEFAULT_CHARACTER).length;
                } else if (o instanceof Boolean) {
                    cell.setCellValue(Boolean.parseBoolean(String.valueOf(o)));
                    length = o.toString().getBytes(DEFAULT_CHARACTER).length;
                } else if (o instanceof RichTextString) {
                    cell.setCellValue((RichTextString)o);
                    length = ((RichTextString)o).getString().getBytes(DEFAULT_CHARACTER).length;
                } else if (Date.class.isAssignableFrom(o.getClass())) {
                    cell.setCellValue((Date)o);
                } else if (o instanceof ExcelFormula) {
                    cell.setCellFormula(((ExcelFormula)o).getFormula());
                    length = 0;
                } else if (o instanceof BigDecimal) {
                    cell.setCellValue(((BigDecimal)o).doubleValue());
                    length = o.toString().getBytes(DEFAULT_CHARACTER).length;
                } else {
                    cell.setCellValue(o.toString());
                    length = o.toString().getBytes(DEFAULT_CHARACTER).length;
                }
            } else {
                cell.setCellValue("");
            }
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            cell.setCellValue("");
        }
        this.setMaxWidth(cell.getSheet(), cell.getColumnIndex(), length);
    }

    public CellStyle getDefaultCellStyle() {
        return this.defaultCellStyle;
    }

    public boolean isAutoColumnWidth() {
        return this.autoColumnWidth;
    }

    public void setAutoColumnWidth(boolean autoColumnWidth) {
        this.autoColumnWidth = autoColumnWidth;
    }

    private void setMaxWidth(Sheet sheet, int i, int length) {
        Integer width;
        if (!this.isAutoColumnWidth()) {
            return;
        }
        Map<Integer, Integer> rowWidth = this.columnWidth.get(sheet);
        if (rowWidth == null) {
            rowWidth = new HashMap<Integer, Integer>(20);
            this.columnWidth.put(sheet, rowWidth);
        }
        if ((width = rowWidth.get(i)) != null) {
            if (length > width) {
                rowWidth.put(i, length);
            }
        } else {
            rowWidth.put(i, length);
        }
    }

    private void exportBeforeHandle() {
        if (!this.isAutoColumnWidth()) {
            return;
        }
        for (Map.Entry<Sheet, Map<Integer, Integer>> e : this.columnWidth.entrySet()) {
            Sheet sheet = e.getKey();
            Map<Integer, Integer> rowWidth = e.getValue();
            if (rowWidth == null || rowWidth.isEmpty()) continue;
            for (Map.Entry<Integer, Integer> row : rowWidth.entrySet()) {
                int deswidth = (row.getValue() * 7 + 5) / 7 + 1;
                sheet.setColumnWidth(row.getKey().intValue(), (deswidth > 255 ? 255 : deswidth) * 256);
            }
        }
    }

    public Integer getSheetMaxRowNum(Sheet sheet) {
        return sheet.getLastRowNum();
    }

    public void setDataFormat(String name, String format) {
        this.dataFormatCache.put(name, format);
    }

    public void setDefaultCellStyle(CellStyle cellStyle) {
        this.defaultCellStyle = cellStyle;
        this.getFormatCellStyle(cellStyle, DATE_TIME_FORMAT);
        this.getFormatCellStyle(cellStyle, DATE_FORMAT);
    }
}

