/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.common.excel;

import com.bizunited.platform.kuiper.starter.common.excel.ExcelExportWrapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelExportWrapperBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelExportWrapperBuilder.class);

    private ExcelExportWrapperBuilder() {
    }

    public static ExcelExportWrapper build(InputStream input) {
        return new ExcelExportWrapper(input);
    }

    public static ExcelExportWrapper build(File file) {
        Workbook wb = null;
        try {
            wb = WorkbookFactory.create((File)file);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u521b\u5efaExecl\u6587\u4ef6\u51fa\u9519");
        }
        return new ExcelExportWrapper(wb);
    }

    public static ExcelExportWrapper buildWithSXSSFWorkbook() {
        SXSSFWorkbook wb = new SXSSFWorkbook();
        return new ExcelExportWrapper((Workbook)wb);
    }
}

