/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.common.excel;

import com.bizunited.platform.kuiper.starter.common.excel.IObgainWorkbook;
import com.bizunited.platform.kuiper.starter.common.excel.IRecordInterceptor;
import com.bizunited.platform.kuiper.starter.common.excel.reader.IExcelReader;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang3.Validate;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelImportWrapper {
    public static final Logger LOGGER = LoggerFactory.getLogger(ExcelImportWrapper.class);
    public static final ConvertUtilsBean convertUtilsBean = new ConvertUtilsBean();
    private Workbook wb;
    private IExcelReader excelReader;

    public ExcelImportWrapper(IExcelReader excelReader) {
        this.excelReader = excelReader;
        if (excelReader instanceof IObgainWorkbook) {
            this.wb = ((IObgainWorkbook)((Object)excelReader)).getWorkbook();
        }
    }

    public Workbook getWorkbook() {
        if (this.wb == null) {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c");
        }
        return this.wb;
    }

    public Sheet getSheet(String name) {
        Validate.notBlank((CharSequence)name, (String)"sheet\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.getWorkbook().getSheet(name);
    }

    public Sheet getSheet(int sheetIndex) {
        Validate.isTrue((sheetIndex > -1 ? 1 : 0) != 0, (String)"sheet\u7d22\u5f15\u5c0f\u4e8e0", (Object[])new Object[0]);
        return this.getWorkbook().getSheetAt(sheetIndex);
    }

    public void readSheet(int sheetIndex, int columnEndIndex, IRecordInterceptor<Object[]> interceptor) {
        this.excelReader.readSheet((Integer)sheetIndex, 0, 0, columnEndIndex, null, interceptor);
    }

    public void readSheet(int sheetIndex, int rowBeginIndex, int columnBeginIndex, int columnEndIndex, Class<?>[] classs, IRecordInterceptor<Object[]> interceptor) {
        this.excelReader.readSheet((Integer)sheetIndex, rowBeginIndex, columnBeginIndex, columnEndIndex, classs, interceptor);
    }

    public void readSheet(int sheetIndex, int rowBeginIndex, int columnBeginIndex, int columnEndIndex, IRecordInterceptor<Object[]> interceptor) {
        this.excelReader.readSheet((Integer)sheetIndex, rowBeginIndex, columnBeginIndex, columnEndIndex, null, interceptor);
    }

    public void readSheet(int sheetIndex, int rowBeginIndex, int columnBeginIndex, int columnEndIndex, List<Class<?>> classList, IRecordInterceptor<Object[]> interceptor) {
        Class[] classs = new Class[classList.size()];
        classList.toArray(classs);
        this.excelReader.readSheet((Integer)sheetIndex, rowBeginIndex, columnBeginIndex, columnEndIndex, classs, interceptor);
    }

    public void readSheet(int sheetIndex, int columnEndIndex, int[] rowIndexs, IRecordInterceptor<Object[]> interceptor) {
        this.excelReader.readSheet((Integer)sheetIndex, 0, columnEndIndex, rowIndexs, null, interceptor);
    }

    public void readSheet(int sheetIndex, int columnBeginIndex, int columnEndIndex, int[] rowIndexs, Class<?>[] classs, IRecordInterceptor<Object[]> interceptor) {
        this.excelReader.readSheet((Integer)sheetIndex, columnBeginIndex, columnEndIndex, rowIndexs, classs, interceptor);
    }

    public Object[] readRow(int sheetIndex, int rowIndex, int columnEndIndex) {
        return this.excelReader.readRow(sheetIndex, rowIndex, 0, columnEndIndex, null);
    }

    public Object[] readRow(int sheetIndex, int rowIndex, int columnBeginIndex, int columnEndIndex, Class<?>[] classs) {
        return this.excelReader.readRow(sheetIndex, rowIndex, columnBeginIndex, columnEndIndex, classs);
    }

    static {
        convertUtilsBean.register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                if (value != null) {
                    return (T)DateUtil.getJavaDate((double)Double.parseDouble(value.toString()));
                }
                return null;
            }
        }, Date.class);
        convertUtilsBean.register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                String src;
                if (value != null && (src = value.toString()).matches("\\d+(\\.\\d+)?")) {
                    BigDecimal bigDecimal = new BigDecimal(value.toString());
                    return (T)new Integer(bigDecimal.intValue());
                }
                return null;
            }
        }, Integer.class);
    }
}

