/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.common.excel;

import com.bizunited.platform.kuiper.starter.common.enums.ExcelTypeEnum;
import com.bizunited.platform.kuiper.starter.common.excel.ExcelImportWrapper;
import com.bizunited.platform.kuiper.starter.common.excel.exception.ExcelWraperException;
import com.bizunited.platform.kuiper.starter.common.excel.reader.IExcelReader;
import com.bizunited.platform.kuiper.starter.common.excel.reader.impl.DomExcelReader;
import com.bizunited.platform.kuiper.starter.common.excel.reader.impl.NewExcelEventReader;
import com.bizunited.platform.kuiper.starter.common.excel.reader.impl.OldExcelEventReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.Validate;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ExcelImportWrapperBuilder {
    public static final Logger LOGGER = LoggerFactory.getLogger(ExcelImportWrapperBuilder.class);
    private File fileName;
    private ExcelTypeEnum excelTypeEnum;
    private InputStream input;
    private boolean isDomReader = false;

    public static ExcelImportWrapperBuilder create(InputStream input, File fileName) {
        return new ExcelImportWrapperBuilder(input, fileName);
    }

    private ExcelImportWrapperBuilder(InputStream input, File fileName) {
        this.input = input;
        this.fileName = fileName;
    }

    public ExcelImportWrapperBuilder setDomReader(boolean isDomReader) {
        this.isDomReader = isDomReader;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExcelImportWrapper builder() {
        Validate.notNull((Object)this.input, (String)"\u8f93\u5165\u6d41\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        try (InputStream is = FileMagic.prepareToCheckMagic((InputStream)this.input);){
            FileMagic fileMagic = FileMagic.valueOf((InputStream)is);
            switch (fileMagic) {
                case OLE2: {
                    this.excelTypeEnum = ExcelTypeEnum.XLS;
                    break;
                }
                case OOXML: {
                    this.excelTypeEnum = ExcelTypeEnum.XLSX;
                    break;
                }
                default: {
                    throw new ExcelWraperException("excel\u683c\u5f0f\u89e3\u6790\u9519\u8bef");
                }
            }
            IExcelReader excelReader = null;
            if (this.isDomReader) {
                excelReader = new DomExcelReader(this.excelTypeEnum, this.input);
            } else {
                switch (this.excelTypeEnum) {
                    case XLS: {
                        excelReader = new OldExcelEventReader(is);
                        break;
                    }
                    case XLSX: {
                        excelReader = new NewExcelEventReader(is, this.fileName);
                        break;
                    }
                }
            }
            ExcelImportWrapper excelImportWrapper = new ExcelImportWrapper(excelReader);
            return excelImportWrapper;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExcelWraperException("excel\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", e);
        }
        catch (SAXException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExcelWraperException("excel\u6587\u4ef6\u683c\u5f0f\u8bfb\u53d6\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", e);
        }
        catch (OpenXML4JException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExcelWraperException("excel\u6587\u4ef6\u683c\u5f0f\u8bfb\u53d6\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", e);
        }
    }
}

