/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.common.excel;

import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelColumn;
import com.bizunited.platform.kuiper.starter.common.excel.exception.ExcelMigrateException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.poi.ss.usermodel.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelUtils.class);
    public static ConvertUtilsBean convertUtilsBean = new ConvertUtilsBean();

    private ExcelUtils() {
    }

    public static Object convert(Object o, Class<?> c) throws ExcelMigrateException {
        if (o == null) {
            return "";
        }
        return convertUtilsBean.convert(o.toString(), c);
    }

    public static boolean isEmpty(Object[] os) {
        boolean isEmpty = true;
        if (ArrayUtils.isNotEmpty((Object[])os)) {
            for (Object o : os) {
                if (o == null || "".equals(o.toString())) continue;
                isEmpty = false;
                break;
            }
        }
        return isEmpty;
    }

    public static int getColumnIndex(String c) {
        int num = 0;
        int result = 0;
        int length = c.length();
        for (int i = 0; i < length; ++i) {
            char ch = c.charAt(length - i - 1);
            num = ch - 65 + 1;
            num = (int)((double)num * Math.pow(26.0, i));
            result += num;
        }
        return result;
    }

    public static String excelColIndexToStr(int columnIndex) {
        if (columnIndex <= 0) {
            return null;
        }
        String columnStr = "";
        --columnIndex;
        do {
            if (columnStr.length() > 0) {
                --columnIndex;
            }
            columnStr = (char)(columnIndex % 26 + 65) + columnStr;
        } while ((columnIndex = (columnIndex - columnIndex % 26) / 26) > 0);
        return columnStr;
    }

    private static boolean match(String regex, String str) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    public static Object setValue(Class<?> clazz, Object[] values) throws InstantiationException, IllegalAccessException {
        Field[] fields;
        Object o = clazz.newInstance();
        for (Field field : fields = clazz.getDeclaredFields()) {
            boolean check;
            NebulaExcelColumn nebulaExcelColumn = field.getAnnotation(NebulaExcelColumn.class);
            if (nebulaExcelColumn == null) continue;
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            Method fieldSetMet = null;
            try {
                fieldSetMet = clazz.getMethod("set" + StringUtils.capitalize((String)field.getName()), field.getType());
            }
            catch (NoSuchMethodException e) {
                throw new ExcelMigrateException(nebulaExcelColumn, "\u5b57\u6bb5\u5c5e\u6027set\u65b9\u6cd5\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5:" + field.getName(), e);
            }
            Object value = values[nebulaExcelColumn.order()];
            String tmp = "";
            if (value != null) {
                tmp = String.valueOf(value);
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{nebulaExcelColumn.regex()}) && !(check = ExcelUtils.match(nebulaExcelColumn.regex(), tmp))) {
                throw new ExcelMigrateException(nebulaExcelColumn, "\u89c4\u5219\u9a8c\u8bc1\u5931\u8d25 \u5b57\u6bb5\u3010" + field.getName() + "\u3011regex:" + nebulaExcelColumn.regex() + " \u503c:" + tmp);
            }
            if (!nebulaExcelColumn.nullable() && StringUtils.isBlank((CharSequence)tmp)) {
                throw new ExcelMigrateException(nebulaExcelColumn, "\u975e\u7a7a\u89c4\u5219\u9a8c\u8bc1\u5931\u8d25 \u5b57\u6bb5\u3010" + field.getName() + "\u3011");
            }
            if (String.class.isAssignableFrom(fieldType)) {
                try {
                    fieldSetMet.invoke(o, tmp);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new ExcelMigrateException(nebulaExcelColumn, "\u5b57\u6bb5\u5c5e\u6027set\u65b9\u6cd5\u65e0\u6cd5\u8bbf\u95ee\uff0c\u8bf7\u68c0\u67e5:" + field.getName(), e);
                }
                catch (InvocationTargetException e) {
                    throw new ExcelMigrateException(nebulaExcelColumn, "\u5b57\u6bb5\u5c5e\u6027set\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5:" + field.getName(), e);
                }
            }
            if (Date.class.isAssignableFrom(fieldType)) {
                if (StringUtils.isBlank((CharSequence)tmp)) {
                    throw new ExcelMigrateException("Date\u7c7b\u578b\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
                }
                String dateFormat = nebulaExcelColumn.format();
                Date date = null;
                try {
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dateFormat})) {
                        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                        date = sdf.parse(tmp);
                    } else {
                        date = DateUtils.parseDate((String)tmp, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
                    }
                }
                catch (Exception e) {
                    throw new ExcelMigrateException(nebulaExcelColumn, "\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff1a\u65e5\u671f\u6570\u636e(" + tmp + ") \u671f\u671b\u8f93\u5165\u683c\u5f0f\uff08" + dateFormat + "\uff09", e);
                }
                try {
                    fieldSetMet.invoke(o, date);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new ExcelMigrateException(nebulaExcelColumn, "\u5b57\u6bb5\u5c5e\u6027set\u65b9\u6cd5\u65e0\u6cd5\u8bbf\u95ee\uff0c\u8bf7\u68c0\u67e5:" + field.getName(), e);
                }
                catch (InvocationTargetException e) {
                    throw new ExcelMigrateException(nebulaExcelColumn, "\u5b57\u6bb5\u5c5e\u6027set\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5:" + field.getName(), e);
                }
            }
            if (Integer.class.isAssignableFrom(fieldType) || Integer.TYPE.isAssignableFrom(fieldType)) {
                if (StringUtils.isBlank((CharSequence)tmp)) {
                    throw new ExcelMigrateException("Integer\u7c7b\u578b\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
                }
                try {
                    Integer intval = Integer.parseInt(tmp);
                    fieldSetMet.invoke(o, intval);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new ExcelMigrateException(nebulaExcelColumn, "\u5b57\u6bb5\u5c5e\u6027set\u65b9\u6cd5\u65e0\u6cd5\u8bbf\u95ee\uff0c\u8bf7\u68c0\u67e5:" + field.getName(), e);
                }
                catch (InvocationTargetException e) {
                    throw new ExcelMigrateException(nebulaExcelColumn, "\u5b57\u6bb5\u5c5e\u6027set\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5:" + field.getName(), e);
                }
                catch (NumberFormatException e) {
                    throw new ExcelMigrateException(nebulaExcelColumn, "\u8f93\u5165\u6570\u5b57\u7c7b\u578b\u8f6c\u578b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u5b57\u6bb5:" + field.getName() + " \u8f93\u5165\u503c:" + tmp, e);
                }
            }
            if (BigDecimal.class.isAssignableFrom(fieldType)) {
                if (StringUtils.isBlank((CharSequence)tmp)) {
                    throw new ExcelMigrateException("BigDecimal\u7c7b\u578b\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
                }
                BigDecimal intval = new BigDecimal(tmp);
                try {
                    fieldSetMet.invoke(o, intval);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new ExcelMigrateException(nebulaExcelColumn, "\u5b57\u6bb5\u5c5e\u6027set\u65b9\u6cd5\u65e0\u6cd5\u8bbf\u95ee\uff0c\u8bf7\u68c0\u67e5:" + field.getName(), e);
                }
                catch (InvocationTargetException e) {
                    throw new ExcelMigrateException(nebulaExcelColumn, "\u5b57\u6bb5\u5c5e\u6027set\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5:" + field.getName(), e);
                }
            }
            if (Long.class.isAssignableFrom(fieldType) || Long.TYPE.isAssignableFrom(fieldType)) {
                if (StringUtils.isBlank((CharSequence)tmp)) {
                    throw new ExcelMigrateException("Long\u7c7b\u578b\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
                }
                Long temp = Long.parseLong(tmp);
                try {
                    fieldSetMet.invoke(o, temp);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new ExcelMigrateException(nebulaExcelColumn, "\u5b57\u6bb5\u5c5e\u6027set\u65b9\u6cd5\u65e0\u6cd5\u8bbf\u95ee\uff0c\u8bf7\u68c0\u67e5:" + field.getName(), e);
                }
                catch (InvocationTargetException e) {
                    throw new ExcelMigrateException(nebulaExcelColumn, "\u5b57\u6bb5\u5c5e\u6027set\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5:" + field.getName(), e);
                }
            }
            if (Double.class.isAssignableFrom(fieldType) || Double.TYPE.isAssignableFrom(fieldType)) {
                if (StringUtils.isBlank((CharSequence)tmp)) {
                    throw new ExcelMigrateException("Double\u7c7b\u578b\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
                }
                Double temp = null;
                if (StringUtils.endsWith((CharSequence)tmp, (CharSequence)"%")) {
                    tmp = StringUtils.substringBefore((String)tmp, (String)"%");
                    temp = Double.parseDouble(tmp) / 100.0;
                } else {
                    temp = Double.parseDouble(tmp);
                }
                try {
                    fieldSetMet.invoke(o, temp);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new ExcelMigrateException(nebulaExcelColumn, "\u5b57\u6bb5\u5c5e\u6027set\u65b9\u6cd5\u65e0\u6cd5\u8bbf\u95ee\uff0c\u8bf7\u68c0\u67e5:" + field.getName(), e);
                }
                catch (InvocationTargetException e) {
                    throw new ExcelMigrateException(nebulaExcelColumn, "\u5b57\u6bb5\u5c5e\u6027set\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5:" + field.getName(), e);
                }
            }
            if (Boolean.class.isAssignableFrom(fieldType) || Boolean.TYPE.isAssignableFrom(fieldType)) {
                if (StringUtils.isBlank((CharSequence)tmp)) {
                    throw new ExcelMigrateException("Boolean\u7c7b\u578b\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
                }
                Boolean temp = Boolean.parseBoolean(tmp);
                try {
                    fieldSetMet.invoke(o, temp);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new ExcelMigrateException(nebulaExcelColumn, "\u5b57\u6bb5\u5c5e\u6027set\u65b9\u6cd5\u65e0\u6cd5\u8bbf\u95ee\uff0c\u8bf7\u68c0\u67e5:" + field.getName(), e);
                }
                catch (InvocationTargetException e) {
                    throw new ExcelMigrateException(nebulaExcelColumn, "\u5b57\u6bb5\u5c5e\u6027set\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5:" + field.getName(), e);
                }
            }
            if (Float.class.isAssignableFrom(fieldType) || Float.TYPE.isAssignableFrom(fieldType)) {
                if (StringUtils.isBlank((CharSequence)tmp)) {
                    throw new ExcelMigrateException("Float\u7c7b\u578b\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
                }
                Float temp = null;
                if (StringUtils.endsWith((CharSequence)tmp, (CharSequence)"%")) {
                    tmp = StringUtils.substringBefore((String)tmp, (String)"%");
                    temp = Float.valueOf(Float.parseFloat(tmp) / 100.0f);
                } else {
                    temp = Float.valueOf(Float.parseFloat(tmp));
                }
                try {
                    fieldSetMet.invoke(o, temp);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new ExcelMigrateException(nebulaExcelColumn, "\u5b57\u6bb5\u5c5e\u6027set\u65b9\u6cd5\u65e0\u6cd5\u8bbf\u95ee\uff0c\u8bf7\u68c0\u67e5:" + field.getName(), e);
                }
                catch (InvocationTargetException e) {
                    throw new ExcelMigrateException(nebulaExcelColumn, "\u5b57\u6bb5\u5c5e\u6027set\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5:" + field.getName(), e);
                }
            }
            LOGGER.error(String.format("not supper type: %s", new Object[0]), fieldType);
            throw new ExcelMigrateException(nebulaExcelColumn, "\u5b57\u6bb5\u7c7b\u578b\u65e0\u6548 \u5b57\u6bb5:" + field.getName() + " \u7c7b\u578b:" + fieldType);
        }
        return o;
    }

    public static Object setValue(Object[] values) {
        Set o = Arrays.stream(values).collect(Collectors.toSet());
        return o;
    }

    static {
        convertUtilsBean.register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                if (value != null) {
                    return (T)DateUtil.getJavaDate((double)Double.parseDouble(value.toString()));
                }
                return null;
            }
        }, Date.class);
        convertUtilsBean.register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                String src;
                if (value != null && (src = value.toString()).matches("\\d+(\\.\\d+)?")) {
                    BigDecimal bigDecimal = new BigDecimal(value.toString());
                    return (T)new Integer(bigDecimal.intValue());
                }
                return null;
            }
        }, Integer.class);
    }
}

