/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.common.excel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class SimpleMonocaseELParse {
    private Set<EL> registeEls = new LinkedHashSet<EL>();
    private Map<Character, List<EL>> startElsMap = new HashMap<Character, List<EL>>();

    public List<Map.Entry<String, String>> parse(String desStr) {
        ArrayList<Map.Entry<String, String>> parseResultEls = new ArrayList<Map.Entry<String, String>>();
        List<EL> ingEls = new ArrayList<EL>();
        boolean isElStart = false;
        int start = 0;
        if (StringUtils.isNotBlank((CharSequence)desStr)) {
            for (int i = 0; i < desStr.length(); ++i) {
                char c = desStr.charAt(i);
                if (!isElStart && ingEls.isEmpty() && !(ingEls = this.getAvailableEl(c)).isEmpty()) {
                    if (i > start) {
                        parseResultEls.add(new MyEntry<String, String>("", desStr.substring(start, i)));
                    }
                    start = i;
                    isElStart = true;
                }
                if (isElStart) {
                    MyEntry<EL, Integer> entry = this.parseEL(i, ingEls, desStr);
                    parseResultEls.add(new MyEntry<String, String>(((EL)((MyEntry)entry).key).getName(), desStr.substring(start, (Integer)((MyEntry)entry).value + 1)));
                    i = (Integer)((MyEntry)entry).value;
                    start = i + 1;
                    isElStart = false;
                    ingEls.clear();
                    continue;
                }
                if (i != desStr.length() - 1 || i + 1 <= start) continue;
                parseResultEls.add(new MyEntry<String, String>("", desStr.substring(start, i + 1)));
            }
        }
        return parseResultEls;
    }

    private MyEntry<EL, Integer> parseEL(int start, List<EL> desEls, String desStr) {
        for (int i = start + 1; i < desStr.length(); ++i) {
            char c = desStr.charAt(i);
            List<EL> temps = this.getAvailableEl(c);
            if (!temps.isEmpty()) {
                MyEntry<EL, Integer> entry = this.parseEL(i, temps, desStr);
                i = (Integer)((MyEntry)entry).value;
                continue;
            }
            EL el = this.isEnd(desEls, c);
            if (el == null) continue;
            if (!el.match(desStr.substring(start, i + 1))) {
                throw new IllegalArgumentException("\u5b57\u7b26\u4e32\u4e2d\u5b58\u5728\u65e0\u6548\u8868\u8fbe\u5f0f");
            }
            return new MyEntry<EL, Integer>(el, i);
        }
        throw new IllegalArgumentException("\u5b57\u7b26\u4e32\u4e2d\u5b58\u5728\u65e0\u6548\u8868\u8fbe\u5f0f");
    }

    private List<EL> getAvailableEl(char desc) {
        ArrayList<EL> list = new ArrayList<EL>();
        if (this.startElsMap.containsKey(Character.valueOf(desc))) {
            list = new ArrayList(this.startElsMap.get(Character.valueOf(desc)));
        }
        return list;
    }

    private EL isEnd(List<EL> els, char c) {
        for (EL el : els) {
            if (el.getEndChar() != c) continue;
            return el;
        }
        return null;
    }

    public boolean register(String name, char start, char end) {
        return this.register(name, start, end, null);
    }

    public boolean register(String name, char start, char end, Pattern pattern) {
        boolean r = false;
        Validate.notBlank((CharSequence)name, (String)"\u8868\u8fbe\u5f0f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u8868\u8fbe\u5f0f\u81f3\u5c11\u5305\u542b\u4e24\u4e2a\u5b57\u7b26", (Object[])new Object[0]);
        EL el = new EL(name, start, end, pattern);
        if (StringUtils.isNotBlank((CharSequence)name) && this.registeEls.add(el)) {
            List<EL> list = this.startElsMap.get(Character.valueOf(el.getStartChar()));
            if (list == null) {
                list = new ArrayList<EL>();
                this.startElsMap.put(Character.valueOf(el.getStartChar()), list);
            }
            list.add(el);
            r = true;
        }
        return r;
    }

    static class MyEntry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        public MyEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            return this.value;
        }

        public void SetKey(K key) {
            this.key = key;
        }

        public String toString() {
            return "MyEntry [key=" + this.key + ", value=" + this.value + "]";
        }
    }

    private static class EL {
        private String name;
        private char startChar;
        private char endChar;
        private Pattern pattern;

        public EL(String name, char startChar, char endChar, Pattern pattern) {
            this.name = name;
            this.startChar = startChar;
            this.endChar = endChar;
            this.pattern = pattern;
        }

        public String getName() {
            return this.name;
        }

        public char getStartChar() {
            return this.startChar;
        }

        public char getEndChar() {
            return this.endChar;
        }

        public boolean match(String desc) {
            return this.pattern == null || this.pattern.matcher(desc).matches();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.endChar;
            result = 31 * result + this.startChar;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EL other = (EL)obj;
            if (this.endChar != other.endChar) {
                return false;
            }
            return this.startChar == other.startChar;
        }
    }
}

