/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.common.excel.reader;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.eventusermodel.EventWorkbookBuilder;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.MissingRecordAwareHSSFListener;
import org.apache.poi.hssf.eventusermodel.dummyrecord.LastCellOfRowDummyRecord;
import org.apache.poi.hssf.eventusermodel.dummyrecord.MissingCellDummyRecord;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.usermodel.HSSFDataFormatter;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelXlsReader
implements HSSFListener {
    public static final Logger LOGGER = LoggerFactory.getLogger(ExcelXlsReader.class);
    private int minColums = -1;
    private POIFSFileSystem fs;
    private int totalRows = 0;
    private int lastRowNumber;
    private int lastColumnNumber;
    private boolean outputFormulaValues = true;
    private EventWorkbookBuilder.SheetRecordCollectingListener workbookBuildingListener;
    private HSSFWorkbook stubWorkbook;
    private SSTRecord sstRecord;
    private FormatTrackingHSSFListener formatListener;
    private final HSSFDataFormatter formatter = new HSSFDataFormatter();
    private BoundSheetRecord[] orderedBSRs;
    private ArrayList boundSheetRecords = new ArrayList();
    private int nextRow;
    private int nextColumn;
    private boolean outputNextStringRecord;
    private int curRow = 0;
    private List<String> cellList = new ArrayList<String>();
    private boolean flag = false;

    public int process(String fileName) {
        try {
            this.fs = new POIFSFileSystem((InputStream)new FileInputStream(fileName));
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("excel \u6587\u4ef6\u8bfb\u53d6\u9519\u8bef,\u8bf7\u68c0\u67e5\uff01");
        }
        MissingRecordAwareHSSFListener listener = new MissingRecordAwareHSSFListener((HSSFListener)this);
        this.formatListener = new FormatTrackingHSSFListener((HSSFListener)listener);
        HSSFEventFactory factory = new HSSFEventFactory();
        HSSFRequest request = new HSSFRequest();
        if (this.outputFormulaValues) {
            request.addListenerForAllRecords((HSSFListener)this.formatListener);
        } else {
            this.workbookBuildingListener = new EventWorkbookBuilder.SheetRecordCollectingListener((HSSFListener)this.formatListener);
            request.addListenerForAllRecords((HSSFListener)this.workbookBuildingListener);
        }
        try {
            factory.processWorkbookEvents(request, this.fs);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("excel \u6587\u4ef6\u8bfb\u53d6\u9519\u8bef,\u8bf7\u68c0\u67e5\uff01");
        }
        return this.totalRows;
    }

    public void processRecord(Record record) {
        int thisRow = -1;
        int thisColumn = -1;
        String thisStr = null;
        String value = null;
        switch (record.getSid()) {
            case 133: {
                this.boundSheetRecords.add(record);
                break;
            }
            case 2057: {
                BOFRecord br = (BOFRecord)record;
                if (br.getType() != 16) break;
                if (this.workbookBuildingListener != null && this.stubWorkbook == null) {
                    this.stubWorkbook = this.workbookBuildingListener.getStubHSSFWorkbook();
                }
                if (this.orderedBSRs != null) break;
                this.orderedBSRs = BoundSheetRecord.orderByBofPosition((List)this.boundSheetRecords);
                break;
            }
            case 252: {
                this.sstRecord = (SSTRecord)record;
                break;
            }
            case 513: {
                BlankRecord brec = (BlankRecord)record;
                thisRow = brec.getRow();
                thisColumn = brec.getColumn();
                thisStr = "";
                this.cellList.add(thisColumn, thisStr);
                break;
            }
            case 517: {
                BoolErrRecord berec = (BoolErrRecord)record;
                thisRow = berec.getRow();
                thisColumn = berec.getColumn();
                thisStr = String.valueOf(berec.getBooleanValue());
                this.cellList.add(thisColumn, thisStr);
                this.checkRowIsNull(thisStr);
                break;
            }
            case 6: {
                FormulaRecord frec = (FormulaRecord)record;
                thisRow = frec.getRow();
                thisColumn = frec.getColumn();
                if (this.outputFormulaValues) {
                    if (Double.isNaN(frec.getValue())) {
                        this.outputNextStringRecord = true;
                        this.nextRow = frec.getRow();
                        this.nextColumn = frec.getColumn();
                    } else {
                        thisStr = '\"' + HSSFFormulaParser.toFormulaString((HSSFWorkbook)this.stubWorkbook, (Ptg[])frec.getParsedExpression()) + '\"';
                    }
                } else {
                    thisStr = '\"' + HSSFFormulaParser.toFormulaString((HSSFWorkbook)this.stubWorkbook, (Ptg[])frec.getParsedExpression()) + '\"';
                }
                this.cellList.add(thisColumn, thisStr);
                this.checkRowIsNull(thisStr);
                break;
            }
            case 519: {
                if (!this.outputNextStringRecord) break;
                StringRecord srec = (StringRecord)record;
                thisStr = srec.getString();
                thisRow = this.nextRow;
                thisColumn = this.nextColumn;
                this.outputNextStringRecord = false;
                break;
            }
            case 516: {
                LabelRecord lrec = (LabelRecord)record;
                this.curRow = thisRow = lrec.getRow();
                thisColumn = lrec.getColumn();
                value = lrec.getValue().trim();
                if (StringUtils.isBlank((CharSequence)value)) {
                    value = "";
                }
                this.cellList.add(thisColumn, value);
                this.checkRowIsNull(value);
                break;
            }
            case 253: {
                LabelSSTRecord lsrec = (LabelSSTRecord)record;
                this.curRow = thisRow = lsrec.getRow();
                thisColumn = lsrec.getColumn();
                if (this.sstRecord == null) {
                    this.cellList.add(thisColumn, "");
                    break;
                }
                value = this.sstRecord.getString(lsrec.getSSTIndex()).toString().trim();
                if (StringUtils.isBlank((CharSequence)value)) {
                    value = "";
                }
                this.cellList.add(thisColumn, value);
                this.checkRowIsNull(value);
                break;
            }
            case 515: {
                NumberRecord numrec = (NumberRecord)record;
                this.curRow = thisRow = numrec.getRow();
                thisColumn = numrec.getColumn();
                Double valueDouble = numrec.getValue();
                String formatString = this.formatListener.getFormatString((CellValueRecordInterface)numrec);
                if (formatString.contains("m/d/yy")) {
                    formatString = "yyyy-MM-dd hh:mm:ss";
                }
                int formatIndex = this.formatListener.getFormatIndex((CellValueRecordInterface)numrec);
                value = this.formatter.formatRawCellContents(valueDouble.doubleValue(), formatIndex, formatString).trim();
                if (StringUtils.isBlank((CharSequence)value)) {
                    value = "";
                }
                this.cellList.add(thisColumn, value);
                this.checkRowIsNull(value);
                break;
            }
        }
        if (thisRow != -1 && thisRow != this.lastRowNumber) {
            this.lastColumnNumber = -1;
        }
        if (record instanceof MissingCellDummyRecord) {
            MissingCellDummyRecord mc = (MissingCellDummyRecord)record;
            this.curRow = thisRow = mc.getRow();
            thisColumn = mc.getColumn();
            this.cellList.add(thisColumn, "");
        }
        if (thisRow > -1) {
            this.lastRowNumber = thisRow;
        }
        if (thisColumn > -1) {
            this.lastColumnNumber = thisColumn;
        }
        if (record instanceof LastCellOfRowDummyRecord) {
            if (this.minColums > 0 && this.lastColumnNumber == -1) {
                this.lastColumnNumber = 0;
            }
            this.lastColumnNumber = -1;
            if (this.flag && this.curRow != 0) {
                ++this.totalRows;
            }
            this.cellList.clear();
            this.flag = false;
        }
    }

    public void checkRowIsNull(String value) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{value})) {
            this.flag = true;
        }
    }
}

