/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.common.excel.reader;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ExcelXlsxReader
extends DefaultHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger(ExcelXlsxReader.class);
    private SharedStringsTable sst;
    private String lastIndex;
    private int totalRows = 0;
    private List<String> cellList = new ArrayList<String>();
    private boolean flag = false;
    private int curRow = 1;
    private int curCol = 0;
    private boolean isTElement;
    private boolean startElementFlag = true;
    private boolean endElementFlag = false;
    private boolean charactersFlag = false;
    private CellDataType nextDataType = CellDataType.SSTINDEX;
    private final DataFormatter formatter = new DataFormatter();
    private short formatIndex;
    private String formatString;
    private String preRef = null;
    private String ref = null;
    private String maxRef = null;
    private StylesTable stylesTable;

    public int process(String filename) {
        OPCPackage pkg = null;
        XMLReader parser = null;
        XSSFReader xssfReader = null;
        try {
            pkg = OPCPackage.open((String)filename);
            xssfReader = new XSSFReader(pkg);
            this.stylesTable = xssfReader.getStylesTable();
            this.sst = xssfReader.getSharedStringsTable();
            parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        }
        catch (OpenXML4JException | SAXException e) {
            LOGGER.error(e.getMessage(), e);
            throw new IllegalStateException("excel\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalStateException("excel\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        parser.setContentHandler(this);
        XSSFReader.SheetIterator sheets = null;
        try {
            sheets = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
            while (sheets.hasNext()) {
                this.curRow = 1;
                InputStream sheet = sheets.next();
                InputSource sheetSource = new InputSource(sheet);
                parser.parse(sheetSource);
                sheet.close();
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalStateException("excel\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        catch (InvalidFormatException | SAXException e) {
            LOGGER.error(e.getMessage(), e);
            throw new IllegalStateException("excel\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        return this.totalRows;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("c".equals(name)) {
            if (this.preRef == null) {
                this.preRef = attributes.getValue("r");
            } else if (this.endElementFlag) {
                this.preRef = this.ref;
            }
            this.ref = attributes.getValue("r");
            if (!this.startElementFlag && !this.flag) {
                this.preRef = this.ref;
            }
            this.setNextDataType(attributes);
            this.endElementFlag = false;
            this.charactersFlag = false;
            this.startElementFlag = false;
        }
        this.isTElement = "t".equals(name);
        this.lastIndex = "";
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.startElementFlag = true;
        this.charactersFlag = true;
        this.lastIndex = this.lastIndex + new String(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.isTElement) {
            String value = this.lastIndex.trim();
            this.cellList.add(this.curCol, value);
            this.endElementFlag = true;
            ++this.curCol;
            this.isTElement = false;
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{value})) {
                this.flag = true;
            }
        } else if ("v".equals(name)) {
            String value = this.getDataValue(this.lastIndex.trim(), "");
            if (!this.ref.equals(this.preRef)) {
                int len = this.countNullCell(this.ref, this.preRef);
                for (int i = 0; i < len; ++i) {
                    this.cellList.add(this.curCol, "");
                    ++this.curCol;
                }
            } else if (!this.ref.startsWith("A")) {
                int len = this.countNullCell(this.ref, "A");
                for (int i = 0; i <= len; ++i) {
                    this.cellList.add(this.curCol, "");
                    ++this.curCol;
                }
            }
            this.cellList.add(this.curCol, value);
            ++this.curCol;
            this.endElementFlag = true;
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{value})) {
                this.flag = true;
            }
        } else if ("row".equals(name)) {
            if (this.curRow == 1) {
                this.maxRef = this.ref;
            }
            if (this.maxRef != null) {
                int len = -1;
                len = this.charactersFlag ? this.countNullCell(this.maxRef, this.ref) : this.countNullCell(this.maxRef, this.preRef);
                for (int i = 0; i <= len; ++i) {
                    this.cellList.add(this.curCol, "");
                    ++this.curCol;
                }
            }
            if (this.flag && this.curRow != 1) {
                ++this.totalRows;
            }
            this.cellList.clear();
            ++this.curRow;
            this.curCol = 0;
            this.preRef = null;
            this.ref = null;
            this.flag = false;
        }
    }

    public void setNextDataType(Attributes attributes) {
        this.nextDataType = CellDataType.NUMBER;
        this.formatIndex = (short)-1;
        this.formatString = null;
        String cellType = attributes.getValue("t");
        String cellStyleStr = attributes.getValue("c");
        if ("b".equals(cellType)) {
            this.nextDataType = CellDataType.BOOL;
        } else if ("e".equals(cellType)) {
            this.nextDataType = CellDataType.ERROR;
        } else if ("inlineStr".equals(cellType)) {
            this.nextDataType = CellDataType.INLINESTR;
        } else if ("s".equals(cellType)) {
            this.nextDataType = CellDataType.SSTINDEX;
        } else if ("str".equals(cellType)) {
            this.nextDataType = CellDataType.FORMULA;
        }
        if (cellStyleStr != null) {
            int styleIndex = Integer.parseInt(cellStyleStr);
            XSSFCellStyle style = this.stylesTable.getStyleAt(styleIndex);
            this.formatIndex = style.getDataFormat();
            this.formatString = style.getDataFormatString();
            if (this.formatString.contains("m/d/yyyy") || this.formatString.contains("yyyy/mm/dd") || this.formatString.contains("yyyy/m/d")) {
                this.nextDataType = CellDataType.DATE;
                this.formatString = "yyyy-MM-dd hh:mm:ss";
            }
            if (this.formatString == null) {
                this.nextDataType = CellDataType.NULL;
                this.formatString = BuiltinFormats.getBuiltinFormat((int)this.formatIndex);
            }
        }
    }

    public String getDataValue(String value, String thisStr) {
        switch (this.nextDataType) {
            case BOOL: {
                char first = value.charAt(0);
                thisStr = first == '0' ? "FALSE" : "TRUE";
                break;
            }
            case ERROR: {
                thisStr = "\"ERROR:" + value + '\"';
                break;
            }
            case FORMULA: {
                thisStr = value;
                break;
            }
            case INLINESTR: {
                XSSFRichTextString rtsi = new XSSFRichTextString(value);
                thisStr = rtsi.toString();
                rtsi = null;
                break;
            }
            case SSTINDEX: {
                String sstIndex = value;
                try {
                    int idx = Integer.parseInt(sstIndex);
                    XSSFRichTextString rtss = new XSSFRichTextString(this.sst.getEntryAt(idx));
                    thisStr = rtss.toString();
                }
                catch (NumberFormatException ex) {
                    thisStr = value;
                }
                break;
            }
            case NUMBER: {
                thisStr = this.formatString != null ? this.formatter.formatRawCellContents(Double.parseDouble(value), (int)this.formatIndex, this.formatString).trim() : value;
                thisStr = thisStr.replace("_", "").trim();
                break;
            }
            case DATE: {
                thisStr = this.formatter.formatRawCellContents(Double.parseDouble(value), (int)this.formatIndex, this.formatString);
                thisStr = thisStr.replace("T", " ");
                break;
            }
            default: {
                thisStr = " ";
            }
        }
        return thisStr;
    }

    public int countNullCell(String ref, String preRef) {
        String xfd = ref.replaceAll("\\d+", "");
        String xfdPre = preRef.replaceAll("\\d+", "");
        xfd = this.fillChar(xfd, 3, '@', true);
        xfdPre = this.fillChar(xfdPre, 3, '@', true);
        char[] letter = xfd.toCharArray();
        char[] letterPre = xfdPre.toCharArray();
        int res = (letter[0] - letterPre[0]) * 26 * 26 + (letter[1] - letterPre[1]) * 26 + (letter[2] - letterPre[2]);
        return res - 1;
    }

    public String fillChar(String str, int len, char let, boolean isPre) {
        block4: {
            int lenStr = str.length();
            if (lenStr >= len) break block4;
            if (isPre) {
                for (int i = 0; i < len - lenStr; ++i) {
                    str = let + str;
                }
            } else {
                for (int i = 0; i < len - lenStr; ++i) {
                    str = str + let;
                }
            }
        }
        return str;
    }

    static enum CellDataType {
        BOOL,
        ERROR,
        FORMULA,
        INLINESTR,
        SSTINDEX,
        NUMBER,
        DATE,
        NULL;

    }
}

