/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.common.excel.reader.impl;

import com.bizunited.platform.kuiper.starter.common.enums.ExcelTypeEnum;
import com.bizunited.platform.kuiper.starter.common.excel.IObgainWorkbook;
import com.bizunited.platform.kuiper.starter.common.excel.IRecordInterceptor;
import com.bizunited.platform.kuiper.starter.common.excel.exception.ExcelWraperException;
import com.bizunited.platform.kuiper.starter.common.excel.reader.IExcelReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.lang3.Validate;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DomExcelReader
implements IExcelReader,
IObgainWorkbook {
    public static final ConvertUtilsBean convertUtilsBean = new ConvertUtilsBean();
    FormulaEvaluator eva;
    private Workbook wb;

    public DomExcelReader(ExcelTypeEnum fileType, InputStream input) {
        block4: {
            this.eva = null;
            try {
                if (fileType == ExcelTypeEnum.XLS) {
                    this.wb = new HSSFWorkbook(input);
                    this.eva = new HSSFFormulaEvaluator((HSSFWorkbook)this.wb);
                    break block4;
                }
                if (fileType == ExcelTypeEnum.XLSX) {
                    this.wb = new XSSFWorkbook(input);
                    this.eva = new XSSFFormulaEvaluator((XSSFWorkbook)this.wb);
                    break block4;
                }
                throw new ExcelWraperException("\u521b\u5efaexcel\u5931\u8d25,\u8bf7\u68c0\u67e5\u6587\u4ef6\u683c\u5f0f\u3002");
            }
            catch (IOException e) {
                throw new ExcelWraperException("\u521b\u5efaexcel\u5931\u8d25,\u8bf7\u68c0\u67e5\u6587\u4ef6\u8def\u5f84\u3002");
            }
        }
    }

    @Override
    public void readSheet(Integer sheetIndex, int rowBeginIndex, int columnBeginIndex, int columnEndIndex, Class<?>[] classs, IRecordInterceptor<Object[]> interceptor) {
        Sheet sheet = this.wb.getSheetAt(sheetIndex.intValue());
        Validate.notNull((Object)sheet, (String)"sheet\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        int lastRow = sheet.getLastRowNum();
        for (int i = rowBeginIndex; i <= lastRow; ++i) {
            Object[] os = this.readRow(sheetIndex, i, columnBeginIndex, columnEndIndex, classs);
            interceptor.handle(os, i + 1);
        }
    }

    @Override
    public void readSheet(Integer sheetIndex, int columnBeginIndex, int columnEndIndex, int[] rowIndexs, Class<?>[] classs, IRecordInterceptor<Object[]> interceptor) {
        for (int i : rowIndexs) {
            Object[] os = this.readRow(sheetIndex, i, columnBeginIndex, columnEndIndex, classs);
            interceptor.handle(os, i);
        }
    }

    private Object getObjectValue(Cell cell) {
        Object r = "";
        if (cell != null) {
            CellType type = cell.getCellType();
            switch (type) {
                case NUMERIC: {
                    double val = cell.getNumericCellValue();
                    long temp = Math.round(val);
                    if (val == (double)temp) {
                        r = temp;
                        break;
                    }
                    r = val;
                    break;
                }
                case BOOLEAN: {
                    r = cell.getBooleanCellValue();
                    break;
                }
                case FORMULA: {
                    r = this.getObjectValue(this.eva.evaluateInCell(cell));
                    break;
                }
                default: {
                    r = cell.getRichStringCellValue().getString();
                }
            }
        }
        return r;
    }

    @Override
    public Object[] readRow(Integer sheetIndex, int rowIndex, int columnBeginIndex, int columnEndIndex, Class<?>[] classs) throws UnsupportedOperationException {
        if (sheetIndex < 0 || rowIndex < 0 || columnBeginIndex < 0 || columnEndIndex < 0 || columnBeginIndex >= columnEndIndex) {
            throw new ExcelWraperException("\u884c\u5217\u7d22\u5f15 \u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\u4e14\u5217\u5f00\u59cb\u7d22\u5f15\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u5217\u7ed3\u675f\u7d22\u5f15");
        }
        Sheet sheet = this.wb.getSheetAt(sheetIndex.intValue());
        if (sheet == null) {
            throw new ExcelWraperException("sheet\u4e0d\u5b58\u5728");
        }
        Object[] os = new Object[columnEndIndex - columnBeginIndex + 1];
        Row row = sheet.getRow(rowIndex);
        if (row != null) {
            for (int i = 0; i < os.length; ++i) {
                Cell cell = row.getCell(i + columnBeginIndex);
                os[i] = this.getObjectValue(cell);
                if (os[i] == null || classs == null || classs.length != os.length || classs[i] == null || classs[i].isAssignableFrom(os[i].getClass())) continue;
                os[i] = convertUtilsBean.convert(os[i], classs[i]);
            }
        } else {
            os = new Object[columnEndIndex - columnBeginIndex + 1];
            Arrays.fill(os, "");
        }
        return os;
    }

    @Override
    public Workbook getWorkbook() {
        return this.wb;
    }
}

