/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.common.excel.reader.impl;

import com.bizunited.platform.kuiper.starter.common.excel.ExcelUtils;
import com.bizunited.platform.kuiper.starter.common.excel.IRecordInterceptor;
import com.bizunited.platform.kuiper.starter.common.excel.exception.ExcelMigrateException;
import com.bizunited.platform.kuiper.starter.common.excel.exception.ExcelWraperException;
import com.bizunited.platform.kuiper.starter.common.excel.reader.IExcelReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class NewExcelEventReader
extends DefaultHandler
implements IExcelReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewExcelEventReader.class);
    public static ConvertUtilsBean convertUtilsBean = new ConvertUtilsBean();
    private SharedStringsTable sst;
    private XSSFReader reader;
    private String lastContents;
    private Object[] tempRowdata;
    private IRecordInterceptor<Object[]> recordInterceptor = null;
    private int minColumn;
    private int rowIndex = 0;
    private int columnIndex = 0;
    private int rowBeginIndex = 0;
    private int columnBeginIndex = 0;
    private Class<?>[] columnClasss;
    private int[] rowIndexs;
    private XMLReader parser;
    private CellDataType nextDataType = CellDataType.SSTINDEX;
    private final DataFormatter formatter = new DataFormatter();
    private short formatIndex;
    private String formatString;
    private StylesTable stylesTable;

    public NewExcelEventReader(InputStream is, File file) throws IOException, OpenXML4JException, SAXException {
        OPCPackage pkg = OPCPackage.open((File)file);
        this.reader = new XSSFReader(pkg);
        this.sst = this.reader.getSharedStringsTable();
        this.stylesTable = this.reader.getStylesTable();
        this.parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        this.parser.setContentHandler(this);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        this.lastContents = "";
        if ("row".equals(name)) {
            this.rowIndex = Integer.parseInt(attributes.getValue("r")) - 1;
        } else if ("c".equals(name)) {
            String r = attributes.getValue("r");
            this.columnIndex = ExcelUtils.getColumnIndex(r.replaceAll("[0-9]", "")) - 1;
            this.setNextDataType(attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("row".equals(name)) {
            this.handleNewRow();
        } else if ("v".equals(name) || "t".equals(name)) {
            Object r = null;
            r = "v".equals(name) ? this.getDataValue(this.lastContents.trim()) : this.lastContents.trim();
            if (this.rowIndex >= this.rowBeginIndex && this.columnIndex >= this.columnBeginIndex && this.columnIndex < this.columnBeginIndex + this.minColumn) {
                if (this.columnClasss != null && this.columnClasss.length == this.minColumn && this.columnClasss[this.columnIndex - this.columnBeginIndex] != null) {
                    this.tempRowdata[this.columnIndex - this.columnBeginIndex] = !this.columnClasss[this.columnIndex - this.columnBeginIndex].isAssignableFrom(r.getClass()) ? ExcelUtils.convert(r, this.columnClasss[this.columnIndex - this.columnBeginIndex]) : r;
                    this.tempRowdata[this.columnIndex - this.columnBeginIndex] = r;
                } else {
                    this.tempRowdata[this.columnIndex - this.columnBeginIndex] = r;
                }
            }
        }
    }

    private void handleNewRow() {
        if (this.rowIndexs != null) {
            if (ArrayUtils.contains((int[])this.rowIndexs, (int)this.rowIndex)) {
                this.recordInterceptor.handle(this.tempRowdata, this.rowIndex + 1);
                this.rowIndexs = ArrayUtils.removeElement((int[])this.rowIndexs, (int)this.rowIndex);
            }
            if (this.rowIndexs.length == 0) {
                throw new ExcelWraperException("\u641c\u7d22\u5b8c\u6bd5");
            }
        } else if (this.rowIndex >= this.rowBeginIndex) {
            this.recordInterceptor.handle(this.tempRowdata, this.rowIndex + 1);
        }
        this.tempRowdata = new Object[this.minColumn];
    }

    public void setNextDataType(Attributes attributes) {
        this.nextDataType = CellDataType.NUMBER;
        this.formatIndex = (short)-1;
        this.formatString = null;
        String cellType = attributes.getValue("t");
        String cellStyleStr = attributes.getValue("s");
        if ("b".equals(cellType)) {
            this.nextDataType = CellDataType.BOOL;
        } else if ("e".equals(cellType)) {
            this.nextDataType = CellDataType.ERROR;
        } else if ("inlineStr".equals(cellType)) {
            this.nextDataType = CellDataType.INLINESTR;
        } else if ("s".equals(cellType)) {
            this.nextDataType = CellDataType.SSTINDEX;
        } else if ("str".equals(cellType)) {
            this.nextDataType = CellDataType.FORMULA;
        }
        if (cellStyleStr != null) {
            int styleIndex = Integer.parseInt(cellStyleStr);
            XSSFCellStyle style = this.stylesTable.getStyleAt(styleIndex);
            this.formatIndex = style.getDataFormat();
            this.formatString = style.getDataFormatString();
            Validate.notBlank((CharSequence)this.formatString, (String)"\u65e5\u671f\u683c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165excel\u6587\u4ef6\u5355\u5143\u683c\u65e5\u671f\u683c\u5f0f\u5c5e\u6027", (Object[])new Object[0]);
            if (this.formatString.contains("m/d/yy") || this.formatString.contains("m/d/yyyy") || this.formatString.contains("yyyy/mm/dd") || this.formatString.contains("yyyy/m/d")) {
                this.nextDataType = CellDataType.DATE;
                this.formatString = "yyyy-MM-dd hh:mm:ss";
            }
            if (StringUtils.isBlank((CharSequence)this.formatString)) {
                this.nextDataType = CellDataType.NULL;
                this.formatString = BuiltinFormats.getBuiltinFormat((int)this.formatIndex);
            }
        }
    }

    public Object getDataValue(String value) {
        Object resutl = null;
        switch (this.nextDataType) {
            case BOOL: {
                char first = value.charAt(0);
                resutl = first == '0' ? Boolean.FALSE : Boolean.TRUE;
                break;
            }
            case ERROR: {
                resutl = "\"ERROR:" + value + '\"';
                break;
            }
            case FORMULA: {
                resutl = value;
                break;
            }
            case INLINESTR: {
                XSSFRichTextString rtsi = new XSSFRichTextString(value);
                resutl = rtsi.toString();
                break;
            }
            case SSTINDEX: {
                String sstIndex = value;
                try {
                    int idx = Integer.parseInt(sstIndex);
                    XSSFRichTextString rtss = new XSSFRichTextString(this.sst.getEntryAt(idx));
                    resutl = rtss.toString();
                }
                catch (NumberFormatException ex) {
                    resutl = value;
                }
                break;
            }
            case NUMBER: {
                String numStr = "";
                numStr = this.formatString != null ? this.formatter.formatRawCellContents(Double.parseDouble(value), (int)this.formatIndex, this.formatString).trim() : value;
                resutl = numStr.replace("_", "").trim();
                break;
            }
            case DATE: {
                String dateTimeStr = "";
                dateTimeStr = this.formatter.formatRawCellContents(Double.parseDouble(value), (int)this.formatIndex, this.formatString);
                resutl = dateTimeStr.replace("T", " ");
                break;
            }
            default: {
                resutl = " ";
            }
        }
        return resutl;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.lastContents = this.lastContents + new String(ch, start, length);
    }

    @Override
    public void readSheet(Integer sheetIndex, int rowBeginIndex, int columnBeginIndex, int columnEndIndex, Class<?>[] classs, IRecordInterceptor<Object[]> interceptor) {
        this.reset(sheetIndex, rowBeginIndex, columnBeginIndex, columnEndIndex, null, classs, interceptor);
    }

    @Override
    public void readSheet(Integer sheetIndex, int columnBeginIndex, int columnEndIndex, int[] rowIndexs, Class<?>[] classs, IRecordInterceptor<Object[]> interceptor) {
        this.reset(sheetIndex, 0, columnBeginIndex, columnEndIndex, rowIndexs, classs, interceptor);
    }

    @Override
    public Object[] readRow(Integer sheetIndex, int rowIndex, int columnBeginIndex, int columnEndIndex, Class<?>[] classs) throws UnsupportedOperationException {
        final ArrayList list = new ArrayList();
        this.reset(sheetIndex, 0, columnBeginIndex, columnEndIndex, new int[]{rowIndex}, classs, new IRecordInterceptor<Object[]>(){

            @Override
            public void handle(Object[] t, int rowIndex) {
                list.add(t);
            }
        });
        return list.isEmpty() ? null : (Object[])list.get(0);
    }

    private void reset(Integer sheetIndex, int rowBeginIndex, int columnBeginIndex, int columnEndIndex, int[] rowIndexs, Class<?>[] classs, IRecordInterceptor<Object[]> interceptor) {
        Validate.notNull(interceptor, (String)"excel\u6570\u636e\u5904\u7406\u62e6\u622a\u5668\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        this.rowBeginIndex = rowBeginIndex;
        this.columnBeginIndex = columnBeginIndex;
        this.recordInterceptor = interceptor;
        this.columnClasss = classs;
        this.minColumn = columnEndIndex - columnBeginIndex + 1;
        this.rowIndexs = rowIndexs;
        this.rowIndex = 0;
        this.columnIndex = 0;
        this.tempRowdata = new Object[this.minColumn];
        Iterator sheets = null;
        try {
            sheets = this.reader.getSheetsData();
        }
        catch (IOException | InvalidFormatException e) {
            throw new ExcelWraperException("excel\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25", e);
        }
        int i = 0;
        while (sheets.hasNext()) {
            InputStream sheet = (InputStream)sheets.next();
            if (sheetIndex != null && sheetIndex >= 0 && !sheetIndex.equals(i)) {
                ++i;
                continue;
            }
            InputSource sheetSource = new InputSource(sheet);
            try {
                this.parser.parse(sheetSource);
                sheet.close();
            }
            catch (ExcelWraperException e) {
                if (!"\u641c\u7d22\u5b8c\u6bd5".equals(e.getMessage())) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new ExcelMigrateException("excel \u5c01\u88c5\u9519\u8bef");
                }
            }
            catch (SAXException e) {
                throw new ExcelWraperException("excel\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25", e);
            }
            catch (IOException e) {
                throw new ExcelWraperException("excel\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25", e);
            }
            ++i;
        }
    }

    static {
        convertUtilsBean.register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                if (value != null) {
                    return (T)DateUtil.getJavaDate((double)Double.parseDouble(value.toString()));
                }
                return null;
            }
        }, Date.class);
        convertUtilsBean.register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                String src;
                if (value != null && (src = value.toString()).matches("\\d+(\\.\\d+)?")) {
                    BigDecimal bigDecimal = new BigDecimal(value.toString());
                    return (T)new Integer(bigDecimal.intValue());
                }
                return null;
            }
        }, Integer.class);
    }

    static enum CellDataType {
        BOOL,
        ERROR,
        FORMULA,
        INLINESTR,
        SSTINDEX,
        NUMBER,
        DATE,
        NULL;

    }
}

