/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.common.excel.reader.impl;

import com.bizunited.platform.kuiper.starter.common.excel.ExcelUtils;
import com.bizunited.platform.kuiper.starter.common.excel.IRecordInterceptor;
import com.bizunited.platform.kuiper.starter.common.excel.exception.ExcelWraperException;
import com.bizunited.platform.kuiper.starter.common.excel.reader.IExcelReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.poi.hssf.eventusermodel.EventWorkbookBuilder;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.MissingRecordAwareHSSFListener;
import org.apache.poi.hssf.eventusermodel.dummyrecord.LastCellOfRowDummyRecord;
import org.apache.poi.hssf.eventusermodel.dummyrecord.MissingCellDummyRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OldExcelEventReader
implements HSSFListener,
IExcelReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(OldExcelEventReader.class);
    private POIFSFileSystem fs;
    private boolean outputFormulaValues = true;
    private SSTRecord sstRecord;
    private FormatTrackingHSSFListener formatListener;
    private List<BoundSheetRecord> boundSheetRecords = new ArrayList<BoundSheetRecord>();
    private boolean outputNextStringRecord;
    private IRecordInterceptor<Object[]> recordInterceptor = null;
    private List<Object> tempRowdata = new ArrayList<Object>();
    private int rowIndex = 0;
    private int columnIndex = 0;
    private int rowBeginIndex = 0;
    private int columnBeginIndex = 0;
    private int minColumn = 0;
    private int[] rowIndexs;
    private Class<?>[] columnClasss;
    private Integer sheetIndex;
    private HSSFEventFactory factory = new HSSFEventFactory();
    private HSSFRequest request;
    private byte[] data;

    public OldExcelEventReader(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int read = 0;
        while ((read = is.read(buffer)) != -1) {
            baos.write(buffer, 0, read);
        }
        this.data = baos.toByteArray();
        this.formatListener = new FormatTrackingHSSFListener((HSSFListener)new MissingRecordAwareHSSFListener((HSSFListener)this));
        this.request = new HSSFRequest();
        if (this.outputFormulaValues) {
            this.request.addListenerForAllRecords((HSSFListener)this.formatListener);
        } else {
            EventWorkbookBuilder.SheetRecordCollectingListener workbookBuildingListener = new EventWorkbookBuilder.SheetRecordCollectingListener((HSSFListener)this.formatListener);
            this.request.addListenerForAllRecords((HSSFListener)workbookBuildingListener);
        }
    }

    public void processRecord(Record record) {
        block32: {
            String thisStr = null;
            switch (record.getSid()) {
                case 133: {
                    this.boundSheetRecords.add((BoundSheetRecord)record);
                    break;
                }
                case 2057: {
                    break;
                }
                case 520: {
                    break;
                }
                case 252: {
                    this.sstRecord = (SSTRecord)record;
                    break;
                }
                case 513: {
                    thisStr = "";
                    break;
                }
                case 517: {
                    thisStr = "";
                    break;
                }
                case 6: {
                    FormulaRecord frec = (FormulaRecord)record;
                    if (this.outputFormulaValues) {
                        if (Double.isNaN(frec.getValue())) {
                            this.outputNextStringRecord = true;
                            break;
                        }
                        thisStr = this.formatListener.formatNumberDateCell((CellValueRecordInterface)frec);
                        break;
                    }
                    thisStr = "function";
                    break;
                }
                case 519: {
                    if (!this.outputNextStringRecord) break;
                    StringRecord srec = (StringRecord)record;
                    thisStr = srec.getString();
                    this.outputNextStringRecord = false;
                    break;
                }
                case 516: {
                    LabelRecord lrec = (LabelRecord)record;
                    thisStr = lrec.getValue();
                    break;
                }
                case 253: {
                    LabelSSTRecord lsrec = (LabelSSTRecord)record;
                    if (this.sstRecord == null) {
                        thisStr = "";
                        break;
                    }
                    thisStr = this.sstRecord.getString(lsrec.getSSTIndex()).toString();
                    break;
                }
                case 515: {
                    NumberRecord numrec = (NumberRecord)record;
                    thisStr = this.formatListener.formatNumberDateCell((CellValueRecordInterface)numrec);
                    break;
                }
            }
            if (this.sheetIndex != null && this.sheetIndex > 0 && !this.sheetIndex.equals(this.boundSheetRecords.size() - 1)) {
                return;
            }
            if (record instanceof CellValueRecordInterface) {
                CellValueRecordInterface rcRecord = (CellValueRecordInterface)record;
                this.rowIndex = rcRecord.getRow();
                this.columnIndex = rcRecord.getColumn();
            }
            if (record instanceof MissingCellDummyRecord) {
                thisStr = "";
            }
            if (this.columnIndex >= this.columnBeginIndex) {
                if (thisStr != null && this.columnClasss != null && this.columnClasss.length == this.minColumn && this.columnClasss[this.columnIndex] != null) {
                    try {
                        if (!this.columnClasss[this.columnIndex].isAssignableFrom(thisStr.getClass())) {
                            this.tempRowdata.add(ExcelUtils.convert(thisStr, this.columnClasss[this.columnIndex]));
                            break block32;
                        }
                        this.tempRowdata.add(thisStr);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                        this.tempRowdata.add(thisStr);
                    }
                } else {
                    this.tempRowdata.add(thisStr);
                }
            }
        }
        if (record instanceof LastCellOfRowDummyRecord) {
            Object[] r = this.tempRowdata.toArray();
            if (r.length != this.minColumn) {
                r = Arrays.copyOf(r, this.minColumn);
            }
            if (this.rowIndexs != null) {
                if (ArrayUtils.contains((int[])this.rowIndexs, (int)this.rowIndex)) {
                    this.recordInterceptor.handle(r, this.rowIndex + 1);
                    this.rowIndexs = ArrayUtils.removeElement((int[])this.rowIndexs, (int)this.rowIndex);
                }
                if (this.rowIndexs.length == 0) {
                    throw new ExcelWraperException("\u641c\u7d22\u5b8c\u6bd5");
                }
            } else if (this.rowIndex >= this.rowBeginIndex) {
                this.recordInterceptor.handle(r, this.rowIndex + 1);
            }
            this.tempRowdata.clear();
        }
    }

    @Override
    public void readSheet(Integer sheetIndex, int rowBeginIndex, int columnBeginIndex, int columnEndIndex, Class<?>[] classs, IRecordInterceptor<Object[]> interceptor) {
        this.reset(sheetIndex, rowBeginIndex, columnBeginIndex, columnEndIndex, null, classs, interceptor);
    }

    @Override
    public void readSheet(Integer sheetIndex, int columnBeginIndex, int columnEndIndex, int[] rowIndexs, Class<?>[] classs, IRecordInterceptor<Object[]> interceptor) {
        this.reset(sheetIndex, 0, columnBeginIndex, columnEndIndex, rowIndexs, classs, interceptor);
    }

    @Override
    public Object[] readRow(Integer sheetIndex, int rowIndex, int columnBeginIndex, int columnEndIndex, Class<?>[] classs) throws UnsupportedOperationException {
        final ArrayList list = new ArrayList();
        this.reset(sheetIndex, 0, columnBeginIndex, columnEndIndex, new int[]{rowIndex}, classs, new IRecordInterceptor<Object[]>(){

            @Override
            public void handle(Object[] t, int rowIndex) {
                list.add(t);
            }
        });
        return list.isEmpty() ? null : (Object[])list.get(0);
    }

    private void reset(Integer sheetIndex, int rowBeginIndex, int columnBeginIndex, int columnEndIndex, int[] rowIndexs, Class<?>[] classs, IRecordInterceptor<Object[]> interceptor) {
        Validate.notNull(interceptor, (String)"excel\u5904\u7406\u62e6\u622a\u5668\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        this.rowBeginIndex = rowBeginIndex;
        this.columnBeginIndex = columnBeginIndex;
        this.recordInterceptor = interceptor;
        this.columnClasss = classs;
        this.minColumn = columnEndIndex - columnBeginIndex + 1;
        this.sheetIndex = sheetIndex;
        this.rowIndexs = rowIndexs;
        this.rowIndex = 0;
        this.columnIndex = 0;
        try {
            this.fs = new POIFSFileSystem((InputStream)new ByteArrayInputStream(this.data));
        }
        catch (IOException e) {
            throw new ExcelWraperException("excel\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef", e);
        }
        try {
            this.factory.processWorkbookEvents(this.request, this.fs);
        }
        catch (ExcelWraperException e) {
            if (!"\u641c\u7d22\u5b8c\u6bd5".equals(e.getMessage())) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new ExcelWraperException("excel\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef", e);
        }
    }
}

