/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.configuration;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableAsync
@Configuration
public class FormDetailsMigrateTaskConfiguration {
    @Value(value="${kuiper.migrate.pool.core-size:1}")
    private Integer coreSize;
    @Value(value="${kuiper.migrate.pool.max-size:2}")
    private Integer maxSize;

    @Bean(value={"fromDetailsMigrateExecutor"})
    public ThreadPoolTaskExecutor taskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.coreSize.intValue());
        executor.setMaxPoolSize(this.maxSize.intValue());
        executor.setQueueCapacity(0);
        executor.setThreadNamePrefix("migrate-task-executor-");
        executor.setAwaitTerminationSeconds(10);
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.initialize();
        return executor;
    }
}

