/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.FormDetailsExportBoxEntity;
import com.bizunited.platform.kuiper.starter.service.FormDetailsExportBoxService;
import com.bizunited.platform.kuiper.starter.vo.FormDetailsExportBoxVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="FormDetailsExportBoxController")
@RestController
@RequestMapping(value={"/v1/kuiper/formDetailsExportBox"})
public class FormDetailsExportBoxController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormDetailsExportBoxController.class);
    @Autowired
    private FormDetailsExportBoxService formDetailsExportBoxService;

    @ApiOperation(value="\u521b\u5efa\u5bfc\u51fa\u6570\u636e\u8bb0\u5f55")
    @PostMapping(value={"/export"})
    public ResponseModel export(FormDetailsExportBoxVo formDetailsExportBoxVo, HttpServletRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Enumeration names = request.getParameterNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String[] values = request.getParameterValues(name);
                if (values != null && values.length == 1) {
                    params.put(name, values[0]);
                    continue;
                }
                if (values == null || values.length <= 1) continue;
                params.put(name, values);
            }
        }
        try {
            return this.buildHttpResultW((Object)this.formDetailsExportBoxService.export(formDetailsExportBoxVo, params), new String[]{"creator", "executor"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5bfc\u51fa\u5de5\u5177\u7bb1\u5217\u8868")
    @GetMapping(value={"/queryAll"})
    public ResponseModel queryAll(@ApiParam(value="\u5206\u9875\u4fe1\u606f") @PageableDefault(value=5) Pageable pageable) {
        try {
            Page<FormDetailsExportBoxEntity> entitys = this.formDetailsExportBoxService.queryPage(pageable);
            return this.buildHttpResultW(entitys, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u770b\u5bfc\u51fa\u5355\u6761\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ResponseModel query(@PathVariable(value="id") @ApiParam(value="\u4e3b\u952e", required=true) String id) {
        try {
            FormDetailsExportBoxEntity entity = this.formDetailsExportBoxService.findById(id);
            return this.buildHttpResultW((Object)entity, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6e05\u9664\u5bfc\u51fa\u8bb0\u5f55")
    @DeleteMapping(value={"/{id}"})
    public ResponseModel deleteById(@PathVariable(value="id") @ApiParam(value="\u4e3b\u952e", required=true) String id) {
        try {
            this.formDetailsExportBoxService.deleteById(id);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u53d6\u6d88\u5f53\u524d\u5bfc\u5165\u8fdb\u7a0b")
    @PutMapping(value={"/{id}"})
    public ResponseModel cancel(@PathVariable(value="id") @ApiParam(value="\u4e3b\u952e", required=true) String id) {
        try {
            this.formDetailsExportBoxService.cancel(id);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u51fa\u6570\u636e")
    @GetMapping(value={"/download/{id}"})
    public void download(@PathVariable(value="id") @ApiParam(value="\u4e3b\u952e", required=true) String id, HttpServletRequest request, HttpServletResponse response) {
        try {
            byte[] bytes = this.formDetailsExportBoxService.download(id);
            FormDetailsExportBoxEntity entity = this.formDetailsExportBoxService.findById(id);
            Validate.isTrue((boolean)ArrayUtils.isNotEmpty((byte[])bytes), (String)"\u6ca1\u6709\u4efb\u4f55\u5bfc\u51fa\u4fe1\u606f", (Object[])new Object[0]);
            String fileName = entity.getDownloadFileName();
            this.writeResponseFile(request, response, bytes, fileName);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.printResponseModel(this.buildHttpResultForException(e), response);
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u8be5\u63a5\u53e3\uff0c\u7cfb\u7edf\u5c06\u53ef\u4ee5\u8fd4\u56de\u8be5\u8fdb\u7a0b\u4e2d\u5df2\u7ecf\u88ab\u626b\u63cf\u5230\u7684\u6240\u6709\u4e1a\u52a1\u6570\u636e\u5bfc\u5165\u5904\u7406\u5668\u7684\u7c7b\u540d\u4fe1\u606f")
    @GetMapping(value={"/findProcessClassNames"})
    public ResponseModel findProcessClassNames() {
        try {
            Set<String> results = this.formDetailsExportBoxService.findProcessClassNames();
            return this.buildHttpResultW(results, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6e05\u9664\u5bfc\u5165\u5217\u8868\u6240\u6709\u6570\u636e")
    @DeleteMapping(value={"/deleteAll"})
    public ResponseModel clearAll() {
        try {
            this.formDetailsExportBoxService.deleteAll();
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

