/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.FormDetailsImportBoxDetailsEntity;
import com.bizunited.platform.kuiper.entity.FormDetailsImportBoxEntity;
import com.bizunited.platform.kuiper.starter.service.FormDetailsImportBoxService;
import com.bizunited.platform.kuiper.starter.vo.FormDetailsImportBoxVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="FormDetailsImportBoxController")
@RestController
@RequestMapping(value={"/v1/kuiper/formDetailsImportBox"})
public class FormDetailsImportBoxController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormDetailsImportBoxController.class);
    private FormDetailsImportBoxService formDetailsImportBoxService;

    public FormDetailsImportBoxController(FormDetailsImportBoxService formDetailsImportBoxService) {
        this.formDetailsImportBoxService = formDetailsImportBoxService;
    }

    @PostMapping(value={"/execute"})
    @ApiOperation(value="\u6267\u884c\u5bfc\u5165")
    public ResponseModel execute(FormDetailsImportBoxVo formDetailsImportBoxVo, HttpServletRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Enumeration names = request.getParameterNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String[] values = request.getParameterValues(name);
                if (values != null && values.length == 1) {
                    params.put(name, values[0]);
                    continue;
                }
                if (values == null || values.length <= 1) continue;
                params.put(name, values);
            }
        }
        try {
            FormDetailsImportBoxEntity entity = this.formDetailsImportBoxService.execute(formDetailsImportBoxVo, params);
            return this.buildHttpResultW((Object)entity, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6267\u884cexcel\u6821\u9a8c")
    @PostMapping(value={"/excelCheck"})
    public ResponseModel excelCheck(FormDetailsImportBoxVo formDetailsImportBoxVo, HttpServletRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Enumeration names = request.getParameterNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String[] values = request.getParameterValues(name);
                if (values != null && values.length == 1) {
                    params.put(name, values[0]);
                    continue;
                }
                if (values == null || values.length <= 1) continue;
                params.put(name, values);
            }
        }
        try {
            FormDetailsImportBoxEntity entity = this.formDetailsImportBoxService.excelCheck(formDetailsImportBoxVo, params);
            return this.buildHttpResultW((Object)entity, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6267\u884cexcel\u6821\u9a8c\u540e\u5bfc\u5165")
    @PostMapping(value={"/excelImport"})
    public ResponseModel excelImport(@ApiParam(value="\u5bfc\u5165\u8bb0\u5f55id") @RequestParam(value="id") String id, HttpServletRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Enumeration names = request.getParameterNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String[] values = request.getParameterValues(name);
                if (values != null && values.length == 1) {
                    params.put(name, values[0]);
                    continue;
                }
                if (values == null || values.length <= 1) continue;
                params.put(name, values);
            }
        }
        try {
            FormDetailsImportBoxEntity entity = this.formDetailsImportBoxService.excelImport(id, params);
            return this.buildHttpResultW((Object)entity, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u4e0a\u4f20\u5de5\u5177\u7bb1\u5217\u8868")
    @GetMapping(value={"/queryAll"})
    public ResponseModel queryAll(@ApiParam(value="\u5206\u9875\u4fe1\u606f") @PageableDefault(value=5) Pageable pageable) {
        try {
            Page<FormDetailsImportBoxEntity> entitys = this.formDetailsImportBoxService.queryPage(pageable);
            return this.buildHttpResultW(entitys, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u72b6\u6001\u83b7\u53d6\u5bfc\u5165\u5217\u8868\u6570\u636e")
    @GetMapping(value={"/queryByStatus"})
    public ResponseModel queryByStatus(@ApiParam(value="\u5206\u9875\u4fe1\u606f") @PageableDefault(value=5) Pageable pageable, @ApiParam(value="\u72b6\u6001", required=true) Integer[] status) {
        try {
            Page<FormDetailsImportBoxEntity> entitys = this.formDetailsImportBoxService.queryPageByExecuteResult(pageable, status);
            return this.buildHttpResultW(entitys, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6e05\u9664\u5bfc\u5165\u8bb0\u5f55")
    @DeleteMapping(value={"/{id}"})
    public ResponseModel deleteById(@PathVariable(value="id") @ApiParam(value="\u4e3b\u952e", required=true) String id) {
        try {
            this.formDetailsImportBoxService.deleteById(id);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u53d6\u6d88\u5f53\u524d\u5bfc\u5165\u4efb\u52a1")
    @PutMapping(value={"/{id}"})
    public ResponseModel cancel(@PathVariable(value="id") @ApiParam(value="\u4e3b\u952e", required=true) String id) {
        try {
            this.formDetailsImportBoxService.cancel(id);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u770b\u5bfc\u5165\u5355\u6761\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ResponseModel query(@PathVariable(value="id") @ApiParam(value="\u4e3b\u952e", required=true) String id) {
        try {
            FormDetailsImportBoxEntity entity = this.formDetailsImportBoxService.findById(id);
            return this.buildHttpResultW((Object)entity, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u770b\u5bfc\u5165\u8be6\u60c5\u4fe1\u606f")
    @GetMapping(value={"/details/{id}"})
    public ResponseModel queryPageById(@PathVariable(value="id") @ApiParam(value="\u4e3b\u952e", required=true) String id) {
        try {
            Page<FormDetailsImportBoxDetailsEntity> page = this.formDetailsImportBoxService.queryPageById(id);
            return this.buildHttpResultW(page.getContent(), new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4e0b\u8f7d\u9519\u8bef\u6587\u4ef6")
    @GetMapping(value={"/errorFile/{id}"})
    public void errorFile(@PathVariable(value="id") @ApiParam(value="\u4e3b\u952e", required=true) String id, HttpServletRequest request, HttpServletResponse response) {
        try {
            byte[] bytes = this.formDetailsImportBoxService.exportErrorFile(id);
            FormDetailsImportBoxEntity entity = this.formDetailsImportBoxService.findById(id);
            Validate.isTrue((boolean)ArrayUtils.isNotEmpty((byte[])bytes), (String)"\u6ca1\u6709\u4efb\u4f55\u4e0b\u8f7d\u4fe1\u606f", (Object[])new Object[0]);
            String fileName = StringUtils.join((Object[])new String[]{entity.getOriginalFileName()});
            String time = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            fileName = fileName.substring(0, fileName.lastIndexOf(".")) + "-" + time + "." + fileName.substring(fileName.lastIndexOf(".") + 1);
            this.writeResponseFile(request, response, bytes, fileName);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.printResponseModel(this.buildHttpResultForException(e), response);
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u8be5\u63a5\u53e3\uff0c\u7cfb\u7edf\u5c06\u53ef\u4ee5\u8fd4\u56de\u8be5\u8fdb\u7a0b\u4e2d\u5df2\u7ecf\u88ab\u626b\u63cf\u5230\u7684\u6240\u6709\u4e1a\u52a1\u6570\u636e\u5bfc\u5165\u5904\u7406\u5668\u7684\u7c7b\u540d\u4fe1\u606f")
    @GetMapping(value={"/findProcessClassNames"})
    public ResponseModel findProcessClassNames() {
        try {
            Set<String> results = this.formDetailsImportBoxService.findProcessClassNames();
            return this.buildHttpResultW(results, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6e05\u9664\u5bfc\u5165\u5217\u8868\u6240\u6709\u6570\u636e")
    @DeleteMapping(value={"/deleteAll"})
    public ResponseModel clearAll() {
        try {
            this.formDetailsImportBoxService.deleteAll();
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

