/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.kuiper.entity.FormDetailsExportBoxEntity;
import com.bizunited.platform.kuiper.starter.repository.FormDetailsExportBoxRepository;
import com.bizunited.platform.kuiper.starter.service.FormDetailsExportBoxService;
import com.bizunited.platform.kuiper.starter.service.FormDetailsExportBoxTaskService;
import com.bizunited.platform.kuiper.starter.service.instances.imports.FormDetailsExportBoxProcess;
import com.bizunited.platform.kuiper.starter.vo.FormDetailsExportBoxVo;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import java.security.Principal;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="FormDetailsExportBoxServiceImpl")
public class FormDetailsExportBoxServiceImpl
implements FormDetailsExportBoxService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormDetailsExportBoxServiceImpl.class);
    @Autowired
    private FormDetailsExportBoxRepository formDetailsExportBoxRepository;
    @Autowired
    private VenusFileService venusFileService;
    @Autowired
    private UserService userService;
    @Autowired
    private FormDetailsExportBoxTaskService formDetailsExportBoxTaskService;
    @Autowired
    private PlatformContext platformContext;

    @Override
    public FormDetailsExportBoxEntity export(FormDetailsExportBoxVo formDetailsExportBoxVo, Map<String, Object> params) {
        this.executeValidation(formDetailsExportBoxVo);
        Principal principal = SecurityUtils.getPrincipal();
        Validate.notNull((Object)principal, (String)"\u5f53\u524d\u64cd\u4f5c\u8005\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String account = principal.getName();
        UserVo currentUser = this.userService.findByAccount(account);
        Validate.notNull((Object)currentUser, (String)"\u9519\u8bef\u7684\u64cd\u4f5c\u8005\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        FormDetailsExportBoxEntity entity = new FormDetailsExportBoxEntity();
        entity.setProcessClassName(formDetailsExportBoxVo.getProcessClassName());
        entity.setExportField(formDetailsExportBoxVo.getExportField());
        entity.setExportParam(formDetailsExportBoxVo.getExportParam());
        entity.setTemplateName(formDetailsExportBoxVo.getTemplateName());
        entity.setTemplateVersion(formDetailsExportBoxVo.getTemplateVersion());
        entity.setTemplateCode(formDetailsExportBoxVo.getTemplateCode());
        entity.setListTemplateName(formDetailsExportBoxVo.getListTemplateName());
        entity.setListTemplateVersion(formDetailsExportBoxVo.getListTemplateVersion());
        entity.setListTemplateCode(formDetailsExportBoxVo.getListTemplateCode());
        entity.setDataViewCode(formDetailsExportBoxVo.getDataViewCode());
        entity.setProjectName(this.platformContext.getAppName());
        Validate.notBlank((CharSequence)formDetailsExportBoxVo.getProcessClassName(), (String)"\u6307\u5b9a\u7684process Class name\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Class<?> processClass = null;
        try {
            processClass = ApplicationContextUtils.getApplicationContext().getClassLoader().loadClass(formDetailsExportBoxVo.getProcessClassName());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(String.format("\u5728\u5f53\u524d\u8fdb\u7a0b\u7684spring ioc\u5bb9\u5668\u4e2d\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684process Class[%s]\uff0c\u8bf7\u68c0\u67e5!!", formDetailsExportBoxVo.getProcessClassName()));
        }
        Validate.isTrue((boolean)FormDetailsExportBoxProcess.class.isAssignableFrom(processClass), (String)"\u5f53\u524d\u7ed9\u5b9a\u7684processClassName\u5e76\u6ca1\u6709\u6b63\u786e\u5b9e\u73b0FormDetailsImportBoxProcess\u63a5\u53e3\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        FormDetailsExportBoxProcess process = (FormDetailsExportBoxProcess)ApplicationContextUtils.getApplicationContext().getBean(processClass);
        Validate.notNull(params, (String)"\u4f20\u9012\u53c2\u6570\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        params.put("account", account);
        params.put("request", this.getRequest());
        params.put("cookies", this.getRequest().getCookies());
        try {
            this.formDetailsExportBoxTaskService.exportProcess(entity, process, account, params);
        }
        catch (TaskRejectedException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            this.failedExport(entity);
            throw new IllegalArgumentException("\u8d85\u51fa\u5bfc\u51fa\u4efb\u52a1\u5e76\u53d1\u6267\u884c\u6570");
        }
        entity.setExecuteStartTime(new Date());
        entity.setExecuteResult(2);
        entity.setExecutor(account);
        entity.setDelete(false);
        entity.setProjectName(this.platformContext.getAppName());
        entity = (FormDetailsExportBoxEntity)((Object)this.formDetailsExportBoxRepository.saveAndFlush((Object)entity));
        return entity;
    }

    private void executeValidation(FormDetailsExportBoxVo formDetailsExportBoxVo) {
        Validate.notBlank((CharSequence)formDetailsExportBoxVo.getProcessClassName(), (String)"\u6307\u5b9a\u7684process Class name\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
    }

    @Transactional(rollbackOn={Exception.class})
    FormDetailsExportBoxEntity failedExport(FormDetailsExportBoxEntity entity) {
        Validate.notBlank((CharSequence)entity.getId(), (String)"\u5bfc\u51fa\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        entity.setExecuteResult(0);
        entity.setDelete(true);
        entity.setProjectName(this.platformContext.getAppName());
        return (FormDetailsExportBoxEntity)((Object)this.formDetailsExportBoxRepository.saveAndFlush((Object)entity));
    }

    @Override
    public FormDetailsExportBoxEntity findById(String id) {
        Optional op = this.formDetailsExportBoxRepository.findById(id);
        FormDetailsExportBoxEntity current = op.orElse(null);
        Validate.notNull((Object)((Object)current), (String)"\u5bfc\u51fa\u8bb0\u5f55\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)SecurityUtils.getUserAccount().equals(current.getExecutor()), (String)"\u65e0\u8be5\u6570\u636e\u64cd\u4f5c\u6743\u9650\uff01", (Object[])new Object[0]);
        return current;
    }

    @Override
    public Page<FormDetailsExportBoxEntity> queryPage(Pageable pageable) {
        return this.formDetailsExportBoxRepository.queryPageByDelete(false, SecurityUtils.getUserAccount(), this.platformContext.getAppName(), pageable);
    }

    @Override
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u5220\u9664\u4fe1\u606f\u4e3b\u952e\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Optional op = this.formDetailsExportBoxRepository.findById(id);
        FormDetailsExportBoxEntity current = op.orElse(null);
        Validate.notNull((Object)((Object)current), (String)"\u5220\u9664\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)SecurityUtils.getUserAccount().equals(current.getExecutor()), (String)"\u65e0\u8be5\u6570\u636e\u64cd\u4f5c\u6743\u9650\uff01", (Object[])new Object[0]);
        current.setDelete(true);
        this.formDetailsExportBoxRepository.saveAndFlush((Object)current);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void deleteAll() {
        this.formDetailsExportBoxRepository.deleteAll(this.platformContext.getAppName(), SecurityUtils.getUserAccount());
    }

    @Override
    public void cancel(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u5bfc\u51fa\u8bb0\u5f55\u4e3b\u952e\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Optional op = this.formDetailsExportBoxRepository.findById(id);
        FormDetailsExportBoxEntity current = op.orElse(null);
        Validate.notNull((Object)((Object)current), (String)"\u5bfc\u51fa\u8bb0\u5f55\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)SecurityUtils.getUserAccount().equals(current.getExecutor()), (String)"\u65e0\u8be5\u6570\u636e\u64cd\u4f5c\u6743\u9650\uff01", (Object[])new Object[0]);
        current.setExecuteResult(0);
        this.formDetailsExportBoxRepository.saveAndFlush((Object)current);
    }

    @Override
    public byte[] download(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u5bfc\u51fa\u8bb0\u5f55\u4e3b\u952e\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Optional op = this.formDetailsExportBoxRepository.findById(id);
        FormDetailsExportBoxEntity current = op.orElse(null);
        Validate.notNull((Object)((Object)current), (String)"\u5bfc\u51fa\u8bb0\u5f55\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        return this.venusFileService.readFileContent(current.getRelativeLocal(), current.getFileName());
    }

    @Override
    public Set<String> findProcessClassNames() {
        Map map = ApplicationContextUtils.getApplicationContext().getBeansOfType(FormDetailsExportBoxProcess.class);
        return map.values().stream().map(process -> {
            if (AopUtils.isCglibProxy((Object)process) || AopUtils.isAopProxy((Object)process)) {
                return AopUtils.getTargetClass((Object)process).getName();
            }
            return process.getClass().getName();
        }).collect(Collectors.toSet());
    }

    private HttpServletRequest getRequest() {
        HttpServletRequest request = null;
        ServletRequestAttributes servletRequestAttributes = null;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
            request = servletRequestAttributes.getRequest();
        }
        Validate.notNull(request, (String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524drequest", (Object[])new Object[0]);
        return request;
    }
}

