/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.kuiper.entity.FormDetailsExportBoxEntity;
import com.bizunited.platform.kuiper.starter.common.excel.ExcelExportWrapper;
import com.bizunited.platform.kuiper.starter.common.excel.ExcelExportWrapperBuilder;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelColumn;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelExport;
import com.bizunited.platform.kuiper.starter.common.excel.exception.ExcelMigrateException;
import com.bizunited.platform.kuiper.starter.repository.FormDetailsExportBoxRepository;
import com.bizunited.platform.kuiper.starter.service.FormDetailsExportBoxTaskService;
import com.bizunited.platform.kuiper.starter.service.instances.imports.FormDetailsExportBoxProcess;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.venus.common.service.file.FileRelativeTemplate;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="FormDetailsExportBoxTaskServiceImpl")
public class FormDetailsExportBoxTaskServiceImpl
implements FormDetailsExportBoxTaskService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormDetailsExportBoxTaskServiceImpl.class);
    private static final String FORM_DETAILS = "formdetails";
    @Autowired
    private FileRelativeTemplate fileRelativeTemplate;
    @Autowired
    private FormDetailsExportBoxRepository formDetailsExportBoxRepository;
    @Autowired
    private VenusFileService venusFileService;
    @Autowired
    private PlatformContext platformContext;
    @Value(value="${venus.file.fileRoot}")
    private String fileRoot;

    @Override
    @Async(value="fromDetailsMigrateExecutor")
    public void exportProcess(FormDetailsExportBoxEntity entity, FormDetailsExportBoxProcess<?> process, String account, Map<String, Object> params) {
        Class<?> excelBean = null;
        if (params.get("exportClassName") != null) {
            String exportClassName = null;
            try {
                exportClassName = params.get("exportClassName").toString();
                excelBean = Class.forName(exportClassName);
            }
            catch (ClassNotFoundException e2) {
                throw new IllegalArgumentException(String.format("\u672a\u77e5\u7684\u7c7b\u8def\u5f84\u3010%s\u3011\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!!", exportClassName));
            }
        } else {
            excelBean = this.getInterfaceGeneric(process, 0, FormDetailsExportBoxProcess.class);
        }
        NebulaExcelExport nebulaExcelExport = null;
        if (excelBean != null) {
            nebulaExcelExport = excelBean.getAnnotation(NebulaExcelExport.class);
        }
        Validate.notNull((Object)nebulaExcelExport, (String)"excel\u5bfc\u51fabean\u672a\u914d\u7f6eNebulaExcelExport\u6ce8\u89e3", (Object[])new Object[0]);
        TreeMap titleMap = Maps.newTreeMap();
        TreeMap fieldMap = Maps.newTreeMap();
        Field[] localFields = excelBean.getDeclaredFields();
        Field[] supperFields = excelBean.getSuperclass().getDeclaredFields();
        List<Object> fields = Lists.newArrayList();
        fields.addAll(Arrays.asList(localFields));
        fields.addAll(Arrays.asList(supperFields));
        int rowId = 0;
        JSONArray exportField = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{entity.getExportField()})) {
            exportField = JSONArray.parseArray((String)entity.getExportField());
        }
        if (exportField != null && exportField.size() > 0) {
            JSONArray finalExportField = exportField;
            fields = fields.stream().filter(e -> finalExportField.contains((Object)e.getName())).collect(Collectors.toList());
        }
        for (Field field : fields) {
            if (nebulaExcelExport == null) {
                titleMap.put(rowId, field.getName());
                ++rowId;
                continue;
            }
            NebulaExcelColumn nebulaExcelColumn = field.getAnnotation(NebulaExcelColumn.class);
            if (nebulaExcelColumn == null) continue;
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{nebulaExcelColumn.title()})) {
                titleMap.put(nebulaExcelColumn.order(), nebulaExcelColumn.title());
            } else {
                titleMap.put(nebulaExcelColumn.order(), field.getName());
            }
            fieldMap.put(nebulaExcelColumn.order(), field);
        }
        String[] titles = new String[titleMap.values().size()];
        titles = titleMap.values().toArray(titles);
        String relativePath = this.fileRelativeTemplate.generatRelativePath(FORM_DETAILS, "");
        File exportFile = this.createLocalExcelFile("".getBytes(), relativePath);
        AtomicInteger rowIndex = new AtomicInteger(0);
        AtomicInteger columnIndex = new AtomicInteger(0);
        JSONArray exportParam = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{entity.getExportParam()})) {
            exportParam = JSONArray.parseArray((String)entity.getExportParam());
        }
        Optional<Object> opExportParam = Optional.ofNullable(exportParam);
        try (FileOutputStream os = new FileOutputStream(exportFile);){
            ExcelExportWrapper excelExportWrapper = ExcelExportWrapperBuilder.buildWithSXSSFWorkbook();
            SecurityUtils.setPrincipal((String)account);
            Sheet sheet = this.sheetBuild(excelExportWrapper, nebulaExcelExport);
            this.writeHeaderData(excelExportWrapper, sheet, titles, rowIndex, columnIndex);
            PageRequest pageable = PageRequest.of((int)0, (int)nebulaExcelExport.pageSize());
            Optional<String> dataViewCode = Optional.ofNullable(entity.getDataViewCode());
            Page<?> page = process.exportProcess((Pageable)pageable, dataViewCode, exportField, opExportParam, params);
            this.writePageData(excelExportWrapper, sheet, page, fieldMap, rowIndex, columnIndex);
            while (page.hasNext()) {
                if (!this.checkStatus(entity.getId())) {
                    ((OutputStream)os).close();
                    if (!exportFile.delete()) {
                        LOGGER.warn("\u5bfc\u51fa\u4e34\u65f6\u6587\u4ef6\u5220\u9664\u9519\u8bef");
                    }
                    throw new ExcelMigrateException("\u5bfc\u51fa\u6570\u636e\u53d6\u6d88");
                }
                pageable = page.nextPageable();
                page = process.exportProcess((Pageable)pageable, dataViewCode, exportField, opExportParam, params);
                this.writePageData(excelExportWrapper, sheet, page, fieldMap, rowIndex, columnIndex);
            }
            excelExportWrapper.export(os);
            LOGGER.info("\u5bfc\u51fa\u6570\u636e\u5199\u5165\u4e34\u65f6\u6587\u4ef6\u5904\u7406\u5b8c\u6210");
        }
        catch (Exception e3) {
            LOGGER.error(e3.getMessage(), (Throwable)e3);
            this.failRecord(entity);
            throw new IllegalArgumentException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25");
        }
        entity.setFileName(exportFile.getName());
        entity.setRelativeLocal(relativePath);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{nebulaExcelExport.excelName()})) {
            if (nebulaExcelExport.excelName().endsWith(".xls") || nebulaExcelExport.excelName().endsWith(".xlsx")) {
                entity.setDownloadFileName(nebulaExcelExport.excelName());
            } else {
                entity.setDownloadFileName(StringUtils.join((Object[])new String[]{nebulaExcelExport.excelName(), ".xlsx"}));
            }
        } else {
            entity.setDownloadFileName(entity.getFileName());
        }
        try {
            byte[] fileBytes = FileUtils.readFileToByteArray((File)exportFile);
            this.venusFileService.saveFile(entity.getRelativeLocal(), entity.getDownloadFileName(), entity.getFileName(), fileBytes);
        }
        catch (IOException e4) {
            this.failRecord(entity);
            throw new IllegalArgumentException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25", e4);
        }
        this.complateRecord(entity);
        LOGGER.info("\u66f4\u65b0\u5bfc\u51fa\u6570\u636e\u8bb0\u5f55");
    }

    private boolean checkStatus(String id) {
        Optional op = this.formDetailsExportBoxRepository.findById(id);
        FormDetailsExportBoxEntity entity = op.orElse(null);
        Validate.notNull((Object)((Object)entity), (String)"\u5bfc\u51fa\u6570\u636e\u8bb0\u5f55\u4e3a\u7a7a", (Object[])new Object[0]);
        Integer status = entity.getExecuteResult();
        return status == 2;
    }

    private Sheet sheetBuild(ExcelExportWrapper excelExportWrapper, NebulaExcelExport nebulaExcelExport) {
        Sheet sheet = null;
        sheet = nebulaExcelExport != null ? excelExportWrapper.buildSheet(nebulaExcelExport.sheetName()) : excelExportWrapper.buildSheet("\u6570\u636e");
        return sheet;
    }

    private void writeHeaderData(ExcelExportWrapper excelExportWrapper, Sheet sheet, String[] titles, AtomicInteger rowIndex, AtomicInteger columnIndex) {
        excelExportWrapper.paint(sheet, rowIndex.intValue(), columnIndex.intValue(), (Object[])titles);
        rowIndex.getAndIncrement();
    }

    private void writePageData(ExcelExportWrapper excelExportWrapper, Sheet sheet, Page<?> page, Map<Integer, Field> fieldMap, AtomicInteger rowIndex, AtomicInteger columnIndex) {
        for (Object data : page) {
            Object[] values = this.getValues(data, fieldMap);
            excelExportWrapper.paint(sheet, rowIndex.intValue(), columnIndex.intValue(), values);
            rowIndex.getAndIncrement();
        }
    }

    private void failRecord(FormDetailsExportBoxEntity entity) {
        Validate.notNull((Object)((Object)entity), (String)"\u5bfc\u51fa\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        entity.setExecuteEndTime(new Date());
        entity.setExecuteResult(1);
        entity.setProjectName(this.platformContext.getAppName());
        this.formDetailsExportBoxRepository.saveAndFlush((Object)entity);
    }

    private void complateRecord(FormDetailsExportBoxEntity entity) {
        Validate.notNull((Object)((Object)entity), (String)"\u5bfc\u51fa\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        entity.setExecuteEndTime(new Date());
        entity.setExecuteResult(1);
        entity.setProjectName(this.platformContext.getAppName());
        this.formDetailsExportBoxRepository.saveAndFlush((Object)entity);
    }

    private File createLocalExcelFile(byte[] bytes, String relativePath) {
        String renameImage = UUID.randomUUID().toString();
        String fileRename = StringUtils.join((Object[])new String[]{renameImage, ".", "xlsx"});
        File folder = new File(StringUtils.join((Object[])new String[]{this.fileRoot, relativePath}));
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File file = new File(folder, fileRename);
        try {
            Validate.isTrue((boolean)file.createNewFile(), (String)"\u521b\u5efa\u672c\u5730\u6587\u4ef6\u5931\u8d25\uff1a%s", (Object[])new Object[]{file.getAbsolutePath()});
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(String.format("\u521b\u5efa\u672c\u5730\u6587\u4ef6\u5931\u8d25\uff1a%s", e.getMessage()));
        }
        if (bytes != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            try (FileOutputStream fos = new FileOutputStream(file);){
                int realLen;
                int maxLen = 4096;
                byte[] contents = new byte[maxLen];
                while ((realLen = bais.read(contents, 0, maxLen)) != -1) {
                    fos.write(contents, 0, realLen);
                }
            }
            catch (FileNotFoundException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u672c\u5730\u6587\u4ef6\uff1a%s", file.getAbsolutePath()));
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(String.format("\u8bfb\u53d6\u672c\u5730\u6587\u4ef6\u5931\u8d25\uff1a%s", e.getMessage()));
            }
        }
        return file;
    }

    private Object[] getValues(Object o, Map<Integer, Field> fieldMap) {
        ArrayList values = Lists.newArrayList();
        fieldMap.values().forEach(field -> {
            block14: {
                field.setAccessible(true);
                NebulaExcelColumn nebulaExcelColumn = field.getAnnotation(NebulaExcelColumn.class);
                Class<?> fieldType = field.getType();
                Method fieldGetMethod = null;
                try {
                    Comparable<Long> temp;
                    Method[] localMethods = o.getClass().getDeclaredMethods();
                    Method[] supperMethods = o.getClass().getSuperclass().getDeclaredMethods();
                    ArrayList methodsList = Lists.newArrayList();
                    List<Method> localList = Arrays.asList(localMethods);
                    List<Method> supperList = Arrays.asList(supperMethods);
                    methodsList.addAll(localList);
                    methodsList.addAll(supperList);
                    for (Method m : methodsList) {
                        if (!StringUtils.equals((CharSequence)m.getName(), (CharSequence)("get" + StringUtils.capitalize((String)field.getName())))) continue;
                        fieldGetMethod = m;
                        break;
                    }
                    if (fieldGetMethod == null) {
                        throw new ExcelMigrateException(nebulaExcelColumn, "\u5b57\u6bb5\u5c5e\u6027get\u65b9\u6cd5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5:" + field.getName());
                    }
                    Object value = fieldGetMethod.invoke(o, new Object[0]);
                    if (value == null) {
                        values.add(null);
                        return;
                    }
                    if (String.class.isAssignableFrom(fieldType)) {
                        values.add(String.valueOf(value));
                        break block14;
                    }
                    if (Date.class.isAssignableFrom(fieldType)) {
                        String dateFormat = null;
                        if (nebulaExcelColumn != null) {
                            dateFormat = nebulaExcelColumn.format();
                        }
                        Date date = (Date)value;
                        SimpleDateFormat sdf = null;
                        sdf = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dateFormat}) ? new SimpleDateFormat(dateFormat) : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        values.add(sdf.format(date));
                        break block14;
                    }
                    if (Integer.class.isAssignableFrom(fieldType) || Integer.TYPE.isAssignableFrom(fieldType)) {
                        Integer intval = (Integer)value;
                        values.add(intval);
                        break block14;
                    }
                    if (Long.class.isAssignableFrom(fieldType) || Long.TYPE.isAssignableFrom(fieldType)) {
                        temp = (Long)value;
                        values.add(temp);
                        break block14;
                    }
                    if (Double.class.isAssignableFrom(fieldType) || Double.TYPE.isAssignableFrom(fieldType)) {
                        temp = (Double)value;
                        values.add(temp);
                        break block14;
                    }
                    if (Boolean.class.isAssignableFrom(fieldType) || Boolean.TYPE.isAssignableFrom(fieldType)) {
                        temp = (Boolean)value;
                        values.add(temp);
                        break block14;
                    }
                    if (Float.class.isAssignableFrom(fieldType) || Float.TYPE.isAssignableFrom(fieldType)) {
                        temp = (Float)value;
                        values.add(temp);
                        break block14;
                    }
                    if (BigDecimal.class.isAssignableFrom(fieldType)) {
                        temp = new BigDecimal(String.valueOf(value));
                        values.add(temp);
                        break block14;
                    }
                    LOGGER.error(String.format("not supper type: %s ", fieldType));
                    throw new ExcelMigrateException(nebulaExcelColumn, "\u5b57\u6bb5\u7c7b\u578b\u65e0\u6548 \u5b57\u6bb5:" + field.getName() + " \u7c7b\u578b:" + fieldType);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new ExcelMigrateException(nebulaExcelColumn, "\u5b57\u6bb5\u5c5e\u6027get\u65b9\u6cd5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5:" + field.getName(), e);
                }
            }
        });
        return values.toArray(new Object[values.size()]);
    }

    private Class<?> getInterfaceGeneric(Object obj, Integer index, Class<?> interfaceClass) {
        Class<?> clazz = null;
        clazz = AopUtils.isCglibProxy((Object)obj) || AopUtils.isAopProxy((Object)obj) ? AopUtils.getTargetClass((Object)obj) : obj.getClass();
        AnnotatedType[] annotatedTypes = clazz.getAnnotatedInterfaces();
        if (annotatedTypes == null) {
            return null;
        }
        for (AnnotatedType annotatedType : annotatedTypes) {
            Type[] params;
            Type type = annotatedType.getType();
            if (!(type instanceof ParameterizedType) || !interfaceClass.getName().equals(((ParameterizedType)type).getRawType().getTypeName()) || (params = ((ParameterizedType)type).getActualTypeArguments()) == null || params.length < index) continue;
            try {
                Class cc = (Class)params[index];
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                return Class.forName(cc.getName(), false, classLoader);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error(e.getMessage());
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }
}

