/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.kuiper.entity.FormDetailsImportBoxDetailsEntity;
import com.bizunited.platform.kuiper.entity.FormDetailsImportBoxEntity;
import com.bizunited.platform.kuiper.starter.repository.FormDetailsImportBoxDetailsRepository;
import com.bizunited.platform.kuiper.starter.repository.FormDetailsImportBoxRepository;
import com.bizunited.platform.kuiper.starter.service.FormDetailsImportBoxService;
import com.bizunited.platform.kuiper.starter.service.FormDetailsImportBoxTaskService;
import com.bizunited.platform.kuiper.starter.service.instances.imports.FormDetailsImportBoxProcess;
import com.bizunited.platform.kuiper.starter.vo.FormDetailsImportBoxVo;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import java.security.Principal;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="FormDetailsImportBoxServiceImpl")
public class FormDetailsImportBoxServiceImpl
implements FormDetailsImportBoxService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormDetailsImportBoxServiceImpl.class);
    private static final Integer MAX_DETAILES_RECORD = 50;
    @Autowired
    private FormDetailsImportBoxRepository formDetailsImportBoxRepository;
    @Autowired
    private FormDetailsImportBoxDetailsRepository formDetailsImportBoxDetailsRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private FormDetailsImportBoxTaskService formDetailsImportBoxTaskService;
    @Autowired
    private VenusFileService venusFileService;
    @Autowired
    private PlatformContext platformContext;

    @Transactional(rollbackOn={Exception.class})
    FormDetailsImportBoxEntity startImport(FormDetailsImportBoxEntity entity, String account) {
        Validate.notNull((Object)entity.getCreateTime(), (String)"\u4fdd\u5b58\u8bb0\u5f55\u65f6\uff0c\u5bfc\u5165\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getRelativeLocal(), (String)"\u5bfc\u5165\u6587\u4ef6\u5728\u672c\u5730\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getFileName(), (String)"\u5bfc\u5165\u6587\u4ef6\u91cd\u547d\u540d\u540e\u7684\u6587\u4ef6\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getCreator(), (String)"\u5bfc\u5165\u6587\u4ef6\u4e0a\u4f20\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getProcessClassName(), (String)"\u5bfc\u5165\u5904\u7406\u7c7b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)entity), (String)"\u5f00\u59cb\u5bfc\u5165\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        entity.setExecutor(account);
        entity.setExecuteStartTime(new Date());
        entity.setExecuteResult(1);
        entity.setProjectName(this.platformContext.getAppName());
        return (FormDetailsImportBoxEntity)((Object)this.formDetailsImportBoxRepository.saveAndFlush((Object)entity));
    }

    @Transactional(rollbackOn={Exception.class})
    FormDetailsImportBoxEntity startCheck(FormDetailsImportBoxEntity entity, String account) {
        Validate.notNull((Object)entity.getCreateTime(), (String)"\u4fdd\u5b58\u8bb0\u5f55\u65f6\uff0c\u5bfc\u5165\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getRelativeLocal(), (String)"\u5bfc\u5165\u6587\u4ef6\u5728\u672c\u5730\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getFileName(), (String)"\u5bfc\u5165\u6587\u4ef6\u91cd\u547d\u540d\u540e\u7684\u6587\u4ef6\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getCreator(), (String)"\u5bfc\u5165\u6587\u4ef6\u4e0a\u4f20\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getProcessClassName(), (String)"\u5bfc\u5165\u5904\u7406\u7c7b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)entity), (String)"\u5f00\u59cb\u5bfc\u5165\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        entity.setExecutor(account);
        entity.setExecuteStartTime(new Date());
        entity.setExecuteResult(4);
        entity.setProjectName(this.platformContext.getAppName());
        return (FormDetailsImportBoxEntity)((Object)this.formDetailsImportBoxRepository.saveAndFlush((Object)entity));
    }

    @Transactional(rollbackOn={Exception.class})
    FormDetailsImportBoxEntity failedImport(FormDetailsImportBoxEntity entity) {
        Validate.notBlank((CharSequence)entity.getId(), (String)"\u5bfc\u5165\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        entity.setExecuteResult(0);
        entity.setExecuteEndTime(new Date());
        entity.setDelete(true);
        entity.setProjectName(this.platformContext.getAppName());
        return (FormDetailsImportBoxEntity)((Object)this.formDetailsImportBoxRepository.saveAndFlush((Object)entity));
    }

    @Transactional(rollbackOn={Exception.class})
    FormDetailsImportBoxEntity successImport(FormDetailsImportBoxEntity entity) {
        Validate.notBlank((CharSequence)entity.getId(), (String)"\u5bfc\u5165\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        entity.setExecuteResult(2);
        entity.setExecuteEndTime(new Date());
        entity.setDelete(true);
        entity.setProjectName(this.platformContext.getAppName());
        return (FormDetailsImportBoxEntity)((Object)this.formDetailsImportBoxRepository.saveAndFlush((Object)entity));
    }

    private FormDetailsImportBoxEntity createImportData(FormDetailsImportBoxVo formDetailsImportBoxVo, Map<String, Object> params) {
        FormDetailsImportBoxEntity entity = new FormDetailsImportBoxEntity();
        entity.setCreateTime(new Date());
        entity.setCreator(SecurityUtils.getUserAccount());
        entity.setOriginalFileName(formDetailsImportBoxVo.getOriginalFileName());
        entity.setDelete(false);
        entity.setFileName(formDetailsImportBoxVo.getFileName());
        entity.setRelativeLocal(formDetailsImportBoxVo.getRelativePath());
        entity.setFileSize(formDetailsImportBoxVo.getFileSize());
        entity.setTemplateName(formDetailsImportBoxVo.getTemplateName());
        entity.setTemplateCode(formDetailsImportBoxVo.getTemplateCode());
        entity.setTemplateVersion(formDetailsImportBoxVo.getTemplateVersion());
        entity.setProcessClassName(formDetailsImportBoxVo.getProcessClassName());
        entity.setBtnCode(formDetailsImportBoxVo.getBtnCode());
        entity.setListTemplateName(formDetailsImportBoxVo.getListTemplateName());
        entity.setListTemplateCode(formDetailsImportBoxVo.getListTemplateCode());
        entity.setListTemplateVersion(formDetailsImportBoxVo.getListTemplateVersion());
        entity.setTemplateFileName(formDetailsImportBoxVo.getTemplateFileName());
        entity.setTemplateFileRelativeLocal(formDetailsImportBoxVo.getTemplateFileRelativePath());
        entity.setProjectName(this.platformContext.getAppName());
        if (params != null && !params.isEmpty()) {
            entity.setParams(JsonUtils.obj2JsonString(params));
        }
        return entity;
    }

    @Override
    public FormDetailsImportBoxEntity execute(FormDetailsImportBoxVo formDetailsImportBoxVo, Map<String, Object> params) {
        this.executeValidation(formDetailsImportBoxVo);
        Principal principal = SecurityUtils.getPrincipal();
        Validate.notNull((Object)principal, (String)"\u5f53\u524d\u64cd\u4f5c\u8005\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String account = principal.getName();
        UserVo currentUser = this.userService.findByAccount(account);
        Validate.notNull((Object)currentUser, (String)"\u9519\u8bef\u7684\u64cd\u4f5c\u8005\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Class<?> processClass = null;
        try {
            processClass = ApplicationContextUtils.getApplicationContext().getClassLoader().loadClass(formDetailsImportBoxVo.getProcessClassName());
        }
        catch (ClassNotFoundException | NullPointerException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(String.format("\u5728\u5f53\u524d\u8fdb\u7a0b\u7684spring ioc\u5bb9\u5668\u4e2d\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684process Class[%s]\uff0c\u8bf7\u68c0\u67e5!!", formDetailsImportBoxVo.getProcessClassName()));
        }
        Validate.notNull(processClass, (String)"\u5bfc\u5165\u903b\u8f91\u5904\u7406\u7c7b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)FormDetailsImportBoxProcess.class.isAssignableFrom(processClass), (String)"\u5f53\u524d\u7ed9\u5b9a\u7684processClassName\u5e76\u6ca1\u6709\u6b63\u786e\u5b9e\u73b0FormDetailsImportBoxProcess\u63a5\u53e3\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        FormDetailsImportBoxProcess process = (FormDetailsImportBoxProcess)ApplicationContextUtils.getApplicationContext().getBean(processClass);
        FormDetailsImportBoxEntity entity = this.createImportData(formDetailsImportBoxVo, params);
        this.startImport(entity, account);
        Validate.notNull(params, (String)"\u4f20\u9012\u53c2\u6570\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        params.put("account", account);
        params.put("request", this.getRequest());
        params.put("cookies", this.getRequest().getCookies());
        params.put("currentUser", currentUser);
        try {
            this.formDetailsImportBoxTaskService.importProcess(entity, process, account, params);
        }
        catch (TaskRejectedException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            this.failedImport(entity);
            throw new IllegalArgumentException("\u8d85\u51fa\u5bfc\u5165\u4efb\u52a1\u5e76\u53d1\u6267\u884c\u6570");
        }
        return entity;
    }

    @Override
    public FormDetailsImportBoxEntity excelCheck(FormDetailsImportBoxVo formDetailsImportBoxVo, Map<String, Object> params) {
        this.executeValidation(formDetailsImportBoxVo);
        Principal principal = SecurityUtils.getPrincipal();
        Validate.notNull((Object)principal, (String)"\u5f53\u524d\u64cd\u4f5c\u8005\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String account = principal.getName();
        UserVo currentUser = this.userService.findByAccount(account);
        Validate.notNull((Object)currentUser, (String)"\u9519\u8bef\u7684\u64cd\u4f5c\u8005\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Class<?> processClass = null;
        try {
            processClass = ApplicationContextUtils.getApplicationContext().getClassLoader().loadClass(formDetailsImportBoxVo.getProcessClassName());
        }
        catch (ClassNotFoundException | NullPointerException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(String.format("\u5728\u5f53\u524d\u8fdb\u7a0b\u7684spring ioc\u5bb9\u5668\u4e2d\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684process Class[%s]\uff0c\u8bf7\u68c0\u67e5!!", formDetailsImportBoxVo.getProcessClassName()));
        }
        Validate.notNull(processClass, (String)"\u5bfc\u5165\u903b\u8f91\u5904\u7406\u7c7b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)FormDetailsImportBoxProcess.class.isAssignableFrom(processClass), (String)"\u5f53\u524d\u7ed9\u5b9a\u7684processClassName\u5e76\u6ca1\u6709\u6b63\u786e\u5b9e\u73b0FormDetailsImportBoxProcess\u63a5\u53e3\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        FormDetailsImportBoxProcess process = (FormDetailsImportBoxProcess)ApplicationContextUtils.getApplicationContext().getBean(processClass);
        FormDetailsImportBoxEntity entity = this.createImportData(formDetailsImportBoxVo, params);
        this.startCheck(entity, account);
        Validate.notNull(params, (String)"\u4f20\u9012\u53c2\u6570\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        params.put("account", account);
        params.put("request", this.getRequest());
        params.put("id", entity.getId());
        params.put("cookies", this.getRequest().getCookies());
        params.put("currentUser", currentUser);
        try {
            this.formDetailsImportBoxTaskService.checkProcess(entity, process, account, params);
        }
        catch (TaskRejectedException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            this.failedImport(entity);
            throw new IllegalArgumentException("\u8d85\u51fa\u5bfc\u5165\u4efb\u52a1\u5e76\u53d1\u6267\u884c\u6570", e);
        }
        return entity;
    }

    @Override
    public FormDetailsImportBoxEntity excelImport(String id, Map<String, Object> params) {
        FormDetailsImportBoxEntity entity = this.formDetailsImportBoxRepository.findById(id).orElse(null);
        Validate.notNull((Object)((Object)entity), (String)"\u5bfc\u5165excel\u6570\u636e\u7f16\u53f7\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((entity.getExecuteResult() == 5 ? 1 : 0) != 0, (String)"\u5f53\u524d\u5bfc\u5165\u8bb0\u5f55\u72b6\u6001\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Principal principal = SecurityUtils.getPrincipal();
        Validate.notNull((Object)principal, (String)"\u5f53\u524d\u64cd\u4f5c\u8005\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String account = principal.getName();
        UserVo currentUser = this.userService.findByAccount(account);
        Validate.notNull((Object)currentUser, (String)"\u9519\u8bef\u7684\u64cd\u4f5c\u8005\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.startImport(entity, account);
        Class<?> processClass = null;
        try {
            processClass = ApplicationContextUtils.getApplicationContext().getClassLoader().loadClass(entity.getProcessClassName());
        }
        catch (ClassNotFoundException | NullPointerException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(String.format("\u5728\u5f53\u524d\u8fdb\u7a0b\u7684spring ioc\u5bb9\u5668\u4e2d\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684process Class[%s]\uff0c\u8bf7\u68c0\u67e5!!", entity.getProcessClassName()));
        }
        Validate.notNull(processClass, (String)"\u5bfc\u5165\u903b\u8f91\u5904\u7406\u7c7b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)FormDetailsImportBoxProcess.class.isAssignableFrom(processClass), (String)"\u5f53\u524d\u7ed9\u5b9a\u7684processClassName\u5e76\u6ca1\u6709\u6b63\u786e\u5b9e\u73b0FormDetailsImportBoxProcess\u63a5\u53e3\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        FormDetailsImportBoxProcess process = (FormDetailsImportBoxProcess)ApplicationContextUtils.getApplicationContext().getBean(processClass);
        String paramsJson = entity.getParams();
        if (StringUtils.isNotBlank((CharSequence)paramsJson)) {
            Map entityParams = (Map)JsonUtils.json2Obj((String)paramsJson, Map.class);
            params.putAll(entityParams);
        }
        params.put("account", account);
        params.put("request", this.getRequest());
        params.put("cookies", this.getRequest().getCookies());
        params.put("currentUser", currentUser);
        try {
            this.formDetailsImportBoxTaskService.asyncImport(entity, process, account, params);
        }
        catch (Exception e) {
            this.failedImport(entity);
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(String.format("\u6267\u884c\u6570\u636e\u5bfc\u5165\u9519\u8bef,\u9519\u8bef\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", e.getMessage()));
        }
        this.successImport(entity);
        return entity;
    }

    private void executeValidation(FormDetailsImportBoxVo formDetailsImportBoxVo) {
        Validate.notBlank((CharSequence)formDetailsImportBoxVo.getOriginalFileName(), (String)"\u5bfc\u5165\u6587\u4ef6\u540d\u539f\u540d\u79f0\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)formDetailsImportBoxVo.getFileName(), (String)"\u5bfc\u5165\u6587\u4ef6\u540d\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)formDetailsImportBoxVo.getRelativePath(), (String)"\u5bfc\u5165\u6587\u4ef6\u670d\u52a1\u5668\u5730\u5740\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)formDetailsImportBoxVo.getProcessClassName(), (String)"\u6307\u5b9a\u7684process Class name\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)formDetailsImportBoxVo.getTemplateFileName(), (String)"\u5bfc\u5165\u6a21\u677f\u6587\u4ef6\u540d\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)formDetailsImportBoxVo.getTemplateFileRelativePath(), (String)"\u5bfc\u5165\u6a21\u677f\u6587\u4ef6\u76f8\u5bf9\u8def\u5f84\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    @Override
    public Page<FormDetailsImportBoxEntity> queryPage(Pageable pageable) {
        return this.formDetailsImportBoxRepository.queryPageByDelete(false, SecurityUtils.getUserAccount(), this.platformContext.getAppName(), pageable);
    }

    @Override
    public Page<FormDetailsImportBoxEntity> queryPageByExecuteResult(Pageable pageable, Integer[] results) {
        Validate.isTrue((boolean)ArrayUtils.isNotEmpty((Object[])results), (String)"\u5bfc\u5165\u8bb0\u5f55\u67e5\u8be2\u72b6\u6001\u503c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        return this.formDetailsImportBoxRepository.queryPageByDeleteAndExecuteResult(results, false, SecurityUtils.getUserAccount(), this.platformContext.getAppName(), pageable);
    }

    @Override
    public FormDetailsImportBoxEntity findById(String id) {
        Optional op = this.formDetailsImportBoxRepository.findById(id);
        FormDetailsImportBoxEntity current = op.orElse(null);
        Validate.notNull((Object)((Object)current), (String)"\u672a\u67e5\u8be2\u5230\u5bfc\u5165\u8bb0\u5f55", (Object[])new Object[0]);
        Validate.isTrue((boolean)SecurityUtils.getUserAccount().equals(current.getExecutor()), (String)"\u65e0\u8be5\u6570\u636e\u64cd\u4f5c\u6743\u9650\uff01", (Object[])new Object[0]);
        return current;
    }

    @Override
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u5220\u9664\u4fe1\u606f\u4e3b\u952e\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Optional op = this.formDetailsImportBoxRepository.findById(id);
        FormDetailsImportBoxEntity current = op.orElse(null);
        Validate.notNull((Object)((Object)current), (String)"\u5220\u9664\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)SecurityUtils.getUserAccount().equals(current.getExecutor()), (String)"\u65e0\u8be5\u6570\u636e\u64cd\u4f5c\u6743\u9650\uff01", (Object[])new Object[0]);
        current.setDelete(true);
        this.formDetailsImportBoxRepository.saveAndFlush((Object)current);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void deleteAll() {
        this.formDetailsImportBoxRepository.deleteAll(this.platformContext.getAppName(), SecurityUtils.getUserAccount());
    }

    @Override
    public void cancel(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u5bfc\u5165\u8bb0\u5f55\u4e3b\u952e\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Optional op = this.formDetailsImportBoxRepository.findById(id);
        FormDetailsImportBoxEntity current = op.orElse(null);
        Validate.notNull((Object)((Object)current), (String)"\u5bfc\u5165\u8bb0\u5f55\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)SecurityUtils.getUserAccount().equals(current.getExecutor()), (String)"\u65e0\u8be5\u6570\u636e\u64cd\u4f5c\u6743\u9650\uff01", (Object[])new Object[0]);
        current.setExecuteResult(3);
        this.formDetailsImportBoxRepository.saveAndFlush((Object)current);
    }

    @Override
    public Page<FormDetailsImportBoxDetailsEntity> queryPageById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u5bfc\u5165\u8bb0\u5f55\u4e3b\u952e\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        PageRequest pageable = PageRequest.of((int)0, (int)MAX_DETAILES_RECORD);
        Page<FormDetailsImportBoxDetailsEntity> page = this.formDetailsImportBoxDetailsRepository.findByFormDetailsImportBoxId(id, this.platformContext.getAppName(), (Pageable)pageable);
        return page;
    }

    @Override
    public byte[] exportErrorFile(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u5bfc\u5165\u8bb0\u5f55\u4e3b\u952e\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Optional op = this.formDetailsImportBoxRepository.findById(id);
        FormDetailsImportBoxEntity entity = op.orElse(null);
        Validate.notNull((Object)((Object)entity), (String)"\u65e0\u5bfc\u5165\u9519\u8bef\u6587\u4ef6", (Object[])new Object[0]);
        return this.venusFileService.readFileContent(entity.getErrorFileRelativeLocal(), entity.getErrorFileName());
    }

    @Override
    public Set<String> findProcessClassNames() {
        Map map = ApplicationContextUtils.getApplicationContext().getBeansOfType(FormDetailsImportBoxProcess.class);
        return map.values().stream().map(process -> {
            if (AopUtils.isCglibProxy((Object)process) || AopUtils.isAopProxy((Object)process)) {
                return AopUtils.getTargetClass((Object)process).getName();
            }
            return process.getClass().getName();
        }).collect(Collectors.toSet());
    }

    private HttpServletRequest getRequest() {
        HttpServletRequest request = null;
        ServletRequestAttributes servletRequestAttributes = null;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
            request = servletRequestAttributes.getRequest();
        }
        Validate.notNull(request, (String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524drequest", (Object[])new Object[0]);
        return request;
    }
}

