/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.util.FileUtils;
import com.bizunited.platform.kuiper.entity.FormDetailsImportBoxDetailsEntity;
import com.bizunited.platform.kuiper.entity.FormDetailsImportBoxEntity;
import com.bizunited.platform.kuiper.starter.common.enums.ExcelTypeEnum;
import com.bizunited.platform.kuiper.starter.common.excel.ExcelExportWrapper;
import com.bizunited.platform.kuiper.starter.common.excel.ExcelExportWrapperBuilder;
import com.bizunited.platform.kuiper.starter.common.excel.ExcelImportWrapper;
import com.bizunited.platform.kuiper.starter.common.excel.ExcelImportWrapperBuilder;
import com.bizunited.platform.kuiper.starter.common.excel.ExcelUtils;
import com.bizunited.platform.kuiper.starter.common.excel.IRecordInterceptor;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelImport;
import com.bizunited.platform.kuiper.starter.common.excel.exception.ExcelMigrateException;
import com.bizunited.platform.kuiper.starter.repository.FormDetailsImportBoxDetailsRepository;
import com.bizunited.platform.kuiper.starter.repository.FormDetailsImportBoxRepository;
import com.bizunited.platform.kuiper.starter.service.FormDetailesImportBoxExtService;
import com.bizunited.platform.kuiper.starter.service.FormDetailsImportBoxTaskService;
import com.bizunited.platform.kuiper.starter.service.instances.imports.FormDetailsImportBoxProcess;
import com.bizunited.platform.venus.common.service.file.FileRelativeTemplate;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.HibernateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="FormDetailsImportBoxTaskServiceImpl")
public class FormDetailsImportBoxTaskServiceImpl
implements FormDetailsImportBoxTaskService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormDetailsImportBoxTaskServiceImpl.class);
    private static final String FORM_DETAILS = "formdetails";
    @Autowired
    private FormDetailsImportBoxRepository formDetailsImportBoxRepository;
    @Autowired
    private FormDetailsImportBoxDetailsRepository formDetailsImportBoxDetailsRepository;
    @Autowired
    private VenusFileService venusFileService;
    @Autowired
    private FileRelativeTemplate fileRelativeTemplate;
    @Autowired(required=false)
    private FormDetailesImportBoxExtService formDetailesImportBoxExtService;
    @Autowired
    private PlatformContext platformContext;
    @Value(value="${venus.file.fileRoot}")
    private String fileRoot;

    @Override
    @Async(value="fromDetailsMigrateExecutor")
    public void importProcess(final FormDetailsImportBoxEntity entity, final FormDetailsImportBoxProcess<Object, Object> process, final String account, final Map<String, Object> params) {
        byte[] fileByte;
        LOGGER.debug("\u5f02\u6b65\u6267\u884c\u5bfc\u5165");
        final AtomicInteger startRow = new AtomicInteger(0);
        final AtomicInteger startColumn = new AtomicInteger(0);
        AtomicInteger endColumn = new AtomicInteger(0);
        AtomicInteger sheetIndex = new AtomicInteger(0);
        final Class<?> excelBean = this.getInterfaceGeneric(process, 1, FormDetailsImportBoxProcess.class);
        NebulaExcelImport nebulaExcelImport = null;
        if (excelBean != null) {
            nebulaExcelImport = excelBean.getAnnotation(NebulaExcelImport.class);
        }
        Validate.notNull((Object)nebulaExcelImport, (String)"excelProperty bean\u672a\u6dfb\u52a0NebulaExcelImport\u6ce8\u89e3,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        startRow.addAndGet(nebulaExcelImport.startRow());
        startColumn.addAndGet(nebulaExcelImport.startColumn());
        endColumn.addAndGet(nebulaExcelImport.endColumn());
        sheetIndex.addAndGet(nebulaExcelImport.sheetIndex());
        final AtomicInteger totalNum = new AtomicInteger(0);
        final AtomicInteger successNum = new AtomicInteger(0);
        final AtomicInteger failedNum = new AtomicInteger(0);
        if (endColumn.intValue() <= startColumn.intValue()) {
            endColumn = new AtomicInteger(excelBean.getDeclaredFields().length);
        }
        if ((fileByte = this.venusFileService.readFileContent(entity.getRelativeLocal(), entity.getFileName())) == null || fileByte.length <= 0) {
            this.errorRecord(entity, 0, "\u5bfc\u5165\u6587\u4ef6\u4e3a\u7a7a\uff01");
            throw new RuntimeException("\u5bfc\u5165\u6587\u4ef6\u4e3a\u7a7a!");
        }
        byte[] templateByte = this.venusFileService.readFileContent(entity.getTemplateFileRelativeLocal(), entity.getTemplateFileName());
        if (templateByte == null || templateByte.length <= 0) {
            this.errorRecord(entity, 0, "\u5bfc\u5165\u6a21\u677f\u6587\u4ef6\u4e3a\u7a7a\uff01");
            throw new RuntimeException("\u5bfc\u5165\u6a21\u677f\u6587\u4ef6\u4e3a\u7a7a!");
        }
        File tmpFile = null;
        try {
            tmpFile = FileUtils.writeLocalFile((byte[])fileByte, (String)this.fileRoot, (String)ExcelTypeEnum.XLSX.getValue());
        }
        catch (RuntimeException e) {
            this.errorRecord(entity, 0, "\u5199\u5165\u4e34\u65f6\u6587\u4ef6\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5b58\u50a8\u914d\u7f6e\uff01");
            throw new RuntimeException(e);
        }
        String relativePath = this.fileRelativeTemplate.generatRelativePath(FORM_DETAILS, "");
        File templateFile = null;
        File errorFile = null;
        try {
            templateFile = this.createLocalExcelFile(templateByte, relativePath);
            errorFile = this.createLocalExcelFile(null, relativePath);
        }
        catch (RuntimeException e) {
            this.errorRecord(entity, 0, "\u521b\u5efa\u9519\u8bef\u8bb0\u5f55\u6587\u4ef6\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5b58\u50a8\u914d\u7f6e\uff01");
            throw new RuntimeException(e);
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(fileByte);
             FileOutputStream os = new FileOutputStream(errorFile);){
            final ExcelExportWrapper excelExportWrapper = ExcelExportWrapperBuilder.build(templateFile);
            ExcelImportWrapper excelImportWrapper = ExcelImportWrapperBuilder.create(is, tmpFile).setDomReader(false).builder();
            excelImportWrapper.readSheet(sheetIndex.intValue(), startRow.intValue(), startColumn.intValue(), endColumn.intValue(), new IRecordInterceptor<Object[]>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                @Transactional(rollbackOn={Exception.class})
                public void handle(Object[] t, int row) {
                    FormDetailsImportBoxEntity status = FormDetailsImportBoxTaskServiceImpl.this.checkImportStatus(entity.getId());
                    if (status.getExecuteResult() != 1) {
                        LOGGER.info(String.format("\u5bfc\u5165\u8fdb\u7a0b\u88ab\u6682\u505c\uff0c\u5bfc\u5165ID\uff1a%s", entity.getId()));
                        throw new IllegalArgumentException(String.format("\u5bfc\u5165\u8fdb\u7a0b\u88ab\u6682\u505c\uff0c\u5bfc\u5165ID\uff1a%s", entity.getId()));
                    }
                    try {
                        Object o = null;
                        Object bean = null;
                        o = excelBean != null ? ExcelUtils.setValue(excelBean, t) : ExcelUtils.setValue(t);
                        bean = process.process(o, params, entity.getTemplateCode(), entity.getTemplateVersion());
                        Validate.notNull(bean, (String)"\u672c\u6b21\u5bfc\u5165\u64cd\u4f5c\u672a\u8fd4\u56de\u4efb\u4f55\u6570\uff0c\u8bf7\u68c0\u67e5\u4e1a\u52a1\u6570\u636e\u5bfc\u5165\u524d\u7684\u6821\u9a8c\u903b\u8f91!!", (Object[])new Object[0]);
                        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{entity.getTemplateCode()})) {
                            Validate.notNull((Object)FormDetailsImportBoxTaskServiceImpl.this.formDetailesImportBoxExtService, (String)"\u8bf7\u5bfc\u5165\u8868\u5355\u5f15\u64ce\u5f15\u7528\u540e\uff0c\u8fdb\u884c\u72b6\u6001\u8868\u5355\u76f8\u5173\u64cd\u4f5c!", (Object[])new Object[0]);
                            FormDetailsImportBoxTaskServiceImpl.this.formDetailesImportBoxExtService.fillFormInstanceId(entity, bean, account);
                        }
                        process.execute(bean, params);
                        successNum.getAndIncrement();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                        FormDetailsImportBoxTaskServiceImpl.this.errorRecord(entity, row, e.getMessage());
                        throw new IllegalArgumentException("ExcelBean\u9ed8\u8ba4\u6784\u9020\u51fd\u6570\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01", e);
                    }
                    catch (ExcelMigrateException | HibernateException | DataAccessException e) {
                        LOGGER.info(e.getMessage(), e);
                        FormDetailsImportBoxTaskServiceImpl.this.errorRecord(entity, row, e.getMessage());
                        Object[] v = ArrayUtils.add((Object[])t, (Object)e.getMessage());
                        excelExportWrapper.paint(0, failedNum.getAndIncrement() + startRow.intValue(), startColumn.intValue(), v);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                        FormDetailsImportBoxTaskServiceImpl.this.errorRecord(entity, row, e.getMessage());
                        Object[] v = ArrayUtils.add((Object[])t, (Object)e.getMessage());
                        excelExportWrapper.paint(0, failedNum.getAndIncrement() + startRow.intValue(), startColumn.intValue(), v);
                    }
                    finally {
                        LOGGER.info("\u5b8c\u6210\u5355\u6761\u8bb0\u5f55\u5904\u7406\u5b8c\u6210");
                        totalNum.getAndIncrement();
                    }
                }
            });
            excelExportWrapper.export(os);
        }
        catch (FileNotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u5bfc\u5165\u6587\u4ef6\u8def\u5f84\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u5bfc\u5165\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            org.apache.commons.io.FileUtils.deleteQuietly((File)tmpFile);
            this.complateRecord(entity, successNum.intValue(), failedNum.intValue(), totalNum.intValue(), errorFile.getName(), relativePath);
        }
        try {
            this.venusFileService.saveFile(relativePath, errorFile.getName(), errorFile.getName(), org.apache.commons.io.FileUtils.readFileToByteArray((File)errorFile));
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u5bfc\u51fa\u9519\u8bef\u6587\u4ef6");
        }
        LOGGER.info("\u5bfc\u5165\u5de5\u4f5c\u5b8c\u6210");
    }

    @Override
    @Async(value="fromDetailsMigrateExecutor")
    public void checkProcess(final FormDetailsImportBoxEntity entity, final FormDetailsImportBoxProcess<Object, Object> process, String account, final Map<String, Object> params) {
        byte[] fileByte;
        LOGGER.debug("\u5f02\u6b65excel\u6821\u9a8c");
        final Class<?> excelBean = this.getInterfaceGeneric(process, 1, FormDetailsImportBoxProcess.class);
        NebulaExcelImport nebulaExcelImport = null;
        if (excelBean != null) {
            nebulaExcelImport = excelBean.getAnnotation(NebulaExcelImport.class);
        }
        Validate.notNull((Object)nebulaExcelImport, (String)"excelProperty bean\u672a\u6dfb\u52a0NebulaExcelImport\u6ce8\u89e3,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        AtomicInteger startRow = new AtomicInteger(nebulaExcelImport.startRow());
        AtomicInteger startColumn = new AtomicInteger(nebulaExcelImport.startColumn());
        AtomicInteger endColumn = new AtomicInteger(nebulaExcelImport.endColumn());
        AtomicInteger sheetIndex = new AtomicInteger(nebulaExcelImport.sheetIndex());
        if (endColumn.intValue() <= startColumn.intValue()) {
            endColumn = new AtomicInteger(excelBean.getDeclaredFields().length);
        }
        Validate.isTrue(((fileByte = this.venusFileService.readFileContent(entity.getRelativeLocal(), entity.getFileName())) != null && fileByte.length > 0 ? 1 : 0) != 0, (String)"\u5bfc\u5165\u6587\u4ef6\u4e3a\u7a7a", (Object[])new Object[0]);
        try (ByteArrayInputStream is = new ByteArrayInputStream(fileByte);){
            File tmpFile = FileUtils.writeLocalFile((byte[])fileByte, (String)this.fileRoot, (String)ExcelTypeEnum.XLSX.getValue());
            ExcelImportWrapper excelImportWrapper = ExcelImportWrapperBuilder.create(is, tmpFile).setDomReader(false).builder();
            excelImportWrapper.readSheet(sheetIndex.intValue(), startRow.intValue(), startColumn.intValue(), endColumn.intValue(), new IRecordInterceptor<Object[]>(){

                @Override
                @Transactional(rollbackOn={Exception.class})
                public void handle(Object[] t, int row) {
                    FormDetailsImportBoxEntity status = FormDetailsImportBoxTaskServiceImpl.this.checkImportStatus(entity.getId());
                    Validate.isTrue((status.getExecuteResult() != 0 && status.getExecuteResult() != 2 && status.getExecuteResult() != 3 ? 1 : 0) != 0, (String)String.format("\u5bfc\u5165\u8fdb\u7a0b\u88ab\u6682\u505c\uff0c\u5bfc\u5165ID\uff1a%s", entity.getId()), (Object[])new Object[0]);
                    try {
                        Object o = excelBean != null ? ExcelUtils.setValue(excelBean, t) : ExcelUtils.setValue(t);
                        process.process(o, params, entity.getTemplateCode(), entity.getTemplateVersion());
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        FormDetailsImportBoxTaskServiceImpl.this.faild(entity);
                        LOGGER.error(e.getMessage(), (Throwable)e);
                        throw new IllegalArgumentException("ExcelBean\u9ed8\u8ba4\u6784\u9020\u51fd\u6570\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01", e);
                    }
                    catch (ExcelMigrateException | HibernateException | DataAccessException e) {
                        FormDetailsImportBoxTaskServiceImpl.this.faild(entity);
                        LOGGER.info(e.getMessage(), e);
                        throw new IllegalArgumentException("\u5bfc\u5165\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", e);
                    }
                    catch (Exception e) {
                        FormDetailsImportBoxTaskServiceImpl.this.faild(entity);
                        LOGGER.error(e.getMessage(), (Throwable)e);
                        throw new IllegalArgumentException("\u5bfc\u5165\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", e);
                    }
                }
            });
        }
        catch (FileNotFoundException e) {
            this.faild(entity);
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u5bfc\u5165\u6587\u4ef6\u8def\u5f84\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            this.faild(entity);
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u5bfc\u5165\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25");
        }
        catch (Exception e) {
            this.faild(entity);
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        this.complateCheck(entity);
        LOGGER.info("\u5bfc\u5165\u6821\u9a8c\u5de5\u4f5c\u5b8c\u6210");
    }

    @Override
    @Async(value="fromDetailsMigrateExecutor")
    public void asyncImport(FormDetailsImportBoxEntity entity, FormDetailsImportBoxProcess<Object, Object> process, String account, Map<String, Object> params) {
        params.put("id", entity.getId());
        process.importExt(params, entity.getTemplateCode(), entity.getTemplateVersion());
    }

    private File createLocalExcelFile(byte[] bytes, String relativePath) {
        String renameImage = UUID.randomUUID().toString();
        String fileRename = StringUtils.join((Object[])new String[]{renameImage, ".", "xlsx"});
        File folder = new File(StringUtils.join((Object[])new String[]{this.fileRoot, relativePath}));
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File file = new File(folder, fileRename);
        try {
            Validate.isTrue((boolean)file.createNewFile(), (String)"\u521b\u5efa\u672c\u5730\u6587\u4ef6\u5931\u8d25\uff1a%s", (Object[])new Object[]{file.getAbsolutePath()});
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("\u521b\u5efa\u672c\u5730\u6587\u4ef6\u5931\u8d25\uff1a%s", e.getMessage()));
        }
        if (bytes != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            try (FileOutputStream fos = new FileOutputStream(file);){
                int realLen;
                int maxLen = 4096;
                byte[] contents = new byte[maxLen];
                while ((realLen = bais.read(contents, 0, maxLen)) != -1) {
                    fos.write(contents, 0, realLen);
                }
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u672c\u5730\u6587\u4ef6\uff1a%s", file.getAbsolutePath()));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("\u8bfb\u53d6\u672c\u5730\u6587\u4ef6\u5931\u8d25\uff1a%s", e.getMessage()));
            }
        }
        return file;
    }

    @Transactional(rollbackOn={Exception.class})
    FormDetailsImportBoxDetailsEntity errorRecord(FormDetailsImportBoxEntity entity, int row, String message) {
        Validate.notNull((Object)((Object)entity), (String)"\u5bfc\u5165\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        FormDetailsImportBoxDetailsEntity detailsEntity = new FormDetailsImportBoxDetailsEntity();
        detailsEntity.setFormDetailsImportBoxEntity(entity);
        detailsEntity.setRowNum(row);
        detailsEntity.setErrorMsg(message);
        detailsEntity.setProjectName(this.platformContext.getAppName());
        detailsEntity = (FormDetailsImportBoxDetailsEntity)((Object)this.formDetailsImportBoxDetailsRepository.saveAndFlush((Object)detailsEntity));
        return detailsEntity;
    }

    @Transactional(rollbackOn={Exception.class})
    FormDetailsImportBoxEntity complateRecord(FormDetailsImportBoxEntity entity, int successNum, int failedNum, int totalNum, String errorFileName, String errorFileRelativeLocal) {
        Validate.notNull((Object)((Object)entity), (String)"\u5bfc\u5165\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        entity.setExecuteEndTime(new Date());
        entity.setSuccessNum(successNum);
        if (successNum + failedNum != totalNum) {
            failedNum = totalNum - successNum;
        }
        entity.setFailedNum(failedNum);
        entity.setTotalNum(totalNum);
        entity.setErrorFileName(errorFileName);
        entity.setErrorFileRelativeLocal(errorFileRelativeLocal);
        entity.setProjectName(this.platformContext.getAppName());
        if (failedNum == 0) {
            entity.setExecuteResult(2);
        } else {
            entity.setExecuteResult(0);
        }
        entity.setProjectName(this.platformContext.getAppName());
        entity = (FormDetailsImportBoxEntity)((Object)this.formDetailsImportBoxRepository.saveAndFlush((Object)entity));
        return entity;
    }

    @Transactional(rollbackOn={Exception.class})
    FormDetailsImportBoxEntity complateCheck(FormDetailsImportBoxEntity entity) {
        Validate.notNull((Object)((Object)entity), (String)"\u5bfc\u5165\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        entity.setExecuteEndTime(new Date());
        entity.setProjectName(this.platformContext.getAppName());
        entity.setExecuteResult(5);
        entity = (FormDetailsImportBoxEntity)((Object)this.formDetailsImportBoxRepository.saveAndFlush((Object)entity));
        return entity;
    }

    @Transactional(rollbackOn={Exception.class})
    FormDetailsImportBoxEntity faild(FormDetailsImportBoxEntity entity) {
        Validate.notNull((Object)((Object)entity), (String)"\u5bfc\u5165\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        entity.setExecuteEndTime(new Date());
        entity.setProjectName(this.platformContext.getAppName());
        entity.setExecuteResult(0);
        entity = (FormDetailsImportBoxEntity)((Object)this.formDetailsImportBoxRepository.saveAndFlush((Object)entity));
        return entity;
    }

    private FormDetailsImportBoxEntity checkImportStatus(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u5bfc\u5165\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Optional op = this.formDetailsImportBoxRepository.findById(id);
        FormDetailsImportBoxEntity entity = op.orElse(null);
        Validate.notNull((Object)((Object)entity), (String)"\u5bfc\u5165\u6570\u636e\u8bb0\u5f55\u9519\u8bef", (Object[])new Object[0]);
        return entity;
    }

    private Class<?> getInterfaceGeneric(Object obj, Integer index, Class<?> interfaceClass) {
        Class<?> clazz = null;
        clazz = AopUtils.isCglibProxy((Object)obj) || AopUtils.isAopProxy((Object)obj) ? AopUtils.getTargetClass((Object)obj) : obj.getClass();
        AnnotatedType[] annotatedTypes = clazz.getAnnotatedInterfaces();
        if (annotatedTypes == null) {
            return null;
        }
        for (AnnotatedType annotatedType : annotatedTypes) {
            Type[] params;
            Type type = annotatedType.getType();
            if (!(type instanceof ParameterizedType) || !interfaceClass.getName().equals(((ParameterizedType)type).getRawType().getTypeName()) || (params = ((ParameterizedType)type).getActualTypeArguments()) == null || params.length < index) continue;
            try {
                Class cc = (Class)params[index];
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                return Class.forName(cc.getName(), false, classLoader);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error(e.getMessage());
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }
}

