package com.bizunited.platform.kuiper.entity;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

import org.hibernate.annotations.GenericGenerator;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

/**
 * 各种实体层对象的定义中，只要属于静态表单模板的主业务模型，都要集成该类<br>
 * 这个父类中将会有一个formInstanceId字段，这个字段的值将在创建业务表单实例时，将会有表单引擎进行生成和绑定
 * @author yinwenjie
 */
@MappedSuperclass
public abstract class FormInstanceUuidEntity implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 6357586662390821565L;
  /**
   * 抽象实体层模型（MySQL主键）的编号信息.
   */
  @Id
  @GeneratedValue(generator = "uuid")
  @GenericGenerator(name = "uuid", strategy = "org.hibernate.id.UUIDGenerator")
  private String id;
  
  /**
   * 业务表数据对应的表单实例编号
   */
  @Column(name="form_instance_id" , nullable=false , unique=true , updatable=false, columnDefinition = "varchar(255) COMMENT '业务表数据对应的表单实例编号'")
  @SaturnColumn(description="表单实例编号" , updatable=false)
  private String formInstanceId;

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getFormInstanceId() {
    return formInstanceId;
  }

  public void setFormInstanceId(String formInstanceId) {
    this.formInstanceId = formInstanceId;
  }
}