package com.bizunited.platform.kuiper.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 该功能模型用于记录，基于列表模板的批量业务数据导入功能的导入模板信息的记录
 * @author yinwenjie
 */
@Entity
@Table(name = "engine_form_details_import" , indexes = {@Index(columnList = "list_templete_code,list_templete_version,button_code" , unique = true) })
@ApiModel(value = "FrontFileEntity", description = "该功能模型用于记录，基于列表模板的批量业务数据导入功能的导入模板信息的记录")
@org.hibernate.annotations.Table(appliesTo = "engine_form_details_import" , comment = "该功能模型用于记录，基于列表模板的批量业务数据导入功能的导入模板信息的记录")
public class FromDetailsImportEntity  extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 5528343382503551946L;

  /**
   * 列表模板的业务编号信息
   */
  @ApiModelProperty(name="listTempleteCode" , value="列表模板的业务编号信息" , required=true)
  @Column(name="list_templete_code" , length=128 , nullable=true ,columnDefinition = "varchar(128) COMMENT '列表模板的业务编号信息'")
  @SaturnColumn(description="列表模板的业务编号信息")
  private String listTempleteCode;
  
  /**
   * 列表模板的版本信息
   */
  @ApiModelProperty(name="listTempleteVersion" , value="列表模板的版本信息" , required=true)
  @Column(name="list_templete_version" , length=128 , nullable=true ,columnDefinition = "varchar(128) COMMENT '列表模板的版本信息'")
  @SaturnColumn(description="列表模板的版本信息")
  private String listTempleteVersion;
  
  /**
   * 用于记录这个列表模板上用于进行业务数据导入的功能按钮code
   * 以便能够保证一个列表模板上可以有不同的业务数据批量导入逻辑
   */
  @ApiModelProperty(name="buttonCode" , value="功能按钮code" , required=true)
  @Column(name="button_code" , length=128 , nullable=true ,columnDefinition = "varchar(128) COMMENT '功能按钮code'")
  @SaturnColumn(description="列表模板的版本信息")
  private String buttonCode;
  
  /**
   * 记录当前xls、xlsx模板文件的文件名（重命名的）
   */
  @ApiModelProperty(name="fileName" , value="记录当前xls、xlsx模板文件的文件名（重命名的）" , required=true)
  @Column(name="file_name" , length=128 , nullable=true ,columnDefinition = "varchar(128) COMMENT '记录当前xls、xlsx模板文件的文件名（重命名的）'")
  @SaturnColumn(description="记录当前xls、xlsx模板文件的文件名（重命名的）")
  private String fileName;
  
  /**
   * 记录当前模板文件保存的相对路径信息
   */
  @ApiModelProperty(name="relativePath" , value="记录当前模板文件保存的相对路径信息" , required=true)
  @Column(name="relative_path" , length=128 , nullable=true ,columnDefinition = "varchar(128) COMMENT '记录当前模板文件保存的相对路径信息'")
  @SaturnColumn(description="记录当前模板文件保存的相对路径信息")
  private String relativePath;

  public String getListTempleteCode() {
    return listTempleteCode;
  }

  public void setListTempleteCode(String listTempleteCode) {
    this.listTempleteCode = listTempleteCode;
  }

  public String getListTempleteVersion() {
    return listTempleteVersion;
  }

  public void setListTempleteVersion(String listTempleteVersion) {
    this.listTempleteVersion = listTempleteVersion;
  }

  public String getButtonCode() {
    return buttonCode;
  }

  public void setButtonCode(String buttonCode) {
    this.buttonCode = buttonCode;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getRelativePath() {
    return relativePath;
  }

  public void setRelativePath(String relativePath) {
    this.relativePath = relativePath;
  }
}
