package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

@Entity
@Table(name = "engine_form_front_file")
@ApiModel(value = "FrontFileEntity", description = "前端文件储存")
@org.hibernate.annotations.Table(appliesTo = "engine_form_front_file" , comment = "前端文件储存")
public class FrontFileEntity extends UuidEntity {

  private static final long serialVersionUID = 2219392472658550167L;

  /** 前端文件名称 */
  @Column(name = "name", nullable = false,unique = true, columnDefinition = "varchar(255) COMMENT '前端文件名称'")
  @ApiModelProperty(name = "name", value = "前端文件名称", required = true)
  @SaturnColumn(description = "前端文件名称")
  private String name;

  /** 前端文件分类 */
  @Column(name = "file_classify", nullable = true, columnDefinition = "varchar(255) COMMENT '前端文件分类'")
  @ApiModelProperty(name = "fileClassify", value = "前端文件分类", required = false)
  @SaturnColumn(description = "前端文件分类")
  private String fileClassify;

  /** 前端文件描述 */
  @Column(name = "file_desc", nullable = true, columnDefinition = "varchar(255) COMMENT '前端文件描述'")
  @ApiModelProperty(name = "fileDesc", value = "前端文件描述", required = false)
  @SaturnColumn(description = "前端文件描述")
  private String fileDesc;

  /** 前端文件存储路径 */
  @Column(name = "file_path", nullable = false, columnDefinition = "varchar(255) COMMENT '前端文件存储路径'")
  @ApiModelProperty(name = "filePath", value = "前端文件存储路径", required = false)
  @SaturnColumn(description = "前端文件存储路径")
  private String filePath;

  /** 前端文件存粹文件名 */
  @Column(name = "file_name", nullable = false, columnDefinition = "varchar(255) COMMENT '前端文件存粹文件名'")
  @ApiModelProperty(name = "fileName", value = "前端文件存粹文件名", required = false)
  @SaturnColumn(description = "前端文件存粹文件名")
  private String fileName;

  /** 创建时间 */
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @ApiModelProperty(name = "createTime", value = "创建时间", required = false)
  @SaturnColumn(description = "创建时间")
  private Date createTime;

  /** 文件状态,0启用，1禁用 */
  @Column(name = "file_status", nullable = false, columnDefinition = "int(11) COMMENT '文件状态,0启用，1禁用 '")
  @ApiModelProperty(name = "fileStatus", value = "文件状态,0启用，1禁用", required = false)
  @SaturnColumn(description = "文件状态,0启用，1禁用")
  private Integer fileStatus;

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getFileClassify() {
    return fileClassify;
  }

  public void setFileClassify(String fileClassify) {
    this.fileClassify = fileClassify;
  }

  public String getFilePath() {
    return filePath;
  }

  public void setFilePath(String filePath) {
    this.filePath = filePath;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Integer getFileStatus() {
    return fileStatus;
  }

  public void setFileStatus(Integer fileStatus) {
    this.fileStatus = fileStatus;
  }

  public String getFileDesc() {
    return fileDesc;
  }

  public void setFileDesc(String fileDesc) {
    this.fileDesc = fileDesc;
  }
}
