package com.bizunited.platform.kuiper.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

/**
 * 表单活动中数据变化情况记录
 * @author yinwenjie
 */
@Entity
@Table(name="engine_form_instance_activity_log" , indexes={@Index(columnList="relative_path,file_name" , unique=true)})
@org.hibernate.annotations.Table(appliesTo = "engine_form_instance_activity_log" , comment = "表单活动中数据变化情况记录")
public class InstanceActivityLogEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = -436351271529260338L;
  /**
   * 当前变化日志对应的活动信息
   */
  @ManyToOne(fetch=FetchType.LAZY , targetEntity=InstanceActivityEntity.class)
  @JoinColumn(name="instance_activity_id" , nullable=false, columnDefinition = "varchar(255) COMMENT '当前变化日志对应的活动信息'")
  @SaturnColumn(description="变化日志对应的活动信息")
  private InstanceActivityEntity instanceActivity;
  /**
   * 本次活动变化对应的日志文件存储相对位置（不包括文件名）
   * 日志文件是一个json内容的文件
   */
  @Column(name="relative_path" , nullable=false , length=255, columnDefinition = "varchar(255) COMMENT '日志文件存储相对位置'")
  @SaturnColumn(description="日志文件存储相对位置")
  private String relativePath;
  /**
   * 存储的日志文件文件名（只有文件名）
   */
  @Column(name="file_name" , nullable=false , length=255, columnDefinition = "varchar(255) COMMENT '存储的日志文件文件名（只有文件名）'")
  @SaturnColumn(description="日志文件文件名")
  private String fileName;
  /**
   * 日志创建时间
   */
  @Column(name="create_time" , nullable=false, columnDefinition = "datetime COMMENT '日志创建时间'")
  @SaturnColumn(description="日志创建时间")
  private Date createTime;
  /**
   * 当进行数据复原时，使用哪一个服务定义查询静态表单查询</br>
   * 这个方法只有静态表单使用
   */
  @Column(name="query_details_service" , nullable=true, columnDefinition = "varchar(255) COMMENT '静态表单查询定义'")
  @SaturnColumn(description="静态表单查询定义")
  private String queryDetailsService = "";
  /**
   * 当进行数据复原时，使用哪一个服务定义更新静态表单信息</br>
   * 这个方法只有静态表单使用
   */
  @Column(name="update_details_service" , nullable=true, columnDefinition = "varchar(255) COMMENT '静态表单查询定义'")
  @SaturnColumn(description="静态表单查询定义")
  private String updateDetailsService = "";
  /**
   * 本次数据变动的创建者
   */
  @ManyToOne(fetch=FetchType.LAZY , targetEntity=UserEntity.class)
  @JoinColumn(name="creator_id" , nullable=false, columnDefinition = "varchar(255) COMMENT '本次数据变动的创建者'")
  @SaturnColumn(description="数据变动的创建者")
  private UserEntity creator;
  public InstanceActivityEntity getInstanceActivity() {
    return instanceActivity;
  }
  public void setInstanceActivity(InstanceActivityEntity instanceActivity) {
    this.instanceActivity = instanceActivity;
  }
  public String getRelativePath() {
    return relativePath;
  }
  public void setRelativePath(String relativePath) {
    this.relativePath = relativePath;
  }
  public Date getCreateTime() {
    return createTime;
  }
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
  public UserEntity getCreator() {
    return creator;
  }
  public void setCreator(UserEntity creator) {
    this.creator = creator;
  }
  public String getFileName() {
    return fileName;
  }
  public void setFileName(String fileName) {
    this.fileName = fileName;
  }
  public String getQueryDetailsService() {
    return queryDetailsService;
  }
  public void setQueryDetailsService(String queryDetailsService) {
    this.queryDetailsService = queryDetailsService;
  }
  public String getUpdateDetailsService() {
    return updateDetailsService;
  }
  public void setUpdateDetailsService(String updateDetailsService) {
    this.updateDetailsService = updateDetailsService;
  }
}
