package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;

import java.util.Date;

/**
 * @Author: Paul Chan
 * @Date: 2019-04-19 11:19
 * @Description: 表单实例上下文
 */
@ApiModel("表单实例上下文")
@Entity
@Table(name="engine_form_instance_context")
@org.hibernate.annotations.Table(appliesTo = "engine_form_instance_context" , comment = "表单实例上下文")
public class InstanceContextEntity extends UuidEntity {

  private static final long serialVersionUID = -485715287689465182L;
  /**
   * 对应的表单实例
   */
  @OneToOne(fetch= FetchType.LAZY , targetEntity = InstanceEntity.class)
  @JoinColumn(name="instance", columnDefinition = "varchar(255) COMMENT '对应的表单实例'")
  @SaturnColumn(description="表单实例")
  private InstanceEntity instance;
  /**
   * 属性名
   */
  @ApiModelProperty(name="name" , value="属性名", required = true)
  @Column(name="name", nullable=false, columnDefinition = "varchar(255) COMMENT '属性名'")
  @SaturnColumn(description="属性名")
  private String name;
  /**
   * 属性值
   */
  @ApiModelProperty(name="value" , value="属性值", required = true)
  @Column(name="value" , length=2000 , nullable=false, columnDefinition = "varchar(2000) COMMENT '属性值'")
  @SaturnColumn(description="属性值")
  private String value;
  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", value = "数据表的创建时间", hidden = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '数据表的创建时间'")
  @SaturnColumn(description = "数据表的创建时间")
  private Date createTime;
  /**
   * 最后修改时间
   */
  @ApiModelProperty(name = "modifyTime", value = "数据表的最后修改时间", hidden = true)
  @Column(name = "modify_time", nullable = false, columnDefinition = "datetime COMMENT '数据表的最后修改时间'")
  @SaturnColumn(description = "数据表的最后修改时间")
  private Date modifyTime;

  public InstanceEntity getInstance() {
    return instance;
  }

  public void setInstance(InstanceEntity instance) {
    this.instance = instance;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }
  public String getValue() {
    return value;
  }
  public void setValue(String value) {
    this.value = value;
  }
  public Date getModifyTime() {
    return modifyTime;
  }
  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }
}
