package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import java.util.Date;

/**
 * 表单引擎列表模板描述
 * @author yinwenjie
 */
@ApiModel(value = "ListTemplateEntity" , description="表单引擎模板的数据层描述")
@Entity
@Table(name="engine_form_list_template" , indexes={@Index(columnList="code,cversion" , unique=true)})
@org.hibernate.annotations.Table(appliesTo = "engine_form_list_template" , comment = "表单引擎模板的数据层描述")
public class ListTemplateEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 5629867216029321078L;
  /**
   * 列表模板的唯一编号
   */
  @ApiModelProperty(name="code" , value="列表模板的唯一编号" , required=true)
  @Column(name="code" , length=128 , nullable=false, columnDefinition = "varchar(128) COMMENT '列表模板的唯一编号'")
  @SaturnColumn(description="列表模板的唯一编号")
  private String code = "";

  /**
   * 当前表单模板版本是否是当前表单模板的默认版本
   */
  @ApiModelProperty(name="defaultVersion" , value="当前表单模板版本是否是当前表单模板的默认版本" , required=true)
  @Column(name="default_version" , nullable=false, columnDefinition = "bit(1) COMMENT '当前表单模板版本是否是当前表单模板的默认版本'")
  @SaturnColumn(description="是否是当前表单模板的默认版本")
  private Boolean defaultVersion = false;

  /**
   * 项目名不填写也行，毕竟目前来看只可能是一个项目
   */
  @ApiModelProperty(name="porjectName" , value="项目名不填写也行，毕竟目前来看只可能是一个项目" , required=false)
  @Column(name="porject_name" , length=128 , nullable=true, columnDefinition = "varchar(128) COMMENT '项目名不填写也行，毕竟目前来看只可能是一个项目'")
  @SaturnColumn(description="项目名")
  private String porjectName;
  /**
   * 列表模板编号有不同的版本信息，同一编码下的版本信息是唯一的
   */
  @ApiModelProperty(name="cversion" , value="列表模板编号有不同的版本信息，同一编码下的版本信息是唯一的" , required=true)
  @Column(name="cversion" , length=64 , nullable=false, columnDefinition = "varchar(64) COMMENT '列表模板编号有不同的版本信息，同一编码下的版本信息是唯一的'")
  @SaturnColumn(description="不同的版本信息")
  private String cversion;
  /**
   * 列表模板的中文说明
   */
  @ApiModelProperty(name="name" , value="列表模板的中文说明" , required=true)
  @Column(name="name" , length=128 , nullable=false, columnDefinition = "varchar(128) COMMENT '列表模板的中文说明'")
  @SaturnColumn(description="列表模板的中文说明")
  private String name;
  /**
   * 创建者信息
   */
  @ApiModelProperty(name="creator" , value="创建者信息" , required=true)
  @ManyToOne(fetch=FetchType.LAZY , targetEntity = UserEntity.class)
  @JoinColumn(name="creator" , nullable=false, columnDefinition = "varchar(255) COMMENT '创建者信息'")
  @SaturnColumn(description="创建人")
  private UserEntity creator;
  /**
   * 列表模板状态，1：正常；0或者其它值：作废
   */
  @ApiModelProperty(name="tstatus" , value="列表模板状态，1：正常；0或者其它值：作废" , required=true)
  @Column(name="t_status" , nullable=false, columnDefinition = "int(11) COMMENT '列表模板状态，1：正常；0或者其它值：作废'")
  @SaturnColumn(description="列表模板状态")
  private Integer tstatus = 1;
  /**
   * 数据源类型：1、服务源；2、数据视图。默认为2
   */
  @ApiModelProperty(name="datesource" , value="数据源类型：1、服务源；2、数据视图。默认为2" , required=true)
  @Column(name="date_source" , nullable=false, columnDefinition = "int(11) COMMENT '数据源类型：1、服务源；2、数据视图。默认为2'")
  @SaturnColumn(description="数据源类型：1、服务源；2、数据视图")
  private Integer datesource = 2;
  /**
   * 列表模板文件的相对目录
   */
  @ApiModelProperty(name="relativePath" , value="列表模板文件的相对目录" , required=true)
  @Column(name="relative_path" , nullable=true, columnDefinition = "varchar(255) COMMENT '列表模板文件的相对目录'")
  @SaturnColumn(description="列表模板文件的相对目录")
  private String relativePath;
  /**
   * 保存的列表模板布局文件文件名
   */
  @ApiModelProperty(name="fileName" , value="保存的列表模板布局文件文件名" , required=true)
  @Column(name="file_Name" ,  nullable=true, columnDefinition = "varchar(255) COMMENT '保存的列表模板布局文件文件名'")
  @SaturnColumn(description="保存的列表模板布局文件文件名")
  private String fileName;
  /**
   * 列表模板的创建时间/升级时间
   */
  @ApiModelProperty(name="createTime" , value="创建时间/升级时间" , required=true)
  @Column(name="create_time" , nullable=false, columnDefinition = "datetime COMMENT '列表模板的创建时间/升级时间'")
  @SaturnColumn(description="创建时间/升级时间")
  private Date createTime;

  /**
   * 列表模板的修改时间
   */
  @ApiModelProperty(name="modifyTime" , value="修改时间" , required=true)
  @Column(name="modify_time" , nullable = false, columnDefinition = "datetime COMMENT '列表模板的修改时间'")
  @SaturnColumn(description="修改时间")
  private Date modifyTime;

  public Date getModifyTime() {
    return modifyTime;
  }

  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }
  public String getCode() {
    return code;
  }
  public void setCode(String code) {
    this.code = code;
  }
  public String getPorjectName() {
    return porjectName;
  }
  public void setPorjectName(String porjectName) {
    this.porjectName = porjectName;
  }
  public String getCversion() {
    return cversion;
  }
  public void setCversion(String cversion) {
    this.cversion = cversion;
  }
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }
  public UserEntity getCreator() {
    return creator;
  }
  public void setCreator(UserEntity creator) {
    this.creator = creator;
  }
  public Integer getTstatus() {
    return tstatus;
  }
  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }
  public Integer getDatesource() {
    return datesource;
  }
  public void setDatesource(Integer datesource) {
    this.datesource = datesource;
  }
  public String getRelativePath() {
    return relativePath;
  }
  public void setRelativePath(String relativePath) {
    this.relativePath = relativePath;
  }
  public String getFileName() {
    return fileName;
  }
  public void setFileName(String fileName) {
    this.fileName = fileName;
  }
  public Date getCreateTime() {
    return createTime;
  }
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
  public Boolean getDefaultVersion() {
    return defaultVersion;
  }
  public void setDefaultVersion(Boolean defaultVersion) {
    this.defaultVersion = defaultVersion;
  }
}