package com.bizunited.platform.kuiper.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

/**
 * 表单模板布局信息
 * @author yinwenjie
 */
@Entity
@Table(name="engine_form_layout" , indexes = {@Index(columnList = "template_id , layout_type" , unique = true)})
@org.hibernate.annotations.Table(appliesTo = "engine_form_layout" , comment = "表单模板布局信息")
public class TemplateLayoutEntity extends UuidEntity {
  /**
   *
   */
  private static final long serialVersionUID = 3411328676750954728L;
  /**
   * 布局信息对应的表单模板
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="template_id" , nullable=false, columnDefinition = "varchar(255) COMMENT '布局信息对应的表单模板'")
  @SaturnColumn(description="布局信息对应的表单模板")
  private TemplateEntity template;
  /**
   * 后端用于存储表单模板布局信息序列化以后的文档的目录
   */
  @Column(name="relative_path" , nullable=false, columnDefinition = "varchar(255) COMMENT '后端用于存储表单模板布局信息序列化以后的文档的目录'")
  @SaturnColumn(description="文档的相对目录")
  private String relativePath;
  /**
   * 布局类型
   * 1.PC端
   * 2.mobile端
   * 3.print端
   */
  @Column(name="layout_type" , nullable=false, columnDefinition = "int(11) COMMENT '布局类型：1.PC端 2.mobile端 3.print端'")
  @SaturnColumn(description="布局类型")
  private Integer layoutType;
  /**
   * 保存的布局文件文件名(包括后缀)
   */
  @Column(name="file_Name" , nullable=false, columnDefinition = "varchar(255) COMMENT '保存的布局文件文件名(包括后缀)'")
  @SaturnColumn(description="保存的布局文件文件名")
  private String fileName;
  /**
   * 创建时间
   */
  @Column(name="create_time" , nullable=false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description="创建时间")
  private Date createTime;
  public TemplateEntity getTemplate() {
    return template;
  }
  public void setTemplate(TemplateEntity template) {
    this.template = template;
  }
  public String getRelativePath() {
    return relativePath;
  }
  public void setRelativePath(String relativePath) {
    this.relativePath = relativePath;
  }
  public String getFileName() {
    return fileName;
  }
  public void setFileName(String fileName) {
    this.fileName = fileName;
  }
  public Date getCreateTime() {
    return createTime;
  }
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
  public Integer getLayoutType() {
    return layoutType;
  }
  public void setLayoutType(Integer layoutType) {
    this.layoutType = layoutType;
  }
}
