package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;
import java.util.Date;
import java.util.Set;

/**
 * TemplateMigrateImportAnalysisEntity
 *
 * @description:
 * @author: yanwe
 * @date: 23/Sep/2019 15:34
 */
@ApiModel(value = "MigrateTemplateAnalysisEntity", description = "表单信息迁移预分析结果")
@Entity
@Table(name = "engine_form_template_migrate_analysis")
public class TemplateMigrateImportAnalysisEntity extends UuidEntity {

  private static final long serialVersionUID = 8143895941089689838L;

  /** 关联的上级迁移任务上传记录 */
  @ApiModelProperty(name = "templateMigrateImportEntity", value = "关联的迁移任务上传记录")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "migrate_import_entity_id", columnDefinition = "varchar(255) COMMENT '关联的迁移任务上传记录'")
  @SaturnColumn(description = "关联的迁移任务上传记录")
  private TemplateMigrateImportEntity templateMigrateImportEntity;

  /** 关联下级分析明细 */
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "analysisEntity")
  @SaturnColumn(description = "关联下级分析明细")
  private Set<TemplateMigrateImportAnalysisItemEntity> analysisItemEntities;

  /** 分析执行人 */
  @ApiModelProperty(name = "executor", value = "分析执行人")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "executor", columnDefinition = "varchar(255) COMMENT '分析执行人'")
  @SaturnColumn(description = "分析执行人")
  private UserEntity executor;

  /** 分析时间 */
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '分析时间'")
  @ApiModelProperty(name = "createTime", value = "分析时间", required = true)
  @SaturnColumn(description = "分析时间")
  private Date createTime = new Date();

  /** 表单模板总数 */
  @Column(name = "template_total_num", nullable = false, columnDefinition = "int(11) COMMENT '表单模板总数'")
  @SaturnColumn(description = "表单模板总数")
  @ApiModelProperty(name = "listErrorNum", value = "表单模板总数", required = true)
  private Integer templateTotalNum = 0;

  /** 表单模板新增数量 */
  @Column(name = "template_create_num", nullable = false, columnDefinition = "int(11) COMMENT '表单模板新增数量'")
  @SaturnColumn(description = "表单模板新增数量")
  @ApiModelProperty(name = "listErrorNum", value = "表单模板新增数量", required = true)
  private Integer templateCreateNum = 0;

  /** 表单模板更新数量 */
  @Column(name = "template_update_num", nullable = false, columnDefinition = "int(11) COMMENT '表单模板更新数量'")
  @SaturnColumn(description = "表单模板更新数量")
  @ApiModelProperty(name = "listErrorNum", value = "表单模板更新数量", required = true)
  private Integer templateUpdateNum = 0;

  /** 表单模板失败数量 */
  @Column(name = "template_error_num", nullable = false, columnDefinition = "int(11) COMMENT '表单模板失败数量'")
  @SaturnColumn(description = "表单模板失败数量")
  @ApiModelProperty(name = "listErrorNum", value = "表单模板失败数量", required = true)
  private Integer templateErrorNum = 0;

  /** 列表模板总数 */
  @Column(name = "list_total_num", nullable = false, columnDefinition = "int(11) COMMENT '列表模板总数'")
  @SaturnColumn(description = "列表模板总数")
  @ApiModelProperty(name = "listErrorNum", value = "列表模板总数", required = true)
  private Integer listTotalNum = 0;

  /** 列表模板新增数量 */
  @Column(name = "list_create_num", nullable = false, columnDefinition = "int(11) COMMENT '列表模板新增数量'")
  @SaturnColumn(description = "列表模板新增数量")
  @ApiModelProperty(name = "listErrorNum", value = "列表模板新增数量", required = true)
  private Integer listCreateNum = 0;

  /** 列表模板更新数量 */
  @Column(name = "list_update_num", nullable = false, columnDefinition = "int(11) COMMENT '列表模板更新数量'")
  @SaturnColumn(description = "列表模板更新数量")
  @ApiModelProperty(name = "listErrorNum", value = "列表模板更新数量", required = true)
  private Integer listUpdateNum = 0;

  /** 列表模板失败数量 */
  @Column(name = "list_error_num", nullable = false, columnDefinition = "int(11) COMMENT '列表模板失败数量'")
  @SaturnColumn(description = "列表模板失败数量")
  @ApiModelProperty(name = "listErrorNum", value = "列表模板失败数量", required = true)
  private Integer listErrorNum = 0;

  /** 前端函数新增数量 */
  @Column(name = "front_file_create_num", nullable = false, columnDefinition = "int(11) COMMENT '前端函数新增数量'")
  @SaturnColumn(description = "前端函数新增数量")
  @ApiModelProperty(name = "frontFileCreateNum", value = "前端函数新增数量", required = true)
  private Integer frontFileCreateNum = 0;

  /** 前端函数失败数量 */
  @Column(name = "front_file_error_num", nullable = false, columnDefinition = "int(11) COMMENT '前端函数失败数量'")
  @SaturnColumn(description = "前端函数失败数量")
  @ApiModelProperty(name = "frontFileErrorNum", value = "前端函数失败数量", required = true)
  private Integer frontFileErrorNum = 0;

  public TemplateMigrateImportEntity getTemplateMigrateImportEntity() {
    return templateMigrateImportEntity;
  }

  public void setTemplateMigrateImportEntity(TemplateMigrateImportEntity templateMigrateImportEntity) {
    this.templateMigrateImportEntity = templateMigrateImportEntity;
  }

  public Set<TemplateMigrateImportAnalysisItemEntity> getAnalysisItemEntities() {
    return analysisItemEntities;
  }

  public void setAnalysisItemEntities(Set<TemplateMigrateImportAnalysisItemEntity> analysisItemEntities) {
    this.analysisItemEntities = analysisItemEntities;
  }

  public UserEntity getExecutor() {
    return executor;
  }

  public void setExecutor(UserEntity executor) {
    this.executor = executor;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Integer getTemplateTotalNum() {
    return templateTotalNum;
  }

  public void setTemplateTotalNum(Integer templateTotalNum) {
    this.templateTotalNum = templateTotalNum;
  }

  public Integer getTemplateCreateNum() {
    return templateCreateNum;
  }

  public void setTemplateCreateNum(Integer templateCreateNum) {
    this.templateCreateNum = templateCreateNum;
  }

  public Integer getTemplateUpdateNum() {
    return templateUpdateNum;
  }

  public void setTemplateUpdateNum(Integer templateUpdateNum) {
    this.templateUpdateNum = templateUpdateNum;
  }

  public Integer getTemplateErrorNum() {
    return templateErrorNum;
  }

  public void setTemplateErrorNum(Integer templateErrorNum) {
    this.templateErrorNum = templateErrorNum;
  }

  public Integer getListTotalNum() {
    return listTotalNum;
  }

  public void setListTotalNum(Integer listTotalNum) {
    this.listTotalNum = listTotalNum;
  }

  public Integer getListCreateNum() {
    return listCreateNum;
  }

  public void setListCreateNum(Integer listCreateNum) {
    this.listCreateNum = listCreateNum;
  }

  public Integer getListUpdateNum() {
    return listUpdateNum;
  }

  public void setListUpdateNum(Integer listUpdateNum) {
    this.listUpdateNum = listUpdateNum;
  }

  public Integer getListErrorNum() {
    return listErrorNum;
  }

  public void setListErrorNum(Integer listErrorNum) {
    this.listErrorNum = listErrorNum;
  }

  public Integer getFrontFileCreateNum() {
    return frontFileCreateNum;
  }

  public void setFrontFileCreateNum(Integer frontFileCreateNum) {
    this.frontFileCreateNum = frontFileCreateNum;
  }

  public Integer getFrontFileErrorNum() {
    return frontFileErrorNum;
  }

  public void setFrontFileErrorNum(Integer frontFileErrorNum) {
    this.frontFileErrorNum = frontFileErrorNum;
  }
}
