package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;

/**
 * TemplateMigrateImportAnalysisItemEntity
 *
 * @description: 表单数据迁移任务预分析结果明细（每个模板分析结果）
 * @author: yanwe
 * @date: 23/Sep/2019 15:45
 */
@ApiModel(
    value = "TemplateMigrateImportAnalysisItemEntity",
    description = "表单数据迁移任务预分析结果明细（每个模板分析结果）")
@Entity
@Table(name = "engine_form_template_import_analysis_item")
public class TemplateMigrateImportAnalysisItemEntity extends UuidEntity {
  private static final long serialVersionUID = 240560919859110078L;

  /** 关联的迁移任务分析结果 */
  @ApiModelProperty(name = "templateMigrateImportAnalysisEntity", value = "关联的迁移任务分析结果")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "template_import_migrate_analysis_id", columnDefinition = "varchar(255) COMMENT '关联的迁移任务分析结果'")
  @SaturnColumn(description = "关联的迁移任务分析结果")
  private TemplateMigrateImportAnalysisEntity analysisEntity;

  /** 编号 */
  @Column(name = "code", nullable = false, columnDefinition = "varchar(255) COMMENT '编号'")
  @SaturnColumn(description = "编号")
  @ApiModelProperty(name = "code", value = "编号", required = true)
  private String code;

  /** 模板名，例如付款申请表 */
  @ApiModelProperty(name = "name", value = "模板名，例如付款申请表", required = true)
  @Column(name = "name", length = 128, nullable = false, columnDefinition = "varchar(255) COMMENT '模板名'")
  @SaturnColumn(description = "模板名")
  private String name;

  /** 模板版本信息 */
  @ApiModelProperty(name = "cversion", value = "表单模板在表单引擎中，相同的表单模板编号有不同的版本信息", required = true)
  @Column(name = "cversion", length = 64, nullable = false, columnDefinition = "varchar(255) COMMENT '表单模板在表单引擎中，相同的表单模板编号有不同的版本信息'")
  @SaturnColumn(description = "不同的版本信息")
  private String cversion;

  /** 模板类型：1：表单，2：列表 */
  @Column(name = "from_type", nullable = false, columnDefinition = "int(11) COMMENT '模板类型：1：表单，2：列表'")
  @SaturnColumn(description = "类型：1：表单，2：列表")
  @ApiModelProperty(name = "formType", value = "类型：1：表单，2：列表", required = true)
  private Integer formType;

  /** 模板预插入状态：1:新增，2:更新，3:错误 */
  @Column(name = "migrate_status", nullable = false, columnDefinition = "int(11) COMMENT '模板预插入状态：1:新增，2:更新，3:错误 '")
  @SaturnColumn(description = "模板预插入状态：1:新增，2:更新，3:错误")
  @ApiModelProperty(name = "migrateStatus", value = "模板预插入状态：1:新增，2:更新，3:错误", required = true)
  private Integer migrateStatus = 1;

  /** 检测内容反馈信息（包含覆盖，错误等提示） */
  @Column(name = "message", length = 255, nullable = false, columnDefinition = "varchar(255) COMMENT '检测内容反馈信息（包含覆盖，错误等提示）'")
  @ApiModelProperty(name = "message", value = "检测内容反馈信息（包含覆盖，错误等提示）", required = true)
  @SaturnColumn(description = "检测内容反馈信息（包含覆盖，错误等提示）")
  private String message = "";

  public TemplateMigrateImportAnalysisEntity getAnalysisEntity() {
    return analysisEntity;
  }

  public void setAnalysisEntity(TemplateMigrateImportAnalysisEntity analysisEntity) {
    this.analysisEntity = analysisEntity;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getCversion() {
    return cversion;
  }

  public void setCversion(String cversion) {
    this.cversion = cversion;
  }

  public Integer getFormType() {
    return formType;
  }

  public void setFormType(Integer formType) {
    this.formType = formType;
  }

  public Integer getMigrateStatus() {
    return migrateStatus;
  }

  public void setMigrateStatus(Integer migrateStatus) {
    this.migrateStatus = migrateStatus;
  }

  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }
}
