package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;
import java.util.Date;
import java.util.Set;

/**
 * TemplateMigrateImportEntity
 *
 * @description:
 * @author: yanwe
 * @date: 23/Sep/2019 15:31
 */

@ApiModel("迁入文件保存实体")
@Entity
@Table(name = "engine_template_migrate_import")
public class TemplateMigrateImportEntity extends UuidEntity {
  private static final long serialVersionUID = 6709783973281853912L;

  /** 关联下级多次预分析结果 */
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "templateMigrateImportEntity")
  @SaturnColumn(description = "关联下级多次预分析结果")
  private Set<TemplateMigrateImportAnalysisEntity> analysisEntities;


  /** 编号. */
  @Column(name = "code", length = 64, nullable = false, unique = true, columnDefinition = "varchar(64) COMMENT '编号'")
  @ApiModelProperty(name = "code", value = "编号", required = true)
  @SaturnColumn(description = "编号")
  private String code;

  /** 数据迁移描述 */
  @Column(name = "migrate_desc", length = 255, columnDefinition = "varchar(255) COMMENT '数据迁移描述'")
  @ApiModelProperty(name = "migrateDesc", value = "数据迁移描述")
  @SaturnColumn(description = "数据迁移描述")
  private String migrateDesc;


  /** 文件在本地存储路径 */
  @Column(name = "relative_local", length = 255, nullable = false, columnDefinition = "varchar(255) COMMENT '文件在本地存储路径'")
  @ApiModelProperty(name = "relativeLocal", value = "文件在本地存储路径", required = true)
  @SaturnColumn(description = "文件在本地存储路径")
  private String relativeLocal;

  /** 重命名后的文件名字 */
  @ApiModelProperty(name = "fileName", value = "重命名后的文件名字", required = true)
  @Column(name = "file_name", nullable = false, unique = true, columnDefinition = "varchar(255) COMMENT '重命名后的文件名字'")
  @SaturnColumn(description = "重命名后的文件名字")
  private String fileName;

  /** 上传文件原名 */
  @Column(name = "original_file_name", length = 255, columnDefinition = "varchar(255) COMMENT '上传文件原名'")
  @ApiModelProperty(name = "originalFileName", value = "上传文件原名")
  @SaturnColumn(description = "上传文件原名")
  private String originalFileName;

  /** 上传人 */
  @ApiModelProperty(name = "creator", value = "上传人", required = true)
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "creator", nullable = false, columnDefinition = "varchar(255) COMMENT '上传人'")
  @SaturnColumn(description = "上传人")
  private UserEntity creator;

  /** 上传时间 */
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '上传时间'")
  @ApiModelProperty(name = "createTime", value = "上传时间", required = true)
  @SaturnColumn(description = "上传时间")
  private Date createTime = new Date();

  /** 本次任务是否最终执行,true:已执行，false：未执行 */
  @Column(name = "executed", nullable = false, columnDefinition = "bit(1) COMMENT '本次任务是否最终执行,true:已执行，false：未执行'")
  @ApiModelProperty(name = "executed", value = "本次任务是否最终执行,true:已执行，false：未执行", required = true)
  @SaturnColumn(description = "本次任务是否最终执行,true:已执行，false：未执行")
  private Boolean executed = false;

  /** 任务执行人 */
  @ApiModelProperty(name = "executor", value = "任务执行人")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "executor", columnDefinition = "varchar(255) COMMENT '任务执行人'")
  @SaturnColumn(description = "任务执行人")
  private UserEntity executor;

  /** 执行时间 */
  @Column(name = "execute_time", columnDefinition = "datetime COMMENT '执行时间'")
  @ApiModelProperty(name = "executeTime", value = "执行时间")
  @SaturnColumn(description = "执行时间")
  private Date executeTime;



  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getMigrateDesc() {
    return migrateDesc;
  }

  public void setMigrateDesc(String migrateDesc) {
    this.migrateDesc = migrateDesc;
  }

  public String getRelativeLocal() {
    return relativeLocal;
  }

  public void setRelativeLocal(String relativeLocal) {
    this.relativeLocal = relativeLocal;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getOriginalFileName() {
    return originalFileName;
  }

  public void setOriginalFileName(String originalFileName) {
    this.originalFileName = originalFileName;
  }

  public UserEntity getCreator() {
    return creator;
  }

  public void setCreator(UserEntity creator) {
    this.creator = creator;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Boolean getExecuted() {
    return executed;
  }

  public void setExecuted(Boolean executed) {
    this.executed = executed;
  }

  public UserEntity getExecutor() {
    return executor;
  }

  public void setExecutor(UserEntity executor) {
    this.executor = executor;
  }

  public Date getExecuteTime() {
    return executeTime;
  }

  public void setExecuteTime(Date executeTime) {
    this.executeTime = executeTime;
  }

  public Set<TemplateMigrateImportAnalysisEntity> getAnalysisEntities() {
    return analysisEntities;
  }

  public void setAnalysisEntities(Set<TemplateMigrateImportAnalysisEntity> analysisEntities) {
    this.analysisEntities = analysisEntities;
  }
}
