package com.bizunited.platform.kuiper.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

/**
 * 模型关联的一般性属性，所谓一般属性，是指那些没有和其它模型产生关联关系的字段属性，其类型都是基础类型
 * @author yinwenjie
 */
@ApiModel("模型关联的一般性属性，所谓一般属性，是指那些没有和其它模型产生关联关系的字段属性，其类型都是基础类型")
@Entity
@Table(name="engine_form_template_property")
@org.hibernate.annotations.Table(appliesTo = "engine_form_template_property" , comment = "模型关联的一般性属性，所谓一般属性，是指那些没有和其它模型产生关联关系的字段属性，其类型都是基础类型")
public class TemplatePropertyEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = -8132906757772035004L;
  /**
   * 该一般属性可能关联的主表单模板信息
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="current_template_id" , nullable=true, columnDefinition = "varchar(255) COMMENT '该一般属性可能关联的主表单模板信息'")
  @SaturnColumn(description="可能关联的主表单模板")
  private TemplateEntity currentTemplate = null;
  /**
   * 该一般属性可能关联的模板分组信息
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="current_group_id" , nullable=true, columnDefinition = "varchar(255) COMMENT '该一般属性可能关联的模板分组信息'")
  @SaturnColumn(description="可能关联的模板分组信息")
  private TemplateGroupEntity currentGroup = null;
  /**
   * 该一般属性可能关联的模板明细信息
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="current_item_id" , nullable=true, columnDefinition = "varchar(255) COMMENT '该一般属性可能关联的模板明细信息'")
  @SaturnColumn(description="可能关联的模板明细信息")
  private TemplateItemEntity currentItem = null;
  /**
   * 该属性的排序索引。第一个属性编号为0
   */
  @ApiModelProperty(name="index" , value="该属性的排序索引。第一个属性编号为0", required=true)
  @Column(name="pindex" , nullable=false, columnDefinition = "int(11) COMMENT '该属性的排序索引。第一个属性编号为0'")
  @SaturnColumn(description="该属性的排序索引")
  private Integer index = 0;
  /**
   * 属性名，一定是英文
   */
  @ApiModelProperty(name="propertyName" , value="属性名，一定是英文", required=true)
  @Column(name="property_name" , length=128 , nullable=false, columnDefinition = "varchar(128) COMMENT '属性名，一定是英文'")
  @SaturnColumn(description="属性名")
  private String propertyName;
  /**
   * 该属性名的描述说明信息
   */
  @ApiModelProperty(name="propertyDesc" , value="该属性名的描述说明信息", required=true)
  @Column(name="property_desc" , length=255 , nullable=false, columnDefinition = "varchar(255) COMMENT '该属性名的描述说明信息'")
  @SaturnColumn(description="属性名的描述说明信息")
  private String propertyDesc;
  /**
   * 属性名可能对应的数据库字段名
   */
  @ApiModelProperty(name="propertyDbName" , value="属性名可能对应的数据库字段名", required=false)
  @Column(name="property_dbname" , length=128 , nullable=false, columnDefinition = "varchar(128) COMMENT '属性名可能对应的数据库字段名'")
  @SaturnColumn(description="可能对应的数据库字段名（只能是英文）")
  private String propertyDbName = "";
  /**
   * 可能存在的内容最大长度限制。如果有大于0的值说明有内容最大长度限制
   */
  @ApiModelProperty(name="maxLen" , value="可能存在的内容最大长度限制。如果有大于0的值说明有内容最大长度限制", required=false)
  @Column(name="max_len" , nullable=true, columnDefinition = "int(11) COMMENT '可能存在的内容最大长度限制。如果有大于0的值说明有内容最大长度限制'")
  @SaturnColumn(description="可能存在的内容最大长度限制")
  private Integer maxLen;
  /**
   * 属性类型（完整类型）
   */
  @ApiModelProperty(name="propertyClassName" , value="属性类型（完整类型）", required=true)
  @Column(name="property_classname" , length=128 , nullable=false, columnDefinition = "varchar(128) COMMENT '属性类型（完整类型）'")
  @SaturnColumn(description="属性类型（完整类型）")
  private String propertyClassName;
  /**
   * 该属性是否可以进行基础插入操作，既是在默认生成的create方法中允许插入
   */
  @ApiModelProperty(name="canInsert" , value="该属性是否可以进行基础插入操作，既是在默认生成的create方法中允许插入", required=true)
  @Column(name="caninsert" , nullable=false, columnDefinition = "bit(1) COMMENT '该属性是否可以进行基础插入操作，既是在默认生成的create方法中允许插入'")
  @SaturnColumn(description="该属性是否可以进行基础插入操作")
  private Boolean canInsert = true;
  /**
   * 该属性是否可以进行基础修改操作，既是在默认生成的update方法中允许插入
   */
  @ApiModelProperty(name="canupdate" , value="该属性是否可以进行基础修改操作，既是在默认生成的update方法中允许插入", required=true)
  @Column(name="canupdate" , nullable=false, columnDefinition = "bit(1) COMMENT '是否可以进行基础修改操作，既是在默认生成的update方法中允许插入'")
  @SaturnColumn(description="该属性是否可以进行基础修改操作")
  private Boolean canUpdate = true;
  /**
   * 属性是否必须有值，既是在进行任何写操作前，是否需要进行null性质的验证
   */
  @ApiModelProperty(name="nullable" , value="属性是否必须有值，既是在进行任何写操作前，是否需要进行null性质的验证", required=true)
  @Column(name="nullable" , nullable=false, columnDefinition = "bit(1) COMMENT '属性是否必须有值'")
  @SaturnColumn(description="属性是否必须有值")
  private Boolean nullable = true;
  /**
   * 该属性是否必须唯一，既是在进行任何写操作前，是否需要进行重复性验证
   */
  @ApiModelProperty(name="unique" , value="该属性是否必须唯一，既是在进行任何写操作前，是否需要进行重复性验证", required=true)
  @Column(name="punique" , nullable=false, columnDefinition = "bit(1) COMMENT '该属性是否必须唯一'")
  @SaturnColumn(description="该属性是否必须唯一")
  private Boolean unique = false;
  /**
   * 该属性是否是主键，既是在数据层，该属性是否为数据库中的一个主键信息
   */
  @ApiModelProperty(name="primarykey" , value="该属性是否是主键，既是在数据层，该属性是否为数据库中的一个主键信息", required=true)
  @Column(name="primarykey" , nullable=false, columnDefinition = "bit(1) COMMENT '该属性是否是主键'")
  @SaturnColumn(description="该属性是否是主键")
  private Boolean primaryKey = false;
  /**
   * 如果指定的控件需要使用固定的K-V接口，则可以在这里指定Key的值
   */
  @ApiModelProperty(name="defaultKeys" , value="如果指定的控件需要使用固定的K-V接口，则可以在这里指定Key的值", required=false)
  @Column(name="defaultkeys" , length=128 , nullable=true, columnDefinition = "varchar(128) COMMENT 'K-V控件支持的key值'")
  @SaturnColumn(description="K-V控件支持的key值")
  private String defaultKeys;
  /**
   * 如果指定的控件需要使用固定的K-V接口，则可以在这里指定Value的值
   */
  @ApiModelProperty(name="defaultValues" , value="如果指定的控件需要使用固定的K-V接口，则可以在这里指定Value的值", required=false)
  @Column(name="defaultvalues", length=128 , nullable=true, columnDefinition = "varchar(128) COMMENT 'K-V控件支持的value值'")
  @SaturnColumn(description="K-V控件支持的value值")
  private String defaultValues;
  /**
   * 选择的字典：当指定的defaultController属性值为SELECT , RADIO , CHECKBOX时，就可以指定该属性
   */
  @Column(name="default_dictionary" , length=32 , nullable=true, columnDefinition = "varchar(32) COMMENT '当指定的defaultController属性值为SELECT , RADIO , CHECKBOX时，就可以指定该属性'")
  @SaturnColumn(description="选择的字典")
  private String defaultDictionary;
  /**
   * 使用该控件可以指定页面上默认使用的类型，但是默认使用的类型作用期是有限的。<br>
   * 如果在表单模板的编辑过程中，使用者重新指定了相关控件，则默认的这个defaultType设置则不再起作用
   */
  @ApiModelProperty(name="defaultController" , value="指定的默认控件", required=false)
  @Column(name="default_controller" , length=32 , nullable=true, columnDefinition = "varchar(32) COMMENT '指定的默认控件'")
  @SaturnColumn(description="指定的默认控件")
  private String defaultController;
  public Integer getIndex() {
    return index;
  }
  public void setIndex(Integer index) {
    this.index = index;
  }
  public String getPropertyName() {
    return propertyName;
  }
  public void setPropertyName(String propertyName) {
    this.propertyName = propertyName;
  }
  public String getPropertyDesc() {
    return propertyDesc;
  }
  public void setPropertyDesc(String propertyDesc) {
    this.propertyDesc = propertyDesc;
  }
  public String getPropertyDbName() {
    return propertyDbName;
  }
  public void setPropertyDbName(String propertyDbName) {
    this.propertyDbName = propertyDbName;
  }
  public String getPropertyClassName() {
    return propertyClassName;
  }
  public void setPropertyClassName(String propertyClassName) {
    this.propertyClassName = propertyClassName;
  }
  public Boolean getCanInsert() {
    return canInsert;
  }
  public void setCanInsert(Boolean canInsert) {
    this.canInsert = canInsert;
  }
  public Boolean getCanUpdate() {
    return canUpdate;
  }
  public void setCanUpdate(Boolean canUpdate) {
    this.canUpdate = canUpdate;
  }
  public Boolean getNullable() {
    return nullable;
  }
  public void setNullable(Boolean nullable) {
    this.nullable = nullable;
  }
  public Boolean getUnique() {
    return unique;
  }
  public void setUnique(Boolean unique) {
    this.unique = unique;
  }
  public Boolean getPrimaryKey() {
    return primaryKey;
  }
  public void setPrimaryKey(Boolean primaryKey) {
    this.primaryKey = primaryKey;
  }
  public String getDefaultKeys() {
    return defaultKeys;
  }
  public void setDefaultKeys(String defaultKeys) {
    this.defaultKeys = defaultKeys;
  }
  public String getDefaultValues() {
    return defaultValues;
  }
  public void setDefaultValues(String defaultValues) {
    this.defaultValues = defaultValues;
  }
  public Integer getMaxLen() {
    return maxLen;
  }
  public void setMaxLen(Integer maxLen) {
    this.maxLen = maxLen;
  }
  public String getDefaultDictionary() {
    return defaultDictionary;
  }
  public void setDefaultDictionary(String defaultDictionary) {
    this.defaultDictionary = defaultDictionary;
  }
  public String getDefaultController() {
    return defaultController;
  }
  public void setDefaultController(String defaultController) {
    this.defaultController = defaultController;
  }
  public TemplateEntity getCurrentTemplate() {
    return currentTemplate;
  }
  public void setCurrentTemplate(TemplateEntity currentTemplate) {
    this.currentTemplate = currentTemplate;
  }
  public TemplateGroupEntity getCurrentGroup() {
    return currentGroup;
  }
  public void setCurrentGroup(TemplateGroupEntity currentGroup) {
    this.currentGroup = currentGroup;
  }
  public TemplateItemEntity getCurrentItem() {
    return currentItem;
  }
  public void setCurrentItem(TemplateItemEntity currentItem) {
    this.currentItem = currentItem;
  }
  
}