package com.bizunited.platform.kuiper.entity;

import java.util.Date;

import io.swagger.annotations.ApiModel;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

/**
 * 模板样式模型
 * @author yinwenjie
 */
@ApiModel(value = "TemplateStyleEntity" , description="模板样式模型")
@Entity
@Table(name="engine_form_style")
@org.hibernate.annotations.Table(appliesTo = "engine_form_style" , comment = "模板样式模型")
public class TemplateStyleEntity extends UuidEntity {
  /**
   *
   */
  private static final long serialVersionUID = 4819176381310897598L;
  /**
   * 模板样式的业务编号信息
   */
  @Column(name="code" , length=128 , nullable=false , unique=true, columnDefinition = "varchar(128) COMMENT '模板样式的业务编号信息'")
  @SaturnColumn(description="业务编号信息")
  private String code;
  /**
   * 模板样式的中文说明信息
   */
  @Column(name="name" , length=128 , nullable=false, columnDefinition = "varchar(128) COMMENT '模板样式的中文说明信息'")
  @SaturnColumn(description="中文说明信息")
  private String name;
  /**
   * 系统保留样式？
   * 1：系统样式（不允许修改、删除、禁用）
   * 0：非系统样式（允许修改、删除、禁用）
   */
  @Column(name="system_style" , nullable=false, columnDefinition = "int(11) COMMENT '系统保留样式？1：系统样式（不允许修改、删除、禁用） 0：非系统样式（允许修改、删除、禁用）'")
  @SaturnColumn(description="系统保留样式")
  private Integer systemStyle = 1;
  /**
   * 样式文件类型，目前只有两种：css和less
   */
  @Column(name="style_type" , length=64 , nullable=false, columnDefinition = "varchar(64) COMMENT '样式文件类型，目前只有两种：css和less'")
  @SaturnColumn(description="样式类型")
  private String styleType;
  /**
   * 当前样式状态；1：正常；0：不正常
   */
  @Column(name="tstatus" , nullable=false, columnDefinition = "int(11) COMMENT '当前样式状态；1：正常；0：不正常'")
  @SaturnColumn(description="样式状态")
  private Integer tstatus = 1;
  /**
   * 创建时间
   */
  @Column(name="create_time" , nullable=false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description="创建时间")
  private Date createTime;
  /**
   * 后端用于存储表单样式信息序列化以后的文档的目录
   */
  @Column(name="relative_path" , nullable=false, columnDefinition = "varchar(255) COMMENT '后端用于存储表单样式信息序列化以后的文档的目录'")
  @SaturnColumn(description="样式文档的相对目录")
  private String relativePath;
  /**
   * 保存的样式文件文件名(包括后缀)
   */
  @Column(name="file_Name" , nullable=false, columnDefinition = "varchar(255) COMMENT '保存的样式文件文件名(包括后缀)'")
  @SaturnColumn(description="保存的样式文件文件名")
  private String fileName;
  public String getCode() {
    return code;
  }
  public void setCode(String code) {
    this.code = code;
  }
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }
  public Integer getSystemStyle() {
    return systemStyle;
  }
  public void setSystemStyle(Integer systemStyle) {
    this.systemStyle = systemStyle;
  }
  public Integer getTstatus() {
    return tstatus;
  }
  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }
  public Date getCreateTime() {
    return createTime;
  }
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
  public String getStyleType() {
    return styleType;
  }
  public void setStyleType(String styleType) {
    this.styleType = styleType;
  }
  public String getRelativePath() {
    return relativePath;
  }
  public void setRelativePath(String relativePath) {
    this.relativePath = relativePath;
  }
  public String getFileName() {
    return fileName;
  }
  public void setFileName(String fileName) {
    this.fileName = fileName;
  }
}