package com.bizunited.platform.kuiper.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

/**
 * 表单模板中已有的按钮控件的可见性设定在这里
 * @author yinwenjie
 */
@ApiModel(value = "TemplateVisibilityButtonsEntity" , description="表单模板中已有的按钮控件的可见性设定在这里")
@Entity
@Table(name="engine_form_visibility_buttons" , indexes={@Index(columnList="visibility_id,controller_id,layout_type" , unique=true)})
@org.hibernate.annotations.Table(appliesTo = "engine_form_visibility_buttons" , comment = "表单模板中已有的按钮控件的可见性设定在这里")
public class TemplateVisibilityButtonsEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 6466357130559398359L;
  /**
   * 该属性可见性设定对应的可见性信息编号
   */
  @ApiModelProperty(name="templateVisibility" , value="该属性可见性设定对应的可见性信息编号" , hidden=true , required=true)
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="visibility_id" , nullable=false, columnDefinition = "varchar(255) COMMENT '该属性可见性设定对应的可见性信息编号'")
  @SaturnColumn(description="可见性信息编号")
  private TemplateVisibilityEntity templateVisibility;
  /**
   * 按钮控件在该表单模板上的唯一编号
   */
  @ApiModelProperty(name="controllerId" , value="按钮控件在该表单模板上的唯一编号" , required=true)
  @Column(name="controller_id" , length=64 , nullable=false, columnDefinition = "varchar(64) COMMENT '按钮控件在该表单模板上的唯一编号'")
  @SaturnColumn(description="唯一编号")
  private String controllerId;
  /**
   * 该按钮控件在这个可见性定义中是否可见：true:可见；false:隐藏
   */
  @ApiModelProperty(name="controllerId" , value="该按钮控件在这个可见性定义中是否可见：true:可见；false:隐藏" , required=true)
  @SaturnColumn(description="是否可见")
  @Column(name="visible" , nullable=false, columnDefinition = "bit(1) COMMENT '该按钮控件在这个可见性定义中是否可见：true:可见；false:隐藏'")
  private Boolean visible = true;
  /**
   * 该控件的布局类型；1：PC、2：移动端、3：打印端
   */
  @ApiModelProperty(name="layoutType" , value="该控件的可见性类型；1：PC、2：移动端、3：打印端", required = true)
  @Column(name="layout_type", nullable = true, columnDefinition = "int(11) COMMENT '该控件的布局类型；1：PC、2：移动端、3：打印端'")
  @SaturnColumn(description="布局类型")
  private Integer layoutType;
  public TemplateVisibilityEntity getTemplateVisibility() {
    return templateVisibility;
  }
  public void setTemplateVisibility(TemplateVisibilityEntity templateVisibility) {
    this.templateVisibility = templateVisibility;
  }
  public String getControllerId() {
    return controllerId;
  }
  public void setControllerId(String controllerId) {
    this.controllerId = controllerId;
  }
  public Boolean getVisible() {
    return visible;
  }
  public void setVisible(Boolean visible) {
    this.visible = visible;
  }

  public Integer getLayoutType() {
    return layoutType;
  }

  public void setLayoutType(Integer layoutType) {
    this.layoutType = layoutType;
  }
}
