package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

import java.util.Date;
import java.util.Set;

/**
 * 表单引擎模板的数据层描述
 * @author yinwenjie
 */
@ApiModel(value = "TemplateEntity" , description="表单引擎模板的数据层描述")
@Entity
@Table(name="engine_form_template" , indexes={
  @Index(columnList="code,cversion" , unique=true) , 
  @Index(columnList="form_style")})
@org.hibernate.annotations.Table(appliesTo = "engine_form_template" , comment = "表单引擎模板的数据层描述")
public class TemplateEntity extends UuidEntity {
  /**
   *
   */
  private static final long serialVersionUID = 4733445723381125929L;
  /**
   * 表单模板可能所属的业务域（由主模型传导过来）
   */
  @ApiModelProperty(name="domain" , value="表单模板可能所属的业务域（由主模型传导过来" , required=true)
  @Column(name="domain" , length=64 , nullable=false, columnDefinition = "varchar(64) COMMENT '表单模板可能所属的业务域（由主模型传导过来）'")
  @SaturnColumn(description="可能所属的业务域")
  private String domain = "";
  /**
   * 表单模板来源类型，目前有三种：<br>
   * static：静态模型——依据当前业务工程中数据实体层类定义描述生成的表单引擎模型<br>
   * dynamic：动态模型——依据业务操作人员页面设定的数据表生成的表单引擎模型<br>
   * dsl：dsl模型——依据业务操作者、开发人员通过DSL规范语言描述生成的表单引擎模型<br>
   */
  @ApiModelProperty(name="type" , value="表单模板来源类型，目前有三种：static：静态模型;dynamic：动态模型;dsl：dsl模型，其它值无效" , required=true)
  @Column(name="type" , length=32 , nullable=false, columnDefinition = "varchar(32) COMMENT '表单模板来源类型，目前有三种：static：静态模型;dynamic：动态模型;dsl：dsl模型，其它值无效'")
  @SaturnColumn(description="表单模板来源类型")
  private String type = "static";
  /**
   * 如果是静态模型（type = "static"），
   * 那么该字段记录静态模型的完整类型
   */
  @ApiModelProperty(name="persistentClassName" , value="静态模型的完整类型" , required=true)
  @Column(name="persistent_classname" , length=128 , nullable=false, columnDefinition = "varchar(128) COMMENT '静态模型的完整类型'")
  @SaturnColumn(description="静态模型的完成类型")
  private String persistentClassName = "";
  /**
   * 表单模板的唯一编号，唯一编号和版本号，将可以定位到唯一一个表单模板<br>
   * 一般来说，静态模板类型的编号就是这个静态模板的完整主类名
   */
  @ApiModelProperty(name="code" , value="表单模板的唯一编号，唯一编号和版本号，将可以定位到唯一一个表单模板"
      + "一般来说，静态模板类型的编号就是这个静态模板的完整主类名" , required=true)
  @Column(name="code" , length=128 , nullable=false, columnDefinition = "varchar(128) COMMENT '表单模板的唯一编号，唯一编号和版本号，将可以定位到唯一一个表单模板'")
  @SaturnColumn(description="表单模板的唯一编号")
  private String code = "";
  /**
   * 项目名，不填写也行，毕竟目前来看只可能是一个项目
   */
  @ApiModelProperty(name="projectName" , value="项目名，不填写也行，毕竟目前来看只可能是一个项目" , required=false)
  @Column(name="project_name" , columnDefinition = "varchar(255) COMMENT '项目名，不填写也行，毕竟目前来看只可能是一个项目'")
  @SaturnColumn(description="项目名")
  private String projectName;
  /**
   * 表单模板在表单引擎中，相同的表单模板编号有不同的版本信息
   */
  @ApiModelProperty(name="cversion" , value="表单模板在表单引擎中，相同的表单模板编号有不同的版本信息" , required=true)
  @Column(name="cversion" , length=64 , nullable=false, columnDefinition = "varchar(64) COMMENT '表单模板在表单引擎中，相同的表单模板编号有不同的版本信息'")
  @SaturnColumn(description="不同的版本信息")
  private String cversion;
  /**
   * 表单模板模板名，例如付款申请表
   */
  @ApiModelProperty(name="name" , value="表单模板模板名，例如付款申请表" , required=true)
  @Column(name="name" , length=128 , nullable=false, columnDefinition = "varchar(128) COMMENT '表单模板模板名，例如付款申请表'")
  @SaturnColumn(description="模板名")
  private String name;
  /**
   * 数据表名（动态模板使用）
   */
  @Column(name="table_name" , length=128 , nullable=false, columnDefinition = "varchar(128) COMMENT '数据表名（动态模板使用）'")
  @SaturnColumn(description="数据表名（动态模板使用）")
  private String tableName = "";
  /**
   * 这个表单模板是否有数据层信息进行支撑 
   */
  @ApiModelProperty(name="repositoryEntity" , value="这个表单模板是否有数据层信息进行支撑 " , required=true)
  @Column(name="repository_entity" , nullable=false, columnDefinition = "bit(1) COMMENT '这个表单模板是否有数据层信息进行支撑 '")
  @SaturnColumn(description="是否有数据层信息进行支撑 ")
  private Boolean repositoryEntity = true;
  /**
   * 当前表单模板版本是否是当前表单模板的默认版本
   */
  @ApiModelProperty(name="defaultVersion" , value="当前表单模板版本是否是当前表单模板的默认版本" , required=true)
  @Column(name="default_version" , nullable=false, columnDefinition = "bit(1) COMMENT '当前表单模板版本是否是当前表单模板的默认版本'")
  @SaturnColumn(description="是否是当前表单模板的默认版本")
  private Boolean defaultVersion = false;
  /**
   * 当前表单模板（精确到每个版本）的创建时间，yyyy-MM-dd HH:mm:ss
   */
  @ApiModelProperty(name="createTime" , value="当前表单模板（精确到每个版本）的创建时间" , required=true)
  @Column(name="create_time" , nullable=false, columnDefinition = "datetime COMMENT '当前表单模板（精确到每个版本）的创建时间，yyyy-MM-dd HH:mm:ss'")
  @SaturnColumn(description="创建时间")
  private Date createTime;
  /**
   * 表单模板目前使用的样式
   */
  @ApiModelProperty(name="formStyle" , value="表单模板目前使用的样式" , hidden=true , required=true)
  @Column(name="form_style" , length=64 , nullable=false, columnDefinition = "varchar(64) COMMENT '表单模板目前使用的样式'")
  @SaturnColumn(description="表单模板样式")
  private String formStyle = "";
  /**
   * 表单模板状态：1草稿（未发布）；0禁止/废除
   */
  @ApiModelProperty(name="tstatus" , value="表单模板状态：1正常；0禁止/废除" , hidden=true , required=true)
  @Column(name="tstatus" , nullable=false, columnDefinition = "int(11) COMMENT '表单模板状态：1草稿（未发布）；0禁止/废除'")
  @SaturnColumn(description="表单模板状态")
  private Integer tstatus = 1;
  /**
   * 创建人
   */
  @ApiModelProperty(name="creator" , value="创建人" , hidden=true , required=true)
  @Column(name="creator" , length=128 , nullable=false, columnDefinition = "varchar(128) COMMENT '创建人'")
  @SaturnColumn(description="创建人")
  private String creator;
  /**
   * 表单模板->其中的一般属性（既是没有关联性质的属性）
   */
  @ApiModelProperty(hidden=true)
  @OneToMany(fetch=FetchType.LAZY , mappedBy="currentTemplate")
  @SaturnColumn(description="一般属性数据描述")
  private Set<TemplatePropertyEntity> properties;
  /**
   * 表单模板->其中的关联属性</br>
   * 可使用的关联类型有：ManyToMany、ManyToOne
   */
  @ApiModelProperty(hidden=true)
  @OneToMany(fetch=FetchType.LAZY , mappedBy="currentTemplate")
  @SaturnColumn(description="关联属性数据描述")
  private Set<TemplateRelationEntity> relations;
  /**
   * 这里是分组信息，就是专门进行OneToOne关联信息的描述
   */
  @ApiModelProperty(hidden=true)
  @OneToMany(fetch=FetchType.LAZY , mappedBy="parentTemplate")
  @SaturnColumn(description="分组信息")
  private Set<TemplateGroupEntity> groupRelations;
  /**
   * 这里是分组信息，就是专门进行OneToMany明细关联信息的描述
   */
  @ApiModelProperty(hidden=true)
  @OneToMany(fetch=FetchType.LAZY , mappedBy="parentTemplate")
  @SaturnColumn(description="明细关联信息")
  private Set<TemplateItemEntity> itemRelations;
  /**
   * 该表单模板对应的模板事件信息（可能一个都没有，可能有多个）
   */
  @ApiModelProperty(hidden=true)
  @OneToMany(fetch=FetchType.LAZY , mappedBy="template")
  @SaturnColumn(description="模板事件信息")
  private Set<TemplateEventEntity> event;
  /**
   * 该表单模板对应的模板可见性信息（可能一个都没有，可能有多个）
   */
  @ApiModelProperty(hidden=true)
  @OneToMany(fetch=FetchType.LAZY , mappedBy="template")
  @SaturnColumn(description="模板可见性信息")
  private Set<TemplateVisibilityEntity> visibility;
  /**
   * 该表单模板对应的一个或者多个实例信息
   */
  @ApiModelProperty(hidden=true)
  @OneToMany(fetch=FetchType.LAZY , mappedBy="template")
  @SaturnColumn(description="对应的实例信息")
  private Set<InstanceEntity> instances;
  /**
   * 不直接进行数据存储、不进行对象化的的模板布局信息，默认PC端布局
   */
  @Transient
  private Object templateLayout;
  /**
   * 不直接进行数据存储、不进行对象化的的模板布局信息，移动端布局
   */
  @Transient
  private Object mobileTemplateLayout;
  /**
   * 不直接进行数据存储、不进行对象化的的模板布局信息，打印端布局
   */
  @Transient
  private Object printTemplateLayout;
  /**
   * 表单模板的修改时间
   */
  @ApiModelProperty(name="modifyTime" , value="修改时间" , required=true)
  @Column(name="modify_time" , nullable = false, columnDefinition = "datetime COMMENT '表单模板的修改时间'")
  @SaturnColumn(description="修改时间")
  private Date modifyTime;

  /**
   * 维护人员
   */
  @ApiModelProperty("维护人员")
  @SaturnColumn(description = "维护人员")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "template")
  private Set<TemplateMaintainerEntity> maintainers;

  public Date getModifyTime() {
    return modifyTime;
  }
  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }
  public String getType() {
    return type;
  }
  public void setType(String type) {
    this.type = type;
  }
  public String getDomain() {
    return domain;
  }
  public void setDomain(String domain) {
    this.domain = domain;
  }
  public String getCode() {
    return code;
  }
  public void setCode(String code) {
    this.code = code;
  }
  public String getCversion() {
    return cversion;
  }
  public void setCversion(String cversion) {
    this.cversion = cversion;
  }

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }
  public Boolean getRepositoryEntity() {
    return repositoryEntity;
  }
  public void setRepositoryEntity(Boolean repositoryEntity) {
    this.repositoryEntity = repositoryEntity;
  }
  public Boolean getDefaultVersion() {
    return defaultVersion;
  }
  public void setDefaultVersion(Boolean defaultVersion) {
    this.defaultVersion = defaultVersion;
  }
  public Set<InstanceEntity> getInstances() {
    return instances;
  }
  public void setInstances(Set<InstanceEntity> instances) {
    this.instances = instances;
  }
  public Date getCreateTime() {
    return createTime;
  }
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
  public Integer getTstatus() {
    return tstatus;
  }
  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }
  public Set<TemplateEventEntity> getEvent() {
    return event;
  }
  public void setEvent(Set<TemplateEventEntity> event) {
    this.event = event;
  }
  public Set<TemplateVisibilityEntity> getVisibility() {
    return visibility;
  }
  public void setVisibility(Set<TemplateVisibilityEntity> visibility) {
    this.visibility = visibility;
  }
  public String getFormStyle() {
    return formStyle;
  }
  public void setFormStyle(String formStyle) {
    this.formStyle = formStyle;
  }
  public Object getTemplateLayout() {
    return templateLayout;
  }
  public void setTemplateLayout(Object templateLayout) {
    this.templateLayout = templateLayout;
  }
  public String getPersistentClassName() {
    return persistentClassName;
  }
  public void setPersistentClassName(String persistentClassName) {
    this.persistentClassName = persistentClassName;
  }
  public String getTableName() {
    return tableName;
  }
  public void setTableName(String tableName) {
    this.tableName = tableName;
  }
  public Set<TemplatePropertyEntity> getProperties() {
    return properties;
  }
  public void setProperties(Set<TemplatePropertyEntity> properties) {
    this.properties = properties;
  }
  public Set<TemplateRelationEntity> getRelations() {
    return relations;
  }
  public void setRelations(Set<TemplateRelationEntity> relations) {
    this.relations = relations;
  }
  public Set<TemplateGroupEntity> getGroupRelations() {
    return groupRelations;
  }
  public void setGroupRelations(Set<TemplateGroupEntity> groupRelations) {
    this.groupRelations = groupRelations;
  }
  public Set<TemplateItemEntity> getItemRelations() {
    return itemRelations;
  }
  public void setItemRelations(Set<TemplateItemEntity> itemRelations) {
    this.itemRelations = itemRelations;
  }
  public Object getMobileTemplateLayout() {
    return mobileTemplateLayout;
  }
  public void setMobileTemplateLayout(Object mobileTemplateLayout) {
    this.mobileTemplateLayout = mobileTemplateLayout;
  }
  public Object getPrintTemplateLayout() {
    return printTemplateLayout;
  }
  public void setPrintTemplateLayout(Object printTemplateLayout) {
    this.printTemplateLayout = printTemplateLayout;
  }
  public String getCreator() {
    return creator;
  }
  public void setCreator(String creator) {
    this.creator = creator;
  }

  public Set<TemplateMaintainerEntity> getMaintainers() {
    return maintainers;
  }

  public void setMaintainers(Set<TemplateMaintainerEntity> maintainers) {
    this.maintainers = maintainers;
  }
}
