package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import java.util.Set;

/**
 * 模板明细编辑项信息，专门用于进行对主模型的中“可编辑明细”项的描述
 * 一个明细描述项只可能属于一个主模型。而且这种主模型和明细编辑项的关联关系只可能是OneToMany
 * @author yinwenjie
 */
@Entity
@Table(name="engine_form_items")
@org.hibernate.annotations.Table(appliesTo = "engine_form_items" , comment = "模板明细编辑项信息，专门用于进行对主模型的中“可编辑明细”项的描述")
public class TemplateItemEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = -1926258834703234994L;
  /**
   * 当前表单模板明细可能对应的表单模板关联信息（表单模板编号）
   */
  @OneToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="parent_template_id" , nullable=true, columnDefinition = "varchar(255) COMMENT '当前表单模板明细可能对应的表单模板关联信息（表单模板编号）'")
  @SaturnColumn(description="上层表单模板信息")
  private TemplateEntity parentTemplate;
  /**
   * 当前表单模板明细可能对应的表单模板分组关联信息（表单模板编号）
   */
  @OneToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="parent_group_id" , nullable=true, columnDefinition = "varchar(255) COMMENT '当前表单模板明细可能对应的表单模板分组关联信息（表单模板编号）'")
  @SaturnColumn(description="表单模板关联信息")
  private TemplateGroupEntity parentGroup;
  /**
   * 该分组信息适用的表单模板类型，目前有三种：<br>
   * static：该视图适用静态模型<br>
   * dynamic：该视图适用动态模型<br>
   * dsl：该视图适用dsl模型
   */
  @Column(name="items_type" , length=32 , nullable=false, columnDefinition = "varchar(32) COMMENT '目前有三种：static：静态模型;dynamic：动态模型;dsl：dsl模型，其它值无效'")
  @SaturnColumn(description="适用的表单模板类型")
  private String type;
  /**
   * 既是模型中的属性名，一定是英文
   */
  @ApiModelProperty(name="propertyName" , value="既是主模型中的属性名，一定是英文", required=true)
  @Column(name="property_name" , length=64 , nullable=false, columnDefinition = "varchar(64) COMMENT '既是模型中的属性名，一定是英文'")
  @SaturnColumn(description="既是主模型中的属性名")
  private String propertyName;
  /**
   * 既是该关联属性在主模型中的属性名，一定是英文
   */
  @ApiModelProperty(name="propertyDesc" , value="既是主模型中的属性名，一定是英文", required=true)
  @Column(name="property_desc" , nullable=false, columnDefinition = "varchar(255) COMMENT '既是该关联属性在主模型中的属性名，一定是英文'")
  @SaturnColumn(description="既是该关联属性在主模型中的属性名")
  private String propertyDesc;
  /**
   * 目标模型类，这个信息非常重要（静态模板使用）
   */
  @Column(name="property_classname" , length=128 , nullable=false, columnDefinition = "varchar(128) COMMENT '目标模型类，这个信息非常重要（静态模板使用）'")
  @SaturnColumn(description="目标模型类（静态模板使用）")
  private String propertyClassName = "";
  /**
   * 该属性在持久化类中的排序索引。第一个属性编号为0
   */
  @ApiModelProperty(name="index" , value="该属性在持久化类中的排序索引。第一个属性编号为0", required=true)
  @Column(name="cindex" , nullable=false, columnDefinition = "int(11) COMMENT '该属性在持久化类中的排序索引。第一个属性编号为0'")
  @SaturnColumn(description="该属性在持久化类中的排序索引")
  private Integer index = 0;
  /**
   * 使用的查询服务名（静态模板使用）
   */
  @Column(name="query_service" , length=128 , nullable=false, columnDefinition = "varchar(128) COMMENT '使用的查询服务名（静态模板使用）'")
  @SaturnColumn(description="使用的查询服务名")
  private String queryService = "";
  /**
   * 本明细使用的数据表，也就是当前明细表的表名</br>
   * 这个信息非常重要（动态模板使用）
   */
  @Column(name="table_name" , length=128 , nullable=false, columnDefinition = "varchar(128) COMMENT '本明细使用的数据表，也就是当前明细表的表名'")
  @SaturnColumn(description="目标数据表（动态模板使用）")
  private String tableName = "";
  /**
   * 明细数据表上层的主数据表名（动态模型使用）
   */
  @Column(name="parent_tablename" , length=128 , nullable=false, columnDefinition = "varchar(128) COMMENT '明细数据表上层的主数据表名（动态模型使用）'")
  @SaturnColumn(description="上层的主数据表")
  private String parentTableName = "";
  /**
   * 明细模型上层的主信息类名（静态模型使用）
   */
  @Column(name="parent_classname" , length=128 , nullable=false, columnDefinition = "varchar(128) COMMENT '明细模型上层的主信息类名（静态模型使用）'")
  @SaturnColumn(description="上层的主信息类名")
  private String parentClassName = "";
  /**
   * 模型的完整包名
   */
  @Column(name="pkage" , nullable=false, columnDefinition = "varchar(255) COMMENT '模型的完整包名'")
  @SaturnColumn(description="完整包名")
  private String pkage = "";
  /**
   * 模型的类简称（静态模型使用）
   */
  @Column(name="simple_classname" , length=128 , nullable=false, columnDefinition = "varchar(128) COMMENT '模型的类简称（静态模型使用）'")
  @SaturnColumn(description="类简称")
  private String simpleClassName;
  /**
   * 模型是否有数据层信息进行支撑
   */
  @Column(name="repository_entity" , nullable=false, columnDefinition = "bit(1) COMMENT '模型是否有数据层信息进行支撑'")
  @SaturnColumn(description="是否有数据层支撑")
  private Boolean repositoryEntity;
  /**
   * 明细编辑项中的一般属性
   */
  @OneToMany(fetch=FetchType.LAZY , mappedBy="currentItem")
  @SaturnColumn(description="明细编辑项中的一般属性")
  private Set<TemplatePropertyEntity> properties;
  /**
   * 明细编辑项中的关联属性
   */
  @OneToMany(fetch=FetchType.LAZY , mappedBy="currentItem")
  @SaturnColumn(description="明细编辑项中的关联属性")
  private Set<TemplateRelationEntity> relations;

  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("当前项目名工程名")
  @Column(name="project_name", nullable = false, columnDefinition = "varchar(255) default '' comment '工程名'")
  @SaturnColumn(description = "工程名")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }
  public String getParentTableName() {
    return parentTableName;
  }
  public void setParentTableName(String parentTableName) {
    this.parentTableName = parentTableName;
  }
  public String getParentClassName() {
    return parentClassName;
  }
  public void setParentClassName(String parentClassName) {
    this.parentClassName = parentClassName;
  }
  public String getPkage() {
    return pkage;
  }
  public void setPkage(String pkage) {
    this.pkage = pkage;
  }
  public String getSimpleClassName() {
    return simpleClassName;
  }
  public void setSimpleClassName(String simpleClassName) {
    this.simpleClassName = simpleClassName;
  }
  public Boolean getRepositoryEntity() {
    return repositoryEntity;
  }
  public void setRepositoryEntity(Boolean repositoryEntity) {
    this.repositoryEntity = repositoryEntity;
  }
  public String getType() {
    return type;
  }
  public void setType(String type) {
    this.type = type;
  }
  public String getQueryService() {
    return queryService;
  }
  public void setQueryService(String queryService) {
    this.queryService = queryService;
  }
  public Set<TemplatePropertyEntity> getProperties() {
    return properties;
  }
  public void setProperties(Set<TemplatePropertyEntity> properties) {
    this.properties = properties;
  }
  public Set<TemplateRelationEntity> getRelations() {
    return relations;
  }
  public void setRelations(Set<TemplateRelationEntity> relations) {
    this.relations = relations;
  }
  public TemplateEntity getParentTemplate() {
    return parentTemplate;
  }
  public void setParentTemplate(TemplateEntity parentTemplate) {
    this.parentTemplate = parentTemplate;
  }
  public TemplateGroupEntity getParentGroup() {
    return parentGroup;
  }
  public void setParentGroup(TemplateGroupEntity parentGroup) {
    this.parentGroup = parentGroup;
  }
  public String getPropertyName() {
    return propertyName;
  }
  public void setPropertyName(String propertyName) {
    this.propertyName = propertyName;
  }
  public String getPropertyDesc() {
    return propertyDesc;
  }
  public void setPropertyDesc(String propertyDesc) {
    this.propertyDesc = propertyDesc;
  }
  public String getPropertyClassName() {
    return propertyClassName;
  }
  public void setPropertyClassName(String propertyClassName) {
    this.propertyClassName = propertyClassName;
  }
  public Integer getIndex() {
    return index;
  }
  public void setIndex(Integer index) {
    this.index = index;
  }
  public String getTableName() {
    return tableName;
  }
  public void setTableName(String tableName) {
    this.tableName = tableName;
  }
}
