package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.user.common.vo.UserVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import java.util.Date;

/**
 * 表单引擎模版的维护人员数据层描述
 * @Author: Paul Chan
 * @Date: 2020-05-25 17:11
 */
@Entity
@ApiModel(value = "TemplateMaintainerEntity" , description="表单引擎模版的维护人员数据层描述")
@Table(name="engine_form_template_maintainer",
    uniqueConstraints = @UniqueConstraint(columnNames = {"template_id", "user_account"}))
@org.hibernate.annotations.Table(appliesTo = "engine_form_template_maintainer" , comment = "表单引擎模版的维护人员数据层描述")
public class TemplateMaintainerEntity extends UuidEntity {
  private static final long serialVersionUID = -7147218861735391544L;

  /**
   * 表单模版
   */
  @ApiModelProperty("表单模版")
  @ManyToOne(fetch = FetchType.LAZY)
  @SaturnColumn(description = "表单模版")
  @JoinColumn(name = "template_id", nullable = false, columnDefinition = "varchar(255) COMMENT '表单模版ID'")
  private TemplateEntity template;

  /**
   * 用户账号
   */
  @ApiModelProperty("用户账号")
  @SaturnColumn(description = "用户账号")
  @Column(name = "user_account", nullable = false, columnDefinition = "varchar(255) COMMENT '用户账号'")
  private String userAccount;

  /**
   * 创建时间
   */
  @ApiModelProperty("创建时间")
  @SaturnColumn(description = "创建时间")
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime(3) COMMENT '创建时间'")
  private Date createTime;

  /**
   * 用户信息
   */
  @Transient
  @ApiModelProperty("用户信息")
  @SaturnColumn(description = "用户信息")
  private UserVo user;

  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("当前项目名工程名")
  @Column(name="project_name", nullable = false, columnDefinition = "varchar(255) default '' comment '工程名'")
  @SaturnColumn(description = "工程名")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public TemplateEntity getTemplate() {
    return template;
  }

  public void setTemplate(TemplateEntity template) {
    this.template = template;
  }

  public String getUserAccount() {
    return userAccount;
  }

  public void setUserAccount(String userAccount) {
    this.userAccount = userAccount;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public UserVo getUser() {
    return user;
  }

  public void setUser(UserVo user) {
    this.user = user;
  }
}