package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * 该类描述模型中关联性属性定义描述，所谓关联属性，是指模型中和其它模型存在关联关系的属性
 * @author yinwenjie
 */
@ApiModel("该类描述模型中关联性属性定义描述，所谓关联属性，是指主模型中和其它模型存在关联关系的属性")
@Entity
@Table(name="engine_form_template_relation")
@org.hibernate.annotations.Table(appliesTo = "engine_form_template_relation" , comment = "该类描述模型中关联性属性定义描述，所谓关联属性，是指主模型中和其它模型存在关联关系的属性")
public class TemplateRelationEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 5602519328736831361L;
  /**
   * 该关联属性可能关联的主表单模板信息
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="current_template_id" , nullable=true, columnDefinition = "varchar(255) COMMENT '该关联属性可能关联的主表单模板信息'")
  @SaturnColumn(description="可能关联的主表单模板")
  private TemplateEntity currentTemplate = null;
  /**
   * 该关联属性可能关联的模板分组信息
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="current_group_id" , nullable=true, columnDefinition = "varchar(255) COMMENT '可能关联的模板分组信息'")
  @SaturnColumn(description="可能关联的模板分组信息")
  private TemplateGroupEntity currentGroup = null;
  /**
   * 该关联属性可能关联的模板明细信息
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="current_item_id" , nullable=true, columnDefinition = "varchar(255) COMMENT '可能关联的模板明细信息'")
  @SaturnColumn(description="可能关联的模板明细信息")
  private TemplateItemEntity currentItem = null;
  /**
   * 既是主模型中的属性名，一定是英文
   */
  @ApiModelProperty(name="propertyName" , value="既是主模型中的属性名，一定是英文", required=true)
  @Column(name="property_name" , length=64 , nullable=false, columnDefinition = "varchar(64) COMMENT '既是主模型中的属性名，一定是英文'")
  @SaturnColumn(description="既是主模型中的属性名")
  private String propertyName;
  /**
   * 数据库关联字段名(在ManyToMany、OneToMany关联类型的情况下，这个字段是空值的）
   */
  @ApiModelProperty(name="propertyDbName" , value="数据库关联字段名(在ManyToMany、OneToMany关联类型的情况下，这个字段是空值的）", required=false)
  @Column(name="property_dbname" , length=64 , nullable=false, columnDefinition = "varchar(64) COMMENT ' 数据库关联字段名(在ManyToMany、OneToMany关联类型的情况下，这个字段是空值的）'")
  @SaturnColumn(description="该属性名对应的数据库字段名")
  private String propertyDbName = "";
  /**
   * 既是该关联属性在主模型中的属性名，一定是英文
   */
  @ApiModelProperty(name="propertyDesc" , value="既是主模型中的属性名，一定是英文", required=true)
  @Column(name="property_desc" , nullable=false, columnDefinition = "varchar(255) COMMENT '既是该关联属性在主模型中的属性名'")
  @SaturnColumn(description="既是该关联属性在主模型中的属性名")
  private String propertyDesc;
  /**
   * 该属性在持久化类中的排序索引。第一个属性编号为0
   */
  @ApiModelProperty(name="index" , value="该属性在持久化类中的排序索引。第一个属性编号为0", required=true)
  @Column(name="cindex" , nullable=false, columnDefinition = "int(11) COMMENT '该属性在持久化类中的排序索引'")
  @SaturnColumn(description="该属性在持久化类中的排序索引")
  private Integer index = 0; 
  /**
   * 该属性是否可以进行基础插入操作，既是在默认生成的create方法中允许插入
   */
  @ApiModelProperty(name="canInsert" , value="该属性是否可以进行基础插入操作，既是在默认生成的create方法中允许插入", required=false)
  @Column(name="caninsert" , nullable=true, columnDefinition = "bit(1) COMMENT '该属性是否可以进行基础插入操作'")
  @SaturnColumn(description="该属性是否可以进行基础插入操作")
  private Boolean canInsert;
  /**
   * 该属性是否可以进行基础修改操作，既是在默认生成的update方法中允许插入
   */
  @ApiModelProperty(name="canUpdate" , value="该属性是否可以进行基础修改操作，既是在默认生成的update方法中允许插入", required=false)
  @Column(name="canupdate" , nullable=true, columnDefinition = "bit(1) COMMENT '该属性是否可以进行基础修改操作'")
  @SaturnColumn(description="该属性是否可以进行基础修改操作")
  private Boolean canUpdate;
  /**
   * 属性是否必须有值，既是在进行任何写操作前，是否需要进行null性质的验证
   */
  @ApiModelProperty(name="nullable" , value="属性是否必须有值，既是在进行任何写操作前，是否需要进行null性质的验证", required=false)
  @Column(name="nullable" , nullable=true, columnDefinition = "bit(1) COMMENT '属性是否必须有值'")
  @SaturnColumn(description="属性是否必须有值")
  private Boolean nullable;
  /**
   * 和主模型的关联类型，包括：ManyToOne、ManyToMany。
   */
  @ApiModelProperty(name="relationType" , value="和主模型的关联类型，包括： ManyToOne、ManyToMany。", required=true)
  @Column(name="relation_type" , length=32 , nullable=false, columnDefinition = "varchar(32) COMMENT '和主模型的关联类型，包括：ManyToOne、ManyToMany'")
  @SaturnColumn(description="和主模型的关联类型")
  private String relationType = "ManyToOne";
  /**
   * 所关联模型的完整类名，这个类名肯定代表一个存在的模型
   */
  @ApiModelProperty(name="propertyClassName" , value="所关联模型的完整类名，这个类名肯定代表一个存在的类模型（静态模板使用）", required=false)
  @Column(name="property_classname" , nullable=false, columnDefinition = "varchar(255) COMMENT '所关联模型的完整类名，这个类名肯定代表一个存在的类模型（静态模板使用）'")
  @SaturnColumn(description="所关联模型的完整类名，这个类名肯定代表一个存在的类模型（静态模板使用）")
  private String propertyClassName = "";
  /**
   * 可能关联的目标数据表名字，（动态模板使用）</br>
   * 无论是什么样的关联关系，都需要依据tableName限制可选择的/使用的弹出层、分组和明细编辑项</br>
   * 写
   */
  @ApiModelProperty(name="targetTableName" , value="关联的数据表名字（动态模板使用）", required=false)
  @Column(name="target_table_name" , length=64 , nullable=false, columnDefinition = "varchar(64) COMMENT '关联的数据表名字（动态模板使用）'")
  @SaturnColumn(description="关联的数据表名字（动态模板使用）")
  private String targetTableName = "";
  /**
   * 使用的查询服务名（静态模板使用）
   */
  @Column(name="query_service" , length=128 , nullable=false, columnDefinition = "varchar(128) COMMENT '使用的查询服务名'")
  @SaturnColumn(description="使用的查询服务名")
  private String queryService = "";
  /**
   * 当前属性是否是上一个属性的回溯属性，回溯属性不需要在表单页面上进行处理
   */
  @Column(name="back_property" , nullable=false, columnDefinition = "bit(1) COMMENT '是否回溯属性'")
  @SaturnColumn(description="是否回溯属性")
  private Boolean backProperty = false;
  /**
   * TODO: 2020-05-25 与数据视图的关联需要改为用code关联，而非主键关联  a:陈加平
   * 可能关联的弹出层编号</br>
   * 如果是ManyToOne关联或者ManyToMany关联，也就只需要选择目前已经设计好的弹出层即可
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="view_id" , nullable=true, columnDefinition = "varchar(255) COMMENT '可能关联的弹出层编号'")
  @SaturnColumn(description="可能关联的弹出层编号")
  private DataViewEntity currentView;

  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("当前项目名工程名")
  @Column(name="project_name", nullable = false, columnDefinition = "varchar(255) default '' comment '工程名'")
  @SaturnColumn(description = "工程名")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public String getRelationType() {
    return relationType;
  }
  public void setRelationType(String relationType) {
    this.relationType = relationType;
  }
  public Integer getIndex() {
    return index;
  }
  public void setIndex(Integer index) {
    this.index = index;
  }
  public String getPropertyName() {
    return propertyName;
  }
  public void setPropertyName(String propertyName) {
    this.propertyName = propertyName;
  }
  public String getPropertyDesc() {
    return propertyDesc;
  }
  public void setPropertyDesc(String propertyDesc) {
    this.propertyDesc = propertyDesc;
  }
  public String getPropertyDbName() {
    return propertyDbName;
  }
  public void setPropertyDbName(String propertyDbName) {
    this.propertyDbName = propertyDbName;
  }
  public String getPropertyClassName() {
    return propertyClassName;
  }
  public void setPropertyClassName(String propertyClassName) {
    this.propertyClassName = propertyClassName;
  }
  public Boolean getCanInsert() {
    return canInsert;
  }
  public void setCanInsert(Boolean canInsert) {
    this.canInsert = canInsert;
  }
  public Boolean getCanUpdate() {
    return canUpdate;
  }
  public void setCanUpdate(Boolean canUpdate) {
    this.canUpdate = canUpdate;
  }
  public Boolean getNullable() {
    return nullable;
  }
  public void setNullable(Boolean nullable) {
    this.nullable = nullable;
  }
  public String getTargetTableName() {
    return targetTableName;
  }
  public void setTargetTableName(String targetTableName) {
    this.targetTableName = targetTableName;
  }
  public DataViewEntity getCurrentView() {
    return currentView;
  }
  public void setCurrentView(DataViewEntity currentView) {
    this.currentView = currentView;
  }
  public String getQueryService() {
    return queryService;
  }
  public void setQueryService(String queryService) {
    this.queryService = queryService;
  }
  public Boolean getBackProperty() {
    return backProperty;
  }
  public void setBackProperty(Boolean backProperty) {
    this.backProperty = backProperty;
  }
  public TemplateEntity getCurrentTemplate() {
    return currentTemplate;
  }
  public void setCurrentTemplate(TemplateEntity currentTemplate) {
    this.currentTemplate = currentTemplate;
  }
  public TemplateGroupEntity getCurrentGroup() {
    return currentGroup;
  }
  public void setCurrentGroup(TemplateGroupEntity currentGroup) {
    this.currentGroup = currentGroup;
  }
  public TemplateItemEntity getCurrentItem() {
    return currentItem;
  }
  public void setCurrentItem(TemplateItemEntity currentItem) {
    this.currentItem = currentItem;
  }
}