package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * 动态模板草稿，该功能点的具体要求请参见线框图中的详细设计说明
 * @author yinwenjie
 */
@ApiModel("动态模板草稿，该功能点的具体要求请参见线框图中的详细设计说明")
@Entity
@Table(name="engine_form_draft")
@org.hibernate.annotations.Table(appliesTo = "engine_form_draft" , comment = "动态模板草稿，该功能点的具体要求请参见线框图中的详细设计说明")
public class DynamicTemplateDraftEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 4505843451310501927L;
  /**
   * 业务编号
   */
  @ApiModelProperty(name = "code", value = "业务编号", required = true)
  @Column(name = "code", nullable = false , unique=true, columnDefinition = "varchar(255) COMMENT '业务编号'")
  @SaturnColumn(description = "业务编号")
  private String code;
  /**
   * 业务名
   */
  @ApiModelProperty(name = "name", value = "业务名", required = true)
  @Column(name = "name", nullable = false, columnDefinition = "varchar(255) COMMENT '业务名/业务编号'")
  @SaturnColumn(description = "业务名/业务编号")
  private String name;
  /**
   * 动态模板设定的数据表名
   */
  @ApiModelProperty(name = "tableName", value = "动态模板设定的数据表名", required = true)
  @Column(name = "table_name", nullable = false , unique=true, columnDefinition = "varchar(255) COMMENT '动态模板设定的数据表名'")
  @SaturnColumn(description = "动态模板设定的数据表名")
  private String tableName;
  /**
   * 版本号
   */
  @ApiModelProperty(name = "cversion", value = "版本号", required = true)
  @Column(name = "cversion", nullable = false, columnDefinition = "varchar(255) COMMENT '版本号'")
  @SaturnColumn(description = "版本号")
  private String cversion;
  /**
   * 草稿的创建时间
   */
  @ApiModelProperty(name = "createTime", value = "草稿的创建时间")
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '草稿的创建时间'")
  @SaturnColumn(description = "草稿的创建时间")
  private Date createTime;
  /**
   * 草稿的最后修改时间
   */
  @ApiModelProperty(name = "modifyTime", value = "草稿的最后修改时间")
  @Column(name = "modify_time", nullable = false, columnDefinition = "datetime COMMENT '草稿的最后修改时间'")
  @SaturnColumn(description = "草稿的最后修改时间")
  private Date modifyTime;
  /**
   * 重命名后的文件名（包括后缀）
   */
  @ApiModelProperty(name = "fileName", value = "重命名后的文件名（包括后缀）")
  @Column(name = "file_name", nullable = false, columnDefinition = "varchar(255) COMMENT '重命名后的文件名（包括后缀）'")
  @SaturnColumn(description = "重命名后的文件名（包括后缀）")
  private String fileName;
  /**
   * 能够唯一标定文件在存储层面的信息。一般来说为文件的相对路径
   * 至于实际上是什么，完全取决于文件服务接口的具体实现
   */
  @ApiModelProperty(name = "fileCode", value = "文件的相对路径（包括已被重命名的，保证唯一性的完整文件名）")
  @Column(name = "file_code", nullable = false, columnDefinition = "varchar(255) COMMENT '文件的相对路径（包括已被重命名的，保证唯一性的完整文件名）'")
  @SaturnColumn(description = "文件的相对路径")
  private String fileCode;
  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("当前项目名工程名")
  @Column(name="project_name", nullable = false, columnDefinition = "varchar(255) default '' comment '工程名'")
  @SaturnColumn(description = "工程名")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }
  public String getCode() {
    return code;
  }
  public void setCode(String code) {
    this.code = code;
  }
  public String getName() { return name; }
  public void setName(String name) { this.name = name; }
  public String getCversion() {
    return cversion;
  }
  public String getTableName() {
    return tableName;
  }
  public void setTableName(String tableName) {
    this.tableName = tableName;
  }
  public void setCversion(String cversion) {
    this.cversion = cversion;
  }
  public Date getCreateTime() {
    return createTime;
  }
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
  public Date getModifyTime() {
    return modifyTime;
  }
  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }
  public String getFileName() {
    return fileName;
  }
  public void setFileName(String fileName) {
    this.fileName = fileName;
  }
  public String getFileCode() {
    return fileCode;
  }
  public void setFileCode(String fileCode) {
    this.fileCode = fileCode;
  }
}
