package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.user.common.vo.UserVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;
import java.util.Set;

/**
 * 该功能模型用于记录，基于列表模板的批量业务数据导入功能的导入模板文件、导入状态、导入数据的信息
 *
 * @author Keller
 * @create 2020/8/23
 */
@Entity
@Table(name = "engine_form_details_import_box")
@ApiModel(value = "FormDetailsImportBoxEntity", description = "该功能模型用于记录，基于列表模板的批量业务数据导入工具箱文件上传文件与导入记录信息")
@org.hibernate.annotations.Table(appliesTo = "engine_form_details_import_box", comment = "该功能模型用于记录，基于列表模板的批量业务数据导入工具箱文件上传文件与导入记录信息")
public class FormDetailsImportBoxEntity extends UuidEntity {

  private static final long serialVersionUID = -5565106603860135570L;

  /**
   * 文件在本地存储路径
   */
  @Column(name = "relative_local", length = 255, nullable = false, columnDefinition = "varchar(255) COMMENT '文件在本地存储路径'")
  @ApiModelProperty(name = "relativeLocal", value = "文件在本地存储路径", required = true)
  @SaturnColumn(description = "文件在本地存储路径")
  private String relativeLocal;

  /**
   * 重命名后的文件名字
   */
  @ApiModelProperty(name = "fileName", value = "重命名后的文件名字", required = true)
  @Column(name = "file_name", nullable = false, columnDefinition = "varchar(255) COMMENT '重命名后的文件名字'")
  @SaturnColumn(description = "重命名后的文件名字")
  private String fileName;

  /**
   * 上传文件原名
   */
  @Column(name = "original_file_name", length = 255, columnDefinition = "varchar(255) COMMENT '上传文件原名'")
  @ApiModelProperty(name = "originalFileName", value = "上传文件原名")
  @SaturnColumn(description = "上传文件原名")
  private String originalFileName;

  /**
   * 上传文件大小
   */
  @Column(name = "file_size", columnDefinition = "bigint COMMENT '上传文件大小'")
  @ApiModelProperty(name = "fileSize", value = "上传文件大小")
  @SaturnColumn(description = "上传文件大小")
  private Long fileSize;

  /**
   * 上传人
   */
  @Column(name = "creator", nullable = false, columnDefinition = "varchar(255) COMMENT '上传人'")
  @ApiModelProperty(name = "creator", value = "上传人", required = true)
  @SaturnColumn(description = "上传人")
  private String creator;

  /**
   * 上传人
   */
  @Transient
  @ApiModelProperty(name = "creator", value = "上传人", required = true)
  @SaturnColumn(description = "上传人")
  private UserVo createUser;

  /**
   * 上传时间
   */
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '上传时间'")
  @ApiModelProperty(name = "createTime", value = "上传时间", required = true)
  @SaturnColumn(description = "上传时间")
  private Date createTime;

  /**
   * 任务执行人
   */
  @Column(name = "executor", columnDefinition = "varchar(255) COMMENT '任务执行人'")
  @ApiModelProperty(name = "executor", value = "任务执行人")
  @SaturnColumn(description = "任务执行人")
  private String executor;

  /**
   * 任务执行人
   */
  @Transient
  @ApiModelProperty(name = "executor", value = "任务执行人")
  @SaturnColumn(description = "任务执行人")
  private UserVo executeUser;

  /**
   * 执行开始时间
   */
  @Column(name = "execute_start_time", columnDefinition = "datetime COMMENT '执行开始时间'")
  @ApiModelProperty(name = "executeStartTime", value = "执行开始时间")
  @SaturnColumn(description = "执行开始时间")
  private Date executeStartTime;

  /**
   * 执行结束时间
   */
  @Column(name = "execute_end_time", columnDefinition = "datetime COMMENT '执行结束时间'")
  @ApiModelProperty(name = "executeEndTime", value = "执行结束时间")
  @SaturnColumn(description = "执行结束时间")
  private Date executeEndTime;

  /**
   * 执行结果，1：进行中，2：导入成功，3：已取消，0：导入失败
   */
  @ApiModelProperty("执行结果，1：进行中，2：导入成功，3：已取消，0：导入失败")
  @SaturnColumn(description = "执行结果，1：进行中，2：导入成功，3：已取消，0：导入失败")
  @Column(name = "execute_result", columnDefinition = "int(11) COMMENT '执行结果，1：进行中，2：导入成功，3：已取消，0：导入失败'")
  private Integer executeResult;

  /**
   * 删除标识  true:已删除，false：未删除
   */
  @ApiModelProperty(name = "isDelete", value = "删除标识", required = false)
  @SaturnColumn(description = "删除标识")
  @Column(name = "is_delete", nullable = false, columnDefinition = "bit(1) default 0 comment '删除标识'")
  private Boolean isDelete;

  /**
   * 导入成功数量
   */
  @Column(name = "success_num", nullable = true, columnDefinition = "int(11) COMMENT '导入成功数量'")
  @ApiModelProperty("导入成功数量")
  @SaturnColumn(description = "导入成功数量")
  private Integer successNum;

  /**
   * 导入错误数量
   */
  @Column(name = "failed_num", nullable = true, columnDefinition = "int(11) COMMENT '导入失败数量'")
  @ApiModelProperty("导入失败数量")
  @SaturnColumn(description = "导入失败数量")
  private Integer failedNum;

  /**
   * 导入数据总数量
   */
  @Column(name = "total_num", nullable = true, columnDefinition = "int(11) COMMENT '导入数量总量'")
  @ApiModelProperty("导入数量总量")
  @SaturnColumn(description = "导入数量总量")
  private Integer totalNum;

  /**
   * 错误返回excel文件
   */
  @Column(name = "error_file_name", length = 255, nullable = true, columnDefinition = "varchar(255) COMMENT '错误文件名'")
  @ApiModelProperty(name = "errorFileName", value = "错误文件名", required = false)
  @SaturnColumn(description = "错误文件名")
  private String errorFileName;

  /**
   * 错误文件在本地存储路径
   */
  @Column(name = "error_file_relative_local", length = 255, nullable = true, columnDefinition = "varchar(255) COMMENT '文件在本地存储路径'")
  @ApiModelProperty(name = "errorFileRelativeLocal", value = "文件在本地存储路径", required = false)
  @SaturnColumn(description = "错误文件在本地存储路径")
  private String errorFileRelativeLocal;

  /**
   * 模板名称
   */
  @Column(name = "template_name", nullable = true, columnDefinition = "varchar(255) COMMENT '模板名称'")
  @ApiModelProperty(name = "templateName", value = "模板名称", required = false)
  @SaturnColumn(description = "模板名称")
  private String templateName;

  /**
   * 模板编号
   */
  @Column(name = "template_code", nullable = true, columnDefinition = "varchar(255) COMMENT '模板编号'")
  @ApiModelProperty(name = "templateCode", value = "模板编号", required = false)
  @SaturnColumn(description = "模板编号")
  private String templateCode;

  /**
   * 模板版本
   */
  @Column(name = "template_version", nullable = true, columnDefinition = "varchar(255) COMMENT '模板版本'")
  @ApiModelProperty(name = "templateVersion", value = "模板版本", required = false)
  @SaturnColumn(description = "模板版本")
  private String templateVersion;

  /**
   * 模板版本
   */
  @Column(name = "btn_code", nullable = true, columnDefinition = "varchar(255) COMMENT '按钮编号'")
  @ApiModelProperty(name = "btnCode", value = "按钮编号", required = false)
  @SaturnColumn(description = "按钮编号")
  private String btnCode;

  /**
   * 列表模板名称
   */
  @Column(name = "list_template_name", nullable = true, columnDefinition = "varchar(255) COMMENT '列表模板名称'")
  @ApiModelProperty(name = "listTemplateName", value = "列表模板名称", required = false)
  @SaturnColumn(description = "列表模板编号")
  private String listTemplateName;

  /**
   * 列表模板编号
   */
  @Column(name = "list_template_code", nullable = true, columnDefinition = "varchar(255) COMMENT '列表模板编号'")
  @ApiModelProperty(name = "listTemplateCode", value = "列表模板编号", required = false)
  @SaturnColumn(description = "列表模板编号")
  private String listTemplateCode;

  /**
   * 列表模板版本
   */
  @Column(name = "list_template_version", nullable = true, columnDefinition = "varchar(255) COMMENT '列表模板版本'")
  @ApiModelProperty(name = "listTemplateVersion", value = "列表模板版本", required = false)
  @SaturnColumn(description = "列表模板版本")
  private String listTemplateVersion;

  /**
   * 导入处理类
   */
  @Column(name = "process_class_name", nullable = true, columnDefinition = "varchar(255) COMMENT '导入处理类'")
  @ApiModelProperty(name = "processClassName", value = "导入处理类", required = false)
  @SaturnColumn(description = "导入处理类")
  private String processClassName;

  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("当前项目名工程名")
  @Column(name="project_name", nullable = false, columnDefinition = "varchar(255) default '' comment '工程名'")
  @SaturnColumn(description = "工程名")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  /**
   * 错误信息
   */
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "formDetailsImportBoxEntity")
  @SaturnColumn(description = "关联导入详细信息")
  private Set<FormDetailsImportBoxDetailsEntity> formDetailsImportBoxDetailsEntities;

  public String getRelativeLocal() {
    return relativeLocal;
  }

  public void setRelativeLocal(String relativeLocal) {
    this.relativeLocal = relativeLocal;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getOriginalFileName() {
    return originalFileName;
  }

  public void setOriginalFileName(String originalFileName) {
    this.originalFileName = originalFileName;
  }

  public String getCreator() {
    return creator;
  }

  public void setCreator(String creator) {
    this.creator = creator;
  }

  public UserVo getCreateUser() {
    return createUser;
  }

  public void setCreateUser(UserVo createUser) {
    this.createUser = createUser;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public String getExecutor() {
    return executor;
  }

  public void setExecutor(String executor) {
    this.executor = executor;
  }

  public UserVo getExecuteUser() {
    return executeUser;
  }

  public void setExecuteUser(UserVo executeUser) {
    this.executeUser = executeUser;
  }

  public Date getExecuteStartTime() {
    return executeStartTime;
  }

  public void setExecuteStartTime(Date executeStartTime) {
    this.executeStartTime = executeStartTime;
  }

  public Date getExecuteEndTime() {
    return executeEndTime;
  }

  public void setExecuteEndTime(Date executeEndTime) {
    this.executeEndTime = executeEndTime;
  }

  public Integer getExecuteResult() {
    return executeResult;
  }

  public void setExecuteResult(Integer executeResult) {
    this.executeResult = executeResult;
  }

  public Boolean getDelete() {
    return isDelete;
  }

  public void setDelete(Boolean delete) {
    isDelete = delete;
  }

  public Integer getSuccessNum() {
    return successNum;
  }

  public void setSuccessNum(Integer successNum) {
    this.successNum = successNum;
  }

  public Integer getFailedNum() {
    return failedNum;
  }

  public void setFailedNum(Integer failedNum) {
    this.failedNum = failedNum;
  }

  public Integer getTotalNum() {
    return totalNum;
  }

  public void setTotalNum(Integer totalNum) {
    this.totalNum = totalNum;
  }

  public String getErrorFileName() {
    return errorFileName;
  }

  public void setErrorFileName(String errorFileName) {
    this.errorFileName = errorFileName;
  }

  public String getErrorFileRelativeLocal() {
    return errorFileRelativeLocal;
  }

  public void setErrorFileRelativeLocal(String errorFileRelativeLocal) {
    this.errorFileRelativeLocal = errorFileRelativeLocal;
  }

  public String getTemplateCode() {
    return templateCode;
  }

  public void setTemplateCode(String templateCode) {
    this.templateCode = templateCode;
  }

  public String getTemplateVersion() {
    return templateVersion;
  }

  public void setTemplateVersion(String templateVersion) {
    this.templateVersion = templateVersion;
  }

  public String getProcessClassName() {
    return processClassName;
  }

  public void setProcessClassName(String processClassName) {
    this.processClassName = processClassName;
  }

  public String getTemplateName() {
    return templateName;
  }

  public void setTemplateName(String templateName) {
    this.templateName = templateName;
  }

  public String getBtnCode() {
    return btnCode;
  }

  public void setBtnCode(String btnCode) {
    this.btnCode = btnCode;
  }

  public String getListTemplateCode() {
    return listTemplateCode;
  }

  public void setListTemplateCode(String listTemplateCode) {
    this.listTemplateCode = listTemplateCode;
  }

  public String getListTemplateVersion() {
    return listTemplateVersion;
  }

  public void setListTemplateVersion(String listTemplateVersion) {
    this.listTemplateVersion = listTemplateVersion;
  }

  public String getListTemplateName() {
    return listTemplateName;
  }

  public void setListTemplateName(String listTemplateName) {
    this.listTemplateName = listTemplateName;
  }

  public Long getFileSize() {
    return fileSize;
  }

  public void setFileSize(Long fileSize) {
    this.fileSize = fileSize;
  }

  public Set<FormDetailsImportBoxDetailsEntity> getFormDetailsImportBoxDetailsEntities() {
    return formDetailsImportBoxDetailsEntities;
  }

  public void setFormDetailsImportBoxDetailsEntities(Set<FormDetailsImportBoxDetailsEntity> formDetailsImportBoxDetailsEntities) {
    this.formDetailsImportBoxDetailsEntities = formDetailsImportBoxDetailsEntities;
  }
}
