package com.bizunited.platform.kuiper.entity;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

import org.hibernate.annotations.GenericGenerator;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

/**
 * 各种实体层对象的定义中，只要属于静态表单模板的主业务模型，都要集成该类<br>
 * 这个父类中将会有一个formInstanceId字段，这个字段的值将在创建业务表单实例时，将会有表单引擎进行生成和绑定</p>
 * 
 * 从2020年10月24日开始，nebula V2.2.X的版本中，做出一个较大的关于模型的调整：</br>
 * 1、使用nebula产品中kuiper表单引擎的模型，不再必须引入FormInstanceUuidEntity父类了，即使需要使用该父类，也不再需要必须填入formInstanceId属性了；</br>
 * 2、修改后，使用FormInstanceUuidEntity父类的场景变成了：模型需要在表单引擎中作为主模型使用，且该模型所驱动的表单需要生成表单实例号，以便获得较长生命周期</br>
 * 3、修改后，如果模型需要在表单引擎中使用，但是无需拥有表单实例，则可以使用FormStatelessUuidEntity作为父类
 * @see FormStatelessEntity
 * @author yinwenjie
 */
@MappedSuperclass
public abstract class FormInstanceUuidEntity implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 6357586662390821565L;
  /**
   * 抽象实体层模型（MySQL主键）的编号信息.
   */
  @Id
  @GeneratedValue(generator = "uuid")
  @GenericGenerator(name = "uuid", strategy = "org.hibernate.id.UUIDGenerator")
  private String id;
  
  /**
   * 业务表数据对应的表单实例编号
   */
  @Column(name="form_instance_id" , nullable=true , unique=true , updatable=false, columnDefinition = "varchar(255) COMMENT '业务表数据对应的表单实例编号'")
  @SaturnColumn(description="表单实例编号" , updatable=false)
  private String formInstanceId;


  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getFormInstanceId() {
    return formInstanceId;
  }

  public void setFormInstanceId(String formInstanceId) {
    this.formInstanceId = formInstanceId;
  }
}