package com.bizunited.platform.kuiper.entity;

import java.io.Serializable;

import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

import org.hibernate.annotations.GenericGenerator;

/**
 * 从2020年10月24日开始，nebula产品中加入了对无状态表单的支持，无状态表单无需指定forminstanceid，但是同样需要在模型设计时指定主模型。</br>
 * 这是因为生成代码时，主模型的代码和非主模型的代码是不一样的。这时，需要使用该类作为无状态表单所对应entity模型的父类。
 * @author yinwenjie
 */
@MappedSuperclass
public class FormStatelessEntity implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = -6599688376515364947L;
  /**
   * 抽象实体层模型（MySQL主键）的编号信息.
   */
  @Id
  @GeneratedValue(generator = "uuid")
  @GenericGenerator(name = "uuid", strategy = "org.hibernate.id.UUIDGenerator")
  private String id;
  public String getId() {
    return id;
  }
  public void setId(String id) {
    this.id = id;
  }
}
