package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import java.util.Date;

@ApiModel("表单实例流转（可见性）基本信息描述")
@Table(name="engine_form_instance_activity" , indexes={@Index(columnList="create_time,instance_id")})
@Entity
@org.hibernate.annotations.Table(appliesTo = "engine_form_instance_activity" , comment = "表单实例流转（可见性）基本信息描述")
public class InstanceActivityEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = -1104519627814197298L;
  /**
   * 唯一外部系统业务编号
   */
  @ApiModelProperty(name="taskCode" , value="唯一外部系统业务编号（如果不传递，则表单引擎系统将以当前活动id进行填充）" , required=false)
  @Column(name="task_code" , length=128 , nullable=false , unique=true, columnDefinition = "varchar(128) COMMENT '唯一外部系统业务编号'")
  @SaturnColumn(description="唯一外部系统业务编号")
  private String taskCode;
  /**
   * 活动创建者
   */
  @ApiModelProperty(name="creator" , value="活动创建者" , required=true)
  @Column(name="creator" , length=128 , nullable=false, columnDefinition = "varchar(128) COMMENT '活动创建者'")
  @SaturnColumn(description="活动创建者")
  private String creator;
  /**
   * 实例创建时间
   */
  @ApiModelProperty(name="createTime" , value="实例创建时间" , required=true)
  @Column(name="create_time" , nullable=false, columnDefinition = "datetime COMMENT '实例创建时间'")
  @SaturnColumn(description="实例创建时间")
  private Date createTime;
  /**
   * 最后的维护人
   */
  @ApiModelProperty(name="modifyer" , value="最后的维护人" , required=true)
  @Column(name="modifyer" , length=128 , nullable=false, columnDefinition = "varchar(128) COMMENT '最后的维护人'")
  @SaturnColumn(description="最后的维护人")
  private String modifyer;
  /**
   * 最后的维护时间
   */
  @ApiModelProperty(name="modifyTime" , value="最后的维护时间" , required=true)
  @Column(name="modify_time" , nullable=false, columnDefinition = "datetime COMMENT '最后的维护时间'")
  @SaturnColumn(description="最后的维护时间")
  private Date modifyTime;
  
  /**
   * 可能的上一个实例事件（如果创建时没有传入，则以最后的创建时间进行排序确认）
   */
  @ApiModelProperty(name="previousInstanceVisibility" , value="可能的上一个实例事件（如果创建时没有传入，则以最后的创建时间进行排序确认）" , required=false)
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="previous_id" , nullable=true, columnDefinition = "varchar(255) COMMENT '可能的上一个实例事件（如果创建时没有传入，则以最后的创建时间进行排序确认）'")
  @SaturnColumn(description="可能的上一个实例事件")
  private InstanceActivityEntity previousActivity;
  /**
   * 对应的实例信息
   */
  @ApiModelProperty(name="instance" ,  hidden=true , required=true)
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="instance_id" , nullable=false, columnDefinition = "varchar(255) COMMENT '对应的实例信息'")
  @SaturnColumn(description="对应的实例信息")
  private InstanceEntity instance;
  /**
   * 表单实例对应的模板信息(这里就包括了版本信息)
   */
  @ApiModelProperty(name="template" ,  hidden=true , required=true)
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="template_id" , nullable=false, columnDefinition = "varchar(255) COMMENT '表单实例对应的模板信息(这里就包括了版本信息)'")
  @SaturnColumn(description="对应过的模板信息")
  private TemplateEntity template;
  /**
   * 对应过的可见性信息
   */
  @ApiModelProperty(name="templateVisibility" ,  hidden=true , required=true)
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="template_visibility_id" , nullable=false, columnDefinition = "varchar(255) COMMENT '对应过的可见性信息'")
  @SaturnColumn(description="对应过的可见性信息")
  private TemplateVisibilityEntity templateVisibility;
  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("当前项目名工程名")
  @Column(name="project_name", nullable = false, columnDefinition = "varchar(255) default '' comment '工程名'")
  @SaturnColumn(description = "工程名")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }
  public Date getCreateTime() {
    return createTime;
  }
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
  public Date getModifyTime() {
    return modifyTime;
  }
  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }
  public InstanceActivityEntity getPreviousActivity() {
    return previousActivity;
  }
  public void setPreviousActivity(InstanceActivityEntity previousActivity) {
    this.previousActivity = previousActivity;
  }
  public InstanceEntity getInstance() {
    return instance;
  }
  public void setInstance(InstanceEntity instance) {
    this.instance = instance;
  }
  public TemplateEntity getTemplate() {
    return template;
  }
  public void setTemplate(TemplateEntity template) {
    this.template = template;
  }
  public TemplateVisibilityEntity getTemplateVisibility() {
    return templateVisibility;
  }
  public void setTemplateVisibility(TemplateVisibilityEntity templateVisibility) {
    this.templateVisibility = templateVisibility;
  }
  public String getTaskCode() {
    return taskCode;
  }
  public void setTaskCode(String taskCode) {
    this.taskCode = taskCode;
  }
  public String getCreator() {
    return creator;
  }
  public void setCreator(String creator) {
    this.creator = creator;
  }
  public String getModifyer() {
    return modifyer;
  }
  public void setModifyer(String modifyer) {
    this.modifyer = modifyer;
  }
}