package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import java.util.Date;
import java.util.List;

@ApiModel("表单实例基本信息描述")
@Entity
@Table(name="engine_form_instance" , indexes={@Index(columnList="create_time"),
                                              @Index(columnList="project_name,domain")})
@org.hibernate.annotations.Table(appliesTo = "engine_form_instance" , comment = "表单实例基本信息描述")
public class InstanceEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = -1104519627814197298L;
  /**
   * 表单模板可能所属的业务域（由主模型传导过来）
   */
  @ApiModelProperty(name="domain" , value="表单模板可能所属的业务域（由主模型传导过来" , required=true)
  @Column(name="domain" , length=64 , nullable=false, columnDefinition = "varchar(64) COMMENT '表单模板可能所属的业务域（由主模型传导过来）'")
  @SaturnColumn(description="可能所属的业务域")
  private String domain = "";
  /**
   * 可能的项目名，不填写也行，毕竟目前来看只可能是一个项目
   */
  @ApiModelProperty(name="projectName" , value="项目名，不填写也行，毕竟目前来看只可能是一个项目" , required=false)
  @Column(name="project_name" ,  columnDefinition = "varchar(255) COMMENT '可能的项目名，不填写也行，毕竟目前来看只可能是一个项目'")
  @SaturnColumn(description="项目名")
  private String projectName;
  /**
   * 表单实例对应的模板信息(这里就包括了版本信息)
   */
  @ApiModelProperty(name="template" ,  hidden=true , required=false)
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="template_id" , nullable=false, columnDefinition = "varchar(255) COMMENT '表单实例对应的模板信息(这里就包括了版本信息)'")
  @SaturnColumn(description="对应过的模板名")
  private TemplateEntity template;
  /**
   * 实例创建者
   */
  @ApiModelProperty(name="creator" , value="实例创建者" , hidden=true , required=true)
  @Column(name="creator" , length=128 , nullable=true, columnDefinition = "varchar(128) COMMENT '实例创建者'")
  @SaturnColumn(description="实例创建者")
  private String creator;
  /**
   * 实例创建时间
   */
  @ApiModelProperty(name="createTime" , value="实例创建时间" , required=false)
  @Column(name="create_time" , nullable=true, columnDefinition = "datetime COMMENT '实例创建时间'")
  @SaturnColumn(description="实例创建时间")
  private Date createTime;
  /**
   * 实例对应的活动信息（并且按照创建时间反序排列）
   */
  @ApiModelProperty(name="activities" , value="实例对应的活动信息" , hidden=true)
  @OneToMany(fetch=FetchType.LAZY , mappedBy="instance")
  @SaturnColumn(description="对应的活动信息")
  @OrderBy("createTime desc")
  private List<InstanceActivityEntity> activities;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public String getDomain() {
    return domain;
  }
  public void setDomain(String domain) {
    this.domain = domain;
  }
  public TemplateEntity getTemplate() {
    return template;
  }
  public void setTemplate(TemplateEntity template) {
    this.template = template;
  }
  public Date getCreateTime() {
    return createTime;
  }
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
  public List<InstanceActivityEntity> getActivities() {
    return activities;
  }
  public void setActivities(List<InstanceActivityEntity> activities) {
    this.activities = activities;
  }
  public String getCreator() {
    return creator;
  }
  public void setCreator(String creator) {
    this.creator = creator;
  }
}