package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * InstanceItemImportEntity
 * @description:
 * @author: weitongyan
 * @date: 07/Apr/2019 16:12
 */
@ApiModel("表单实例明细项导入导出日志")
@Entity
@Table(name = "engine_form_instance_item_import")
@org.hibernate.annotations.Table(appliesTo = "engine_form_instance_item_import" , comment = "表单实例明细项导入导出日志")
public class InstanceItemImportEntity extends UuidEntity {

  private static final long serialVersionUID = 2223349262151344562L;

  @ApiModelProperty(name = "templateItemId",value = "表单明细模版Id",required = true)
  @Column(name = "template_item_id",nullable = false, columnDefinition = "varchar(255) COMMENT '表单明细模版Id'")
  @SaturnColumn(description = "表单明细模版Id")
  private String templateItemId;

  @ApiModelProperty(name = "importNum",value = "导入数量")
  @Column(name = "import_num", columnDefinition = "int(11) COMMENT '导入数量'")
  @SaturnColumn(description = "导入数量")
  private Integer importNum;

  @ApiModelProperty(name = "importDate",value = "导入日期")
  @Column(name = "import_date", columnDefinition = "datetime COMMENT '导入日期'")
  @SaturnColumn(description = "导入日期")
  private Date importDate;

  @Column(name = "operator", columnDefinition = "varchar(255) COMMENT '导入操作者'")
  @ApiModelProperty(name = "operator",value = "导入操作者")
  @SaturnColumn(description = "导入操作者")
  private String operator;

  @ApiModelProperty(name = "uploadPath",value = "上传路径")
  @Column(name = "upload_path", columnDefinition = "varchar(255) COMMENT '上传路径'")
  @SaturnColumn(description = "上传路径")
  private String uploadPath;

  @ApiModelProperty(name = "excelName",value = "EXCEL保存名称",required = true)
  @Column(name = "excel_name",nullable = false, columnDefinition = "varchar(255) COMMENT 'EXCEL保存名称'")
  @SaturnColumn(description = "EXCEL保存名称")
  private String excelName;

  @ApiModelProperty(name = "originalExcelName",value = "EXCEL原始名称")
  @Column(name = "original_excel_name", columnDefinition = "varchar(255) COMMENT 'EXCEL原始名称'")
  @SaturnColumn(description = "EXCEL原始名称")
  private String originalExcelName;

  @ApiModelProperty(name = "ordinaryFileId",value = "EXCEL文件ID")
  @Column(name = "ordinary_file_id")
  @SaturnColumn(description = "EXCEL文件ID")
  private String ordinaryFileId;
  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("当前项目名工程名")
  @Column(name="project_name", nullable = false, columnDefinition = "varchar(255) default '' comment '工程名'")
  @SaturnColumn(description = "工程名")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public String getTemplateItemId() {
    return templateItemId;
  }

  public void setTemplateItemId(String templateItemId) {
    this.templateItemId = templateItemId;
  }

  public Integer getImportNum() {
    return importNum;
  }

  public void setImportNum(Integer importNum) {
    this.importNum = importNum;
  }

  public Date getImportDate() {
    return importDate;
  }

  public void setImportDate(Date importDate) {
    this.importDate = importDate;
  }

  public String getUploadPath() {
    return uploadPath;
  }

  public void setUploadPath(String uploadPath) {
    this.uploadPath = uploadPath;
  }

  public String getExcelName() {
    return excelName;
  }

  public void setExcelName(String excelName) {
    this.excelName = excelName;
  }

  public String getOriginalExcelName() {
    return originalExcelName;
  }

  public void setOriginalExcelName(String originalExcelName) {
    this.originalExcelName = originalExcelName;
  }

  public String getOrdinaryFileId() {
    return ordinaryFileId;
  }

  public void setOrdinaryFileId(String ordinaryFileId) {
    this.ordinaryFileId = ordinaryFileId;
  }

  public String getOperator() {
    return operator;
  }

  public void setOperator(String operator) {
    this.operator = operator;
  }
}
