package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Subselect;
import org.hibernate.annotations.Synchronize;

import javax.persistence.Column;
import javax.persistence.Entity;
import java.util.Date;

@ApiModel("表单实例基本信息描述——实例视图，只作为查询不作为数据操作的依据")
@Entity(name="InstanceViewEntity")
@Immutable
@Synchronize({"engine_form_instance"})
@Subselect(value="select engine_form_instance.id, engine_form_instance.domain , engine_form_instance.project_name , engine_form_instance.creator as ins_creator_id , "
    + " engine_form_instance.create_time , engine_form_template.id as template_id , engine_form_template.type as template_type , engine_form_template.persistent_classname , "
    + " engine_form_template.code as template_code , engine_form_template.cversion , engine_form_template.name as template_name , "
    + " engine_form_template.repository_entity , engine_form_template.default_version , engine_form_template.create_time as template_create_time ,"
    + " engine_form_template.form_style , engine_form_template.tstatus as template_tstatus , engine_form_template.creator as template_creator_id , "
    + " engine_user.user_name as ins_creator_user_name , engine_user.user_account as ins_creator_account "
    + " from engine_form_instance "
    + " left join engine_form_template on engine_form_instance.template_id= engine_form_template.id"
    + " left join engine_user on engine_form_instance.creator = engine_user.id")
public class InstanceViewEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = -1104519627814197298L;
  /**
   * 表单模板可能所属的业务域（由主模型传导过来）
   */
  @ApiModelProperty(name="domain" , value="表单模板可能所属的业务域（由主模型传导过来" , required=true)
  @Column(name="domain" , length=64 , nullable=false)
  @SaturnColumn(description="可能所属的业务域")
  private String domain = "";
  /**
   * 可能的项目名，不填写也行，毕竟目前来看只可能是一个项目
   */
  @ApiModelProperty(name="projectName" , value="项目名，不填写也行，毕竟目前来看只可能是一个项目" , required=false)
  @Column(name="project_name" , nullable=true)
  @SaturnColumn(description="项目名")
  private String projectName;
  /**
   * 表单实例对应的模板信息(这里就包括了版本信息)
   */
  @ApiModelProperty(name="template" ,  hidden=true , required=false)
  @Column(name="template_id" , nullable=false)
  @SaturnColumn(description="对应过的模板名")
  private String templateId;
  /**
   * 实例创建者
   */
  @ApiModelProperty(name="ins_creator_id" , value="实例创建者" , required=false)
  @Column(name="ins_creator_id" , nullable=true)
  @SaturnColumn(description="实例创建者")
  private String insCreator;
  /**
   * 实例创建时间
   */
  @ApiModelProperty(name="createTime" , value="实例创建时间" , required=false)
  @Column(name="create_time" , length=128 , nullable=true)
  @SaturnColumn(description="实例创建时间")
  private Date createTime;
  
  /**
   * 表单模板来源类型，目前有三种：<br>
   * static：静态模型——依据当前业务工程中数据实体层类定义描述生成的表单引擎模型<br>
   * dynamic：动态模型——依据业务操作人员页面设定的数据表生成的表单引擎模型<br>
   * dsl：dsl模型——依据业务操作者、开发人员通过DSL规范语言描述生成的表单引擎模型<br>
   */
  @ApiModelProperty(name="type" , value="表单模板来源类型，目前有三种：static：静态模型;dynamic：动态模型;dsl：dsl模型，其它值无效" , required=true)
  @Column(name="template_type" , length=32 , nullable=false)
  @SaturnColumn(description="表单模板来源类型")
  private String templateType = "static"; 
  
  /**
   * 如果是静态模型（type = "static"），
   * 那么该字段记录静态模型的完成类型
   */
  @ApiModelProperty(name="persistentClassName" , value="静态模型的完成类型" , required=true)
  @Column(name="persistent_classname" , length=128 , nullable=false)
  @SaturnColumn(description="静态模型的完成类型")
  private String persistentClassName = "";
  
  @ApiModelProperty(name="templateCode" , value="表单模板的唯一编号，唯一编号和版本号，将可以定位到唯一一个表单模板"
      + "一般来说，静态模板类型的编号就是这个静态模板的完整主类名" , required=true)
  @Column(name="template_code" , length=128 , nullable=false)
  @SaturnColumn(description="表单模板的唯一编号")
  private String templateCode = "";
  
  /**
   * 表单模板在表单引擎中，相同的表单模板编号有不同的版本信息
   */
  @ApiModelProperty(name="cversion" , value="表单模板在表单引擎中，相同的表单模板编号有不同的版本信息" , required=true)
  @Column(name="cversion" , length=64 , nullable=false)
  @SaturnColumn(description="不同的版本信息")
  private String cversion;
  
  /**
   * 表单模板模板名，例如付款申请表
   */
  @ApiModelProperty(name="templateName" , value="表单模板模板名，例如付款申请表" , required=true)
  @Column(name="template_name" , length=128 , nullable=false)
  @SaturnColumn(description="模板名")
  private String templateName;
  
  /**
   * 这个表单模板是否有数据层信息进行支撑 
   */
  @ApiModelProperty(name="repositoryEntity" , value="这个表单模板是否有数据层信息进行支撑 " , required=true)
  @Column(name="repository_entity" , nullable=false)
  @SaturnColumn(description="是否有数据层信息进行支撑 ")
  private Boolean repositoryEntity = true;
  
  /**
   * 当前表单模板版本是否是当前表单模板的默认版本
   */
  @ApiModelProperty(name="defaultVersion" , value="当前表单模板版本是否是当前表单模板的默认版本" , required=true)
  @Column(name="default_version" , nullable=false)
  @SaturnColumn(description="是否是当前表单模板的默认版本")
  private Boolean defaultVersion = false;
  
  /**
   * 当前表单模板（精确到每个版本）的创建时间，yyyy-MM-dd HH:mm:ss
   */
  @ApiModelProperty(name="templateCreateTime" , value="当前表单模板（精确到每个版本）的创建时间" , required=true)
  @Column(name="template_create_time" , nullable=false)
  @SaturnColumn(description="创建时间")
  private Date templateCreateTime;
  
  /**
   * 表单模板目前使用的样式
   */
  @ApiModelProperty(name="formStyle" , value="表单模板目前使用的样式" , hidden=true , required=true)
  @Column(name="form_style" , length=64 , nullable=false)
  @SaturnColumn(description="表单模板样式")
  private String formStyle = "";
  
  /**
   * 表单模板状态：1草稿（未发布）；2正常（已发布）；0禁止/废除
   */
  @ApiModelProperty(name="templateStatus" , value="表单模板状态：1草稿（未发布）；2正常（已发布）；0禁止/废除" , hidden=true , required=true)
  @Column(name="template_tstatus" , length=64 , nullable=false)
  @SaturnColumn(description="表单模板状态")
  private Integer templateStatus = 1;
  
  /**
   * 模板创建人
   */
  @ApiModelProperty(name="createTime" , value="模板创建人" , hidden=true , required=true)
  @Column(name="template_creator_id" , nullable=false)
  @SaturnColumn(description="创建人")
  private String templateCreator;
  
  @ApiModelProperty(name="creatorUserName" , value="实例创建者人员姓名" , required=true)
  @Column(name = "ins_creator_user_name", length = 64, nullable = false)
  @SaturnColumn(description="实例创建者人员姓名")
  private String creatorUserName;
  
  @ApiModelProperty(name="account" , value="实例创建者登录账号" , required=true)
  @Column(name = "ins_creator_account", length = 64, nullable = false, unique = true)
  @SaturnColumn(description="实例创建者登录账号")
  private String creatorAccount;
  
  public String getProjectName() {
    return projectName;
  }
  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }
  public String getDomain() {
    return domain;
  }
  public void setDomain(String domain) {
    this.domain = domain;
  }
  public String getTemplateId() {
    return templateId;
  }
  public void setTemplateId(String templateId) {
    this.templateId = templateId;
  }
  public String getInsCreator() {
    return insCreator;
  }
  public void setInsCreator(String insCreator) {
    this.insCreator = insCreator;
  }
  public Date getCreateTime() {
    return createTime;
  }
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
  public String getTemplateType() {
    return templateType;
  }
  public void setTemplateType(String templateType) {
    this.templateType = templateType;
  }
  public String getPersistentClassName() {
    return persistentClassName;
  }
  public void setPersistentClassName(String persistentClassName) {
    this.persistentClassName = persistentClassName;
  }
  public String getTemplateCode() {
    return templateCode;
  }
  public void setTemplateCode(String templateCode) {
    this.templateCode = templateCode;
  }
  public String getCversion() {
    return cversion;
  }
  public void setCversion(String cversion) {
    this.cversion = cversion;
  }
  public String getTemplateName() {
    return templateName;
  }
  public void setTemplateName(String templateName) {
    this.templateName = templateName;
  }
  public Boolean getRepositoryEntity() {
    return repositoryEntity;
  }
  public void setRepositoryEntity(Boolean repositoryEntity) {
    this.repositoryEntity = repositoryEntity;
  }
  public Boolean getDefaultVersion() {
    return defaultVersion;
  }
  public void setDefaultVersion(Boolean defaultVersion) {
    this.defaultVersion = defaultVersion;
  }
  public Date getTemplateCreateTime() {
    return templateCreateTime;
  }
  public void setTemplateCreateTime(Date templateCreateTime) {
    this.templateCreateTime = templateCreateTime;
  }
  public String getFormStyle() {
    return formStyle;
  }
  public void setFormStyle(String formStyle) {
    this.formStyle = formStyle;
  }
  public Integer getTemplateStatus() {
    return templateStatus;
  }
  public void setTemplateStatus(Integer templateStatus) {
    this.templateStatus = templateStatus;
  }
  public String getTemplateCreator() {
    return templateCreator;
  }
  public void setTemplateCreator(String templateCreator) {
    this.templateCreator = templateCreator;
  }
  public String getCreatorUserName() {
    return creatorUserName;
  }
  public void setCreatorUserName(String creatorUserName) {
    this.creatorUserName = creatorUserName;
  }
  public String getCreatorAccount() {
    return creatorAccount;
  }
  public void setCreatorAccount(String creatorAccount) {
    this.creatorAccount = creatorAccount;
  }
}